/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.internal;

import com.inet.annotations.JsonData;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.history.ExecutionHistory;
import com.inet.taskplanner.server.internal.ExecutionInformationImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@JsonData
public final class ExecutionHistoryImpl
implements ExecutionHistory {
    public static final int MAX_HISTORY_SIZE = 10;
    private List<ExecutionInformationImpl> lastExecutions = new ArrayList<ExecutionInformationImpl>();

    public synchronized List<ExecutionInformationImpl> getLastExecutions() {
        return new ArrayList<ExecutionInformationImpl>(this.lastExecutions);
    }

    public synchronized void addExecution(@Nonnull ExecutionInformationImpl execution) {
        this.lastExecutions.add(execution);
        while (this.lastExecutions.size() > 10) {
            ExecutionInformationImpl executionInformationImpl = this.lastExecutions.remove(0);
            if (executionInformationImpl.getExecutionFinishTime() != 0L) continue;
            this.lastExecutions.add(0, executionInformationImpl);
            return;
        }
    }

    synchronized boolean isRunning() {
        for (ExecutionInformationImpl executionInformationImpl : this.lastExecutions) {
            if (executionInformationImpl.getExecutionFinishTime() != 0L) continue;
            return true;
        }
        return false;
    }

    public synchronized void updateExecution(@Nonnull ExecutionInformationImpl execution) {
        for (int i2 = this.lastExecutions.size() - 1; i2 >= 0; --i2) {
            ExecutionInformationImpl executionInformationImpl = this.lastExecutions.get(i2);
            if (!executionInformationImpl.getExecutionId().equals((Object)execution.getExecutionId())) continue;
            this.lastExecutions.set(i2, execution);
            return;
        }
        TaskPlannerServerPlugin.LOGGER.warn((Object)String.format("Cannot find the execution %s", execution.getExecutionId().toString()));
        this.lastExecutions.add(execution);
    }
}

