/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.trigger.filechange;

import com.inet.annotations.InternalApi;
import com.inet.permissions.Permission;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.trigger.filechange.FileChangeObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public interface FileChangeService
extends NamedExtension {
    @Nullable
    public Permission getRequiredPermission();

    public void validatePath(@Nonnull String var1) throws ValidationException;

    @Nonnull
    public FileChangeObserver createObserver(@Nonnull String var1, boolean var2);

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nonnull
    public static List<String> getAllAvailableProtocols() {
        ArrayList<String> arrayList = new ArrayList<String>();
        @Nonnull @Nonnull List list = ServerPluginManager.getInstance().get(FileChangeService.class);
        for (FileChangeService fileChangeService : list) {
            arrayList.add(fileChangeService.getExtensionName());
        }
        Collections.sort(arrayList, (string, string2) -> {
            if ("file".equalsIgnoreCase((String)string)) {
                return 1;
            }
            if ("file".equalsIgnoreCase((String)string2)) {
                return -1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        });
        return arrayList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="It is called by components, which can only be run by users with required permissions.")
    public static FileChangeService getServiceFor(@Nonnull String path) {
        @Nonnull @Nonnull List list = ServerPluginManager.getInstance().get(FileChangeService.class);
        FileChangeService fileChangeService = null;
        for (FileChangeService fileChangeService2 : list) {
            if (path.startsWith(fileChangeService2.getExtensionName())) {
                return fileChangeService2;
            }
            if (!Objects.equals("file", fileChangeService2.getExtensionName())) continue;
            fileChangeService = fileChangeService2;
        }
        return fileChangeService;
    }
}

