/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.series.folder;

import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.angular.filechooser.FSFile;
import com.inet.remote.gui.angular.filechooser.FileSystemService;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FolderField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.series.SeriesInfo;
import com.inet.taskplanner.server.api.series.folder.a;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@PublicApi
public class FolderSeriesFactory
extends SeriesFactory<a> {
    public static final String FOLDER = "folder";
    public static final String FILTER = "filter";

    public FolderSeriesFactory() {
        super("series.folder");
    }

    @Override
    public SeriesInfo getInformation(GUID taskID) {
        URL uRL = this.getClass().getResource("folder.png");
        ArrayList<Field> arrayList = new ArrayList<Field>();
        FolderField folderField = new FolderField(FOLDER, TaskPlannerServerPlugin.MSG.getMsg("series.folder.path", new Object[0]));
        folderField.setProtocols(FolderField.getAllAvailableProtocols());
        arrayList.add(folderField);
        TextField textField = new TextField(FILTER, TaskPlannerServerPlugin.MSG.getMsg("series.folder.filter", new Object[0]));
        textField.setPlaceholder("*.*");
        arrayList.add(textField);
        SeriesInfo seriesInfo = new SeriesInfo(this.getExtensionName(), TaskPlannerServerPlugin.MSG.getMsg("series.folder.displayname", new Object[0]), TaskPlannerServerPlugin.MSG.getMsg("series.folder.description", new Object[0]), uRL, "taskplanner.series.folder", arrayList);
        return seriesInfo;
    }

    @Override
    public void validate(SeriesDefinition definition, GUID taskID) throws ValidationException {
        String string = definition.getProperty(FOLDER);
        if (string == null || string.isEmpty()) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("series.folder.nofolder", new Object[0])});
        }
        try {
            List list = ServerPluginManager.getInstance().get(FileSystemService.class);
            Collections.sort(list, FileSystemService.FILESYSTEMSERVICE_COMPARATOR);
            for (FileSystemService fileSystemService : list) {
                FSFile fSFile;
                if (!fileSystemService.isResponsible(string) || (fSFile = fileSystemService.getFile(string)) != null && fSFile.isDir()) continue;
                throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("series.folder.notexisting", new Object[0])});
            }
        }
        catch (ValidationException validationException) {
            throw validationException;
        }
        catch (Throwable throwable) {
            throw new ValidationException(new String[]{StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable)});
        }
    }

    @Override
    protected a createInstanceFrom(SeriesDefinition definition, GUID taskID) {
        return new a(definition.getProperty(FOLDER), definition.getProperty(FILTER));
    }

    @Override
    public SummaryInfo getSummary(SeriesDefinition definition) {
        String string;
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        String string2 = definition.getProperty(FOLDER);
        if (string2 != null && !string2.isEmpty()) {
            arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("series.folder.path", new Object[0]), string2));
        }
        if ((string = definition.getProperty(FILTER)) == null || string.isEmpty()) {
            string = "*.*";
        }
        arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("series.folder.filter", new Object[0]), string));
        return new SummaryInfo(arrayList);
    }

    @Override
    public Set<String> getKeys(SeriesDefinition definition) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("filepath");
        return hashSet;
    }
}

