/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.result;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

@JsonData
@PublicApi
public final class ResultFlavor {
    private static final List<ResultFlavor> ENUM = new ArrayList<ResultFlavor>();
    public static final ResultFlavor NONE = ResultFlavor.create("NONE");
    public static final ResultFlavor FILE = ResultFlavor.create("FILE");
    public static final ResultFlavor TEXT = ResultFlavor.create("TEXT");
    public static final ResultFlavor PRINT = ResultFlavor.create("PRINT");
    private final String key;
    private FlavorLabel labelFunction;

    private ResultFlavor(@Nonnull String key, FlavorLabel labelFunction) {
        this.key = key;
        this.labelFunction = labelFunction;
    }

    public static ResultFlavor create(@Nonnull String key, FlavorLabel labelFunction) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        ResultFlavor resultFlavor = new ResultFlavor(key, labelFunction);
        if (ENUM.contains(resultFlavor)) {
            throw new IllegalArgumentException(String.format("A ResultFlavor '%s' already exists!", key));
        }
        ENUM.add(resultFlavor);
        return resultFlavor;
    }

    public static ResultFlavor create(@Nonnull String key) {
        return ResultFlavor.create(key, null);
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public static ResultFlavor valueOf(String key) {
        Optional<ResultFlavor> optional = ENUM.stream().filter(rf -> rf.getKey().equals(key)).findFirst();
        return optional.orElseThrow(() -> new IllegalArgumentException("No ResultFlavor found for key " + key));
    }

    public String toString() {
        return this.key;
    }

    public String getLabel() {
        if (this.labelFunction == null) {
            return TaskPlannerServerPlugin.MSG.getMsg("flavor." + this.key, new Object[0]);
        }
        return this.labelFunction.label();
    }

    public static Collection<ResultFlavor> values() {
        return new ArrayList<ResultFlavor>(ENUM);
    }

    @FunctionalInterface
    @PublicApi
    public static interface FlavorLabel {
        public String label();
    }
}

