/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.result;

import com.inet.annotations.PublicApi;
import com.inet.http.utils.MimeTypes;
import com.inet.taskplanner.server.api.result.FileResult;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

@PublicApi
public class LocalFileResult
implements FileResult {
    private final File az;
    private boolean aA;

    public LocalFileResult(@Nonnull File file, boolean deleteOnCleanUp) {
        this.aA = deleteOnCleanUp;
        if (file.isDirectory()) {
            throw new IllegalArgumentException("FileResult can only handle files, not directories!");
        }
        this.az = file;
    }

    @Override
    @Nonnull
    public List<ResultFlavor> getFlavors() {
        return Arrays.asList(ResultFlavor.FILE);
    }

    @Override
    @Nonnull
    public String getFileName() {
        return this.az.getName();
    }

    @Override
    public long getFileSize() {
        return this.az.length();
    }

    @Override
    @Nonnull
    public InputStream getFileContent() throws IOException {
        return new FileInputStream(this.az);
    }

    @Override
    public void cleanup() {
        if (this.aA) {
            this.az.delete();
        }
    }

    @Override
    public String getFileContentType() throws IOException {
        return MimeTypes.getMimeType((String)this.az.getName());
    }
}

