/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner;

import com.inet.notification.Notification;
import com.inet.notification.NotificationManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.event.TaskEvent;
import com.inet.taskplanner.server.api.event.TaskEventListener;
import com.inet.taskplanner.server.api.history.ExecutionHistory;
import com.inet.taskplanner.server.api.history.HistoryEntry;
import java.util.List;

public final class a
implements TaskEventListener {
    @Override
    public void notify(TaskEvent event) {
        if (event.getType() == TaskEvent.TaskEventType.EXECUTION_STARTED || event.getType() == TaskEvent.TaskEventType.EXECUTION_ENDED || event.getType() == TaskEvent.TaskEventType.PROGRESS) {
            TaskDefinition taskDefinition = TaskPlanner.getInstance().getTaskDefinition(event.getTaskID());
            TaskExecution taskExecution = TaskPlanner.getInstance().getTaskExecution(event.getTaskID());
            if (taskExecution == null || taskDefinition == null) {
                return;
            }
            if (taskDefinition.isSystemTask()) {
                return;
            }
            HistoryEntry historyEntry = null;
            ExecutionHistory executionHistory = taskExecution.getExecutionHistory();
            List<? extends HistoryEntry> list = executionHistory.getLastExecutions();
            if (list != null && list.size() > 0) {
                historyEntry = list.get(list.size() - 1);
            }
            if (historyEntry == null || !historyEntry.getExecutionId().equals((Object)event.getExecutionID())) {
                return;
            }
            Notification notification = new Notification("", "");
            notification.setGroupingKey("taskplanner.notification.status");
            notification.setId(event.getTaskID());
            notification.setTargetUrl("/taskplanner".substring(1) + "/" + event.getTaskID().toString());
            if (event.getType() == TaskEvent.TaskEventType.EXECUTION_STARTED) {
                notification.setTitle(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.notification.taskstarted", new Object[]{taskDefinition.getName()}));
                notification.setMessage(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.notification.taskstarted.message", new Object[]{taskDefinition.getName()}));
                notification.setPermanent(true);
                NotificationManager.getInstance().sendNotification(taskExecution.getOwnerId(), notification);
            } else if (event.getType() == TaskEvent.TaskEventType.PROGRESS) {
                if (!taskExecution.isRunning()) {
                    return;
                }
                notification.setTitle(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.notification.taskprogress", new Object[]{taskDefinition.getName()}));
                notification.setMessage(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.notification.taskprogress.message", new Object[]{taskDefinition.getName(), String.valueOf(event.getProgress())}));
                notification.setPermanent(true);
                NotificationManager.getInstance().sendNotification(taskExecution.getOwnerId(), notification);
            } else if (event.getType() == TaskEvent.TaskEventType.EXECUTION_ENDED) {
                List<String> list2 = historyEntry.getErrors();
                if (list2 != null && !list2.isEmpty()) {
                    notification.setCritical(true);
                    notification.setTitle(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.notification.taskfailed", new Object[]{taskDefinition.getName()}));
                    notification.setMessage(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.notification.taskfailed.message", new Object[]{taskDefinition.getName()}));
                    NotificationManager.getInstance().sendNotification(taskExecution.getOwnerId(), notification);
                    notification.setGroupingKey("taskplanner.notification.error");
                    notification.setMessage(list2.get(0));
                    NotificationManager.getInstance().sendNotification(taskExecution.getOwnerId(), notification);
                } else {
                    notification.setTitle(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.notification.tasksuccess", new Object[]{taskDefinition.getName()}));
                    notification.setMessage(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.notification.tasksuccess.message", new Object[]{taskDefinition.getName()}));
                    NotificationManager.getInstance().sendNotification(taskExecution.getOwnerId(), notification);
                }
            }
        }
    }
}

