/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.internalapi;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.ui.TaskOwnerFilter;
import com.inet.taskplanner.server.internal.InternalTask;
import com.inet.taskplanner.server.internal.b;
import com.inet.taskplanner.server.internal.f;
import com.inet.taskplanner.server.internalapi.TaskShortDescription;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class TaskPlannerForUsers {
    private static TaskPlannerForUsers cs;

    public static synchronized TaskPlannerForUsers getInstance() {
        if (cs == null) {
            cs = new TaskPlannerForUsers();
        }
        return cs;
    }

    @Nullable
    public TaskExecution getTaskExecution(@Nonnull GUID taskID) {
        InternalTask internalTask = f.M().h(taskID);
        b.b(internalTask);
        if (internalTask != null && !TaskPlannerForUsers.checkIsValidTaskOwner(internalTask.getOwnerId())) {
            return null;
        }
        return f.M().getTaskExecution(taskID);
    }

    @Nullable
    public TaskDefinition getTaskDefinition(@Nonnull GUID taskID) {
        InternalTask internalTask = f.M().h(taskID);
        b.b(internalTask);
        if (internalTask == null || !TaskPlannerForUsers.checkIsValidTaskOwner(internalTask.getOwnerId())) {
            return null;
        }
        return internalTask != null ? internalTask.getModel().copyTaskModel() : null;
    }

    @Nonnull
    public List<GUID> getUserTaskIDs() {
        return f.M().getUserTaskIDs(b.E());
    }

    public static boolean checkIsValidTaskOwner(GUID taskOwnerAccountId) {
        return ServerPluginManager.getInstance().get(TaskOwnerFilter.class).stream().allMatch(taskOwnerFilter -> taskOwnerFilter.checkIsValidTaskOwner(taskOwnerAccountId));
    }

    @Nonnull
    public List<GUID> getAllTaskIDs() {
        b.F();
        return f.M().getAllTaskIDs();
    }

    @Nullable
    public CompletableFuture<Void> executeTask(@Nonnull GUID taskID) {
        InternalTask internalTask = f.M().h(taskID);
        b.b(internalTask);
        if (internalTask == null || !TaskPlannerForUsers.checkIsValidTaskOwner(internalTask.getOwnerId())) {
            TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Task %s does not exist and can not be started.", taskID));
            return null;
        }
        return f.M().a(internalTask, true, Collections.emptyMap());
    }

    public CompletableFuture<Void> executeTask(@Nonnull TaskDefinition definition) {
        return f.M().executeTask(definition, b.E());
    }

    @Nonnull
    public GUID addTask(@Nonnull TaskDefinition task) {
        return f.M().addTask(task, b.E());
    }

    public void updateTask(@Nonnull GUID taskID, @Nonnull TaskDefinition taskModel) {
        InternalTask internalTask = f.M().h(taskID);
        b.b(internalTask);
        if (internalTask != null && !TaskPlannerForUsers.checkIsValidTaskOwner(internalTask.getOwnerId())) {
            return;
        }
        f.M().updateTask(taskID, taskModel);
    }

    public void removeTask(@Nonnull GUID taskID) {
        InternalTask internalTask = f.M().h(taskID);
        b.b(internalTask);
        if (internalTask != null && !TaskPlannerForUsers.checkIsValidTaskOwner(internalTask.getOwnerId())) {
            return;
        }
        f.M().removeTask(taskID);
    }

    public void activateTask(@Nonnull GUID taskID) {
        InternalTask internalTask = f.M().h(taskID);
        b.b(internalTask);
        if (internalTask != null && !TaskPlannerForUsers.checkIsValidTaskOwner(internalTask.getOwnerId())) {
            return;
        }
        f.M().activateTask(taskID);
    }

    public void deactivateTask(@Nonnull GUID taskID) {
        InternalTask internalTask = f.M().h(taskID);
        b.b(internalTask);
        if (internalTask != null && !TaskPlannerForUsers.checkIsValidTaskOwner(internalTask.getOwnerId())) {
            return;
        }
        f.M().deactivateTask(taskID);
    }

    public void cancelTask(@Nonnull GUID taskID, boolean waitForCancelation) {
        InternalTask internalTask = f.M().h(taskID);
        b.b(internalTask);
        if (internalTask != null && !TaskPlannerForUsers.checkIsValidTaskOwner(internalTask.getOwnerId())) {
            return;
        }
        f.M().cancelTask(taskID, waitForCancelation);
    }

    public void cancelTaskExecution(@Nonnull GUID taskID, @Nullable GUID executionID, boolean waitForCancelation) {
        InternalTask internalTask = f.M().h(taskID);
        b.b(internalTask);
        if (internalTask != null && !TaskPlannerForUsers.checkIsValidTaskOwner(internalTask.getOwnerId())) {
            return;
        }
        f.M().cancelTaskExecution(taskID, executionID, waitForCancelation);
    }

    public List<TaskShortDescription> listUserTasks() {
        return f.M().l(b.E());
    }

    public List<TaskShortDescription> listAllTasks() {
        b.F();
        List<TaskShortDescription> list = f.M().listAllTasks();
        list.removeIf(taskShortDescription -> !TaskPlannerForUsers.checkIsValidTaskOwner(taskShortDescription.getOwnerId()));
        return list;
    }

    public void reloadAll() {
        f.M().reloadAll();
    }
}

