/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.common;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public abstract class AbstractDefinition<T extends AbstractDefinition<T>> {
    private GUID uid;
    private String extensionName;
    private Map<String, String> properties = new HashMap<String, String>();

    public AbstractDefinition(@Nonnull String extensionName) {
        this(extensionName, null);
    }

    public AbstractDefinition(@Nonnull String extensionName, @Nullable Map<String, String> properties) {
        if (extensionName == null) {
            throw new IllegalArgumentException("extension name must not be null");
        }
        this.uid = GUID.generateNew();
        this.extensionName = extensionName;
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    @Nonnull
    public final String getExtensionName() {
        return this.extensionName;
    }

    public void setUid(GUID uid) {
        this.uid = uid;
    }

    public GUID getUid() {
        return this.uid;
    }

    @Nonnull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(@Nullable String key, @Nullable String value) {
        this.properties.put(key, value);
    }

    public String removeProperty(String key) {
        return this.properties.remove(key);
    }

    @Nonnull
    public abstract T copyDefinition();

    public static <T extends AbstractDefinition<T>> List<T> copyDefinitions(List<T> definitions) {
        return definitions.stream().map(AbstractDefinition::copyDefinition).collect(Collectors.toList());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Objects.hashCode(this.extensionName);
        n3 = 31 * n3 + Objects.hashCode(this.properties);
        n3 = 31 * n3 + Objects.hashCode(this.uid);
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDefinition abstractDefinition = (AbstractDefinition)obj;
        if (this.extensionName == null ? abstractDefinition.extensionName != null : !this.extensionName.equals(abstractDefinition.extensionName)) {
            return false;
        }
        if (this.properties == null ? abstractDefinition.properties != null : !this.properties.equals(abstractDefinition.properties)) {
            return false;
        }
        return Objects.equals(this.uid, abstractDefinition.uid);
    }
}

