/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.common;

import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.AbstractFactory;
import com.inet.taskplanner.server.api.common.AbstractInfo;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.series.Series;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public abstract class SeriesDependentFactory<COMPONENT, DEFINITION extends AbstractDefinition<DEFINITION>, INFO extends AbstractInfo, SUMMARY extends SummaryInfo>
extends AbstractFactory<COMPONENT, DEFINITION, INFO, SUMMARY> {
    public static final String PLACEHOLDER_START_CHARACTER = "[";
    public static final String PLACEHOLDER_END_CHARACTER = "]";

    public SeriesDependentFactory(String extensionName) {
        super(extensionName);
    }

    public final void validate(@Nonnull DEFINITION definition, @Nullable SeriesDefinition seriesDefinition, @Nullable GUID taskID) throws ValidationException {
        if (seriesDefinition != null) {
            try {
                Map<String, String> map = null;
                try {
                    map = this.getFirstValueFromSeries(seriesDefinition, taskID);
                }
                catch (Throwable throwable) {
                    TaskPlannerServerPlugin.LOGGER.debug((Object)throwable);
                }
                if (map != null) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        if (!StringFunctions.isEmpty((String)entry.getValue())) continue;
                        map.put(entry.getKey(), "{" + entry.getKey() + "}");
                    }
                    Iterator<Map.Entry<String, String>> iterator = this.patchDefinitionProperties(definition, map, taskID);
                    this.validate(iterator, taskID);
                    return;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw new ValidationException(new String[]{illegalStateException.getMessage()});
            }
        }
        this.validate(definition, taskID);
    }

    @Nullable
    public final Map<String, String> updateValues(@Nonnull DEFINITION definition, @Nullable SeriesDefinition seriesDefinition, GUID taskID) {
        if (seriesDefinition != null) {
            try {
                DEFINITION DEFINITION = this.patchDefinitionProperties(definition, this.getFirstValueFromSeries(seriesDefinition, taskID), taskID);
                return this.updateValues(DEFINITION, definition, seriesDefinition, taskID);
            }
            catch (Throwable throwable) {
                TaskPlannerServerPlugin.LOGGER.debug((Object)throwable);
            }
        }
        return this.updateValues(definition, null, null, taskID);
    }

    @Nullable
    public Map<String, String> updateValues(@Nonnull DEFINITION patchedDefinition, @Nullable DEFINITION unpatchedDefinition, @Nullable SeriesDefinition seriesDefinition, @Nonnull GUID taskID) {
        return null;
    }

    @Nonnull
    public COMPONENT createFrom(@Nonnull DEFINITION definition, @Nullable Map<String, String> seriesProperties, @Nullable GUID taskID) {
        this.checkDefinitionArgument(definition);
        if (seriesProperties != null) {
            DEFINITION DEFINITION = this.patchDefinitionProperties(definition, seriesProperties, taskID);
            return this.createInstanceFrom(DEFINITION, taskID);
        }
        return this.createInstanceFrom(definition, taskID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected Map<String, String> getFirstValueFromSeries(@Nonnull SeriesDefinition series, @Nullable GUID taskID) throws IllegalStateException {
        try {
            SeriesFactory seriesFactory = (SeriesFactory)ServerPluginManager.getInstance().getSingleInstanceByName(SeriesFactory.class, series.getExtensionName(), false);
            Series series2 = (Series)seriesFactory.createFrom(series, taskID);
            try {
                Iterator iterator = series2.iterator();
                if (iterator.hasNext()) {
                    Map map = (Map)iterator.next();
                    return map;
                }
                Map<String, String> map = Collections.emptyMap();
                return map;
            }
            finally {
                try {
                    series2.cleanUp(true);
                }
                catch (Exception exception) {
                    TaskPlannerServerPlugin.LOGGER.debug((Object)exception);
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException(TaskPlannerServerPlugin.MSG.getMsg("series.validation.extensionMissing", new Object[]{series.getExtensionName()}));
        }
    }

    protected DEFINITION patchDefinitionProperties(@Nonnull DEFINITION baseDefinition, @Nonnull Map<String, String> seriesProperties, @Nullable GUID taskID) {
        Object t = ((AbstractDefinition)baseDefinition).copyDefinition();
        Object INFO = this.getInformation(taskID);
        if (INFO != null) {
            Map<String, String> map = ((AbstractDefinition)t).getProperties();
            ((AbstractInfo)INFO).getFields().stream().forEach(field -> map.put(field.getKey(), field.patchSeriesPlaceholderInValue((String)map.get(field.getKey()), seriesProperties)));
        }
        return (DEFINITION)t;
    }
}

