/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler.guid.viewtask;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.history.ExecutionHistory;
import com.inet.taskplanner.server.api.history.HistoryEntry;
import com.inet.taskplanner.server.internalapi.NextExecutionTimeChecker;
import com.inet.taskplanner.webapi.handler.guid.viewtask.HistoryDescription;
import com.inet.taskplanner.webapi.handler.guid.viewtask.JobDescription;
import com.inet.taskplanner.webapi.handler.guid.viewtask.ResultActionDescription;
import com.inet.taskplanner.webapi.handler.guid.viewtask.SeriesDescription;
import com.inet.taskplanner.webapi.handler.guid.viewtask.TriggerDescription;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@JsonData
@Schema(description="Container for information about a single task.")
public class TaskDescription {
    @Schema(description="Unique identifier of the task.", example="b6nmv97sutmnvhtw8hen0yh7y")
    private String id;
    @Schema(description="Name of the task.", example="Sample Task")
    private String name;
    @Schema(description="Description of the task.", example="This is a sample task.")
    private String description;
    @Schema(description="Owner ID of the task.", example="user123")
    private GUID ownerId;
    @Schema(description="Indicates if the task is active.")
    private boolean active;
    @Schema(description="Status of the task.")
    private a status;
    @Schema(description="Timestamp of the last modification.")
    private long lastmodified;
    @Schema(description="Series description of the task.")
    private SeriesDescription series;
    @Schema(description="Next execution time of the task.")
    private long nextexecution;
    @Schema(description="List of triggers associated with the task.")
    private List<TriggerDescription> triggers;
    @Schema(description="List of jobs associated with the task.")
    private List<JobDescription> jobs;
    @Schema(description="List of result actions associated with the task.")
    private List<ResultActionDescription> resultactions;
    @Schema(description="History of the task.")
    private List<HistoryDescription> history;
    @Schema(description="Indicates if this is a system task (executed with privileged scope).")
    private boolean systemTask;

    protected TaskDescription() {
    }

    @Nonnull
    public static TaskDescription from(@Nonnull TaskDefinition definition, @Nonnull TaskExecution execution) {
        TaskDescription taskDescription = new TaskDescription();
        taskDescription.id = execution.getTaskID().toString();
        taskDescription.name = definition.getName();
        taskDescription.description = definition.getDescription();
        taskDescription.ownerId = execution.getOwnerId();
        taskDescription.active = definition.isActivated();
        taskDescription.lastmodified = execution.getLastModified();
        taskDescription.series = definition.getSeries() != null ? SeriesDescription.from(definition.getSeries()) : null;
        taskDescription.nextexecution = NextExecutionTimeChecker.getNextExecution(definition).getTimestamp();
        taskDescription.systemTask = definition.isSystemTask();
        taskDescription.triggers = definition.getTriggers().stream().map(def -> TriggerDescription.from(def)).collect(Collectors.toList());
        taskDescription.jobs = definition.getJobs().stream().map(def -> JobDescription.from(def)).collect(Collectors.toList());
        taskDescription.resultactions = definition.getResultActions().stream().map(def -> ResultActionDescription.from(def)).collect(Collectors.toList());
        taskDescription.history = TaskDescription.createDescriptionsOf(execution.getExecutionHistory());
        taskDescription.status = a.a(definition, execution);
        return taskDescription;
    }

    private static List<HistoryDescription> createDescriptionsOf(ExecutionHistory history) {
        if (history == null || history.getLastExecutions() == null) {
            return new ArrayList<HistoryDescription>();
        }
        return history.getLastExecutions().stream().map(entry -> HistoryDescription.from(entry)).collect(Collectors.toList());
    }

    public static TaskDefinition toTask(TaskDescription taskDescription) {
        TaskDefinition taskDefinition = new TaskDefinition(TaskDescription.nonNullString(taskDescription.name));
        taskDefinition.setDescription(TaskDescription.nonNullString(taskDescription.description));
        taskDefinition.setActivated(taskDescription.active);
        taskDefinition.setSeries(SeriesDescription.toSeries(taskDescription.series));
        if (taskDescription.triggers != null) {
            for (TriggerDescription object : taskDescription.triggers) {
                taskDefinition.addTrigger(TriggerDescription.toTrigger(object, taskDescription.getTaskId()));
            }
        }
        if (taskDescription.jobs != null) {
            for (JobDescription jobDescription : taskDescription.jobs) {
                taskDefinition.addJob(JobDescription.toJobDefinition(jobDescription, taskDescription.getTaskId(), taskDefinition.getSeries()));
            }
        }
        if (taskDescription.resultactions != null) {
            for (ResultActionDescription resultActionDescription : taskDescription.resultactions) {
                taskDefinition.addResultAction(ResultActionDescription.toResultActionDefinition(resultActionDescription, taskDescription.getTaskId(), taskDefinition.getSeries()));
            }
        }
        taskDefinition.setSystemTask(taskDescription.systemTask);
        return taskDefinition;
    }

    private static String nonNullString(String input) {
        return input == null ? "" : input;
    }

    public GUID getTaskId() {
        return this.id == null ? null : GUID.valueOf((String)this.id);
    }

    public GUID getNonNullTaskId() {
        if (this.id == null) {
            this.id = GUID.generateNew().toString();
        }
        return this.getTaskId();
    }

    public GUID getOwnerId() {
        return this.ownerId;
    }

    public boolean isEmpty() {
        return !(!StringFunctions.isEmpty((String)this.name) || !StringFunctions.isEmpty((String)this.id) || !StringFunctions.isEmpty((String)this.description) || this.ownerId != null || this.series != null || this.status != null || this.triggers != null && !this.triggers.isEmpty() || this.jobs != null && !this.jobs.isEmpty() || this.resultactions != null && !this.resultactions.isEmpty() || this.history != null && !this.history.isEmpty());
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a cV = new a();
        public static final /* enum */ a cW = new a();
        public static final /* enum */ a cX = new a();
        public static final /* enum */ a cY = new a();
        public static final /* enum */ a cZ = new a();
        private static final /* synthetic */ a[] da;

        public static a[] values() {
            return (a[])da.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        @Nonnull
        public static a a(@Nonnull TaskDefinition taskDefinition, @Nonnull TaskExecution taskExecution) {
            if (!taskDefinition.isActivated()) {
                return cV;
            }
            List<? extends HistoryEntry> list = taskExecution.getExecutionHistory().getLastExecutions();
            if (list.isEmpty()) {
                return cW;
            }
            HistoryEntry historyEntry = list.get(0);
            if (historyEntry.getProgress() < 100) {
                return cX;
            }
            if (historyEntry.getErrors().size() == 0) {
                return cY;
            }
            return cZ;
        }

        private static /* synthetic */ a[] ab() {
            return new a[]{cV, cW, cX, cY, cZ};
        }

        static {
            da = a.ab();
        }
    }
}

