/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.job;

import com.inet.annotations.PublicApi;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.event.ProgressEventListener;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.job.ResultContainer;
import com.inet.taskplanner.server.api.result.Result;
import java.util.ArrayList;
import javax.annotation.Nullable;

@PublicApi
public abstract class Job {
    private int progress;
    @Nullable
    private final ConditionDefinition condition;
    @Nullable
    private ProgressEventListener A;

    public Job(@Nullable ConditionDefinition condition) {
        this.condition = condition;
    }

    public final JobResultContainer execute(@Nullable ProgressEventListener listener) throws TaskExecutionException {
        this.A = listener;
        this.progress = 0;
        JobResultContainer jobResultContainer = this.run();
        if (jobResultContainer == null) {
            jobResultContainer = new ResultContainer(new ArrayList<Result>());
        }
        jobResultContainer.setAreResultsProcessable(this.areResultsProcessable());
        return jobResultContainer;
    }

    private final boolean areResultsProcessable() {
        if (this.condition == null) {
            return true;
        }
        return this.evaluateCondition(this.condition);
    }

    protected abstract JobResultContainer run() throws TaskExecutionException;

    protected abstract boolean evaluateCondition(ConditionDefinition var1);

    protected void setProgress(int progress) {
        int n2 = progress < 0 ? 0 : (progress = progress > 100 ? 100 : progress);
        if (progress != this.progress) {
            this.progress = progress;
            if (this.A != null) {
                this.A.progressUpdate(this.progress);
            }
        }
    }

    public void stopRequested() {
    }
}

