/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.internal;

import com.inet.config.ConfigurationManager;
import com.inet.id.GUID;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.EncodedReader;
import com.inet.lib.json.EncodedWriter;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.persistence.MaintenanceMode;
import com.inet.persistence.MaintenanceModeListener;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.event.TaskEvent;
import com.inet.taskplanner.server.api.event.TaskEventListener;
import com.inet.taskplanner.server.api.history.ExecutionHistory;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.internal.ExecutionHistoryImpl;
import com.inet.taskplanner.server.internal.ExecutionInformationImpl;
import com.inet.taskplanner.server.internal.InternalTask;
import com.inet.taskplanner.server.internal.TaskNodeSynchronizer;
import com.inet.taskplanner.server.internal.a;
import com.inet.taskplanner.server.internal.c;
import com.inet.taskplanner.server.internal.d;
import com.inet.taskplanner.server.internal.g;
import com.inet.taskplanner.server.internal.h;
import com.inet.taskplanner.server.internalapi.TaskShortDescription;
import com.inet.thread.EventDispatcher;
import com.inet.thread.SessionLocal;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.user.BinaryDataKey;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class f
implements MaintenanceModeListener,
UserEventListener {
    public static final BinaryDataKey bX = new BinaryDataKey("taskplannerusertasks", false);
    private static f bY;
    private CopyOnWriteArraySet<TaskEventListener> bZ = new CopyOnWriteArraySet();
    private ConcurrentMap<GUID, InternalTask> ca = new ConcurrentHashMap<GUID, InternalTask>();
    private ConcurrentMap<GUID, Map<TriggerDefinition, Trigger>> cb = new ConcurrentHashMap<GUID, Map<TriggerDefinition, Trigger>>();
    private ConcurrentMap<GUID, CopyOnWriteArrayList<InternalTask>> cc = new ConcurrentHashMap<GUID, CopyOnWriteArrayList<InternalTask>>();
    private ConcurrentMap<GUID, List<c>> cd = new ConcurrentHashMap<GUID, List<c>>();
    private static final EventDispatcher<?> ce;
    private boolean cf;
    private boolean cg;
    private boolean ch;
    private final Object ci = new Object();
    private static final boolean cj;
    private ReadWriteLock ck = new ReentrantReadWriteLock();
    private final Queue<Runnable> cl = new ConcurrentLinkedQueue<Runnable>();

    f() {
        Persistence.getInstance().registerListener((PersistenceListener)new TaskNodeSynchronizer());
        MaintenanceMode.addListener((MaintenanceModeListener)this);
    }

    public static synchronized f M() {
        if (bY == null) {
            ServerPluginManager.ServerPluginManagerState serverPluginManagerState = ServerPluginManager.getInstance().getState();
            if (serverPluginManagerState == ServerPluginManager.ServerPluginManagerState.INIT) {
                bY = new f();
            } else {
                throw new IllegalStateException(String.format("TaskPlanner can only be used when Server is initialized. Please wait for server initialization. Current State is %s", serverPluginManagerState));
            }
        }
        return bY;
    }

    public void reset() {
        try {
            this.ck.writeLock().lock();
            this.Q();
            this.ca.clear();
            this.cb.clear();
            this.bZ.clear();
        }
        finally {
            this.ck.writeLock().unlock();
        }
        bY = null;
    }

    public void reloadAll() {
        this.O();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void N() {
        boolean bl = false;
        try {
            Object object = this.ci;
            synchronized (object) {
                block10: {
                    if (!this.cf) break block10;
                    return;
                }
                bl = true;
                this.ck.writeLock().lock();
                this.cf = true;
            }
            if (bl) {
                this.O();
            }
        }
        finally {
            if (bl) {
                this.ck.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void O() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (!stackTraceElement.getMethodName().equals("hasPendingTasks")) continue;
            throw new IllegalStateException("Cannot use Taskplanner's task-related API in a SetupSteps's hasPendingTasks method, because Tasks depend on users, which depend on database in HD, which depends on another SetupStep, which is not configured yet in a new installation. If some migration is required, use the version number to check.");
        }
        try {
            Object object = this.ci;
            synchronized (object) {
                this.cf = true;
                this.ck.writeLock().lock();
            }
            TaskPlannerServerPlugin.LOGGER.info((Object)"Load Taskplanner Tasks");
            this.Q();
            this.ca.clear();
            this.cc.clear();
            this.cb.clear();
            object = UserManager.getInstance().getIteratorOverUserAccountIDs(bX);
            while (object.hasNext()) {
                GUID gUID = (GUID)object.next();
                this.e(gUID);
            }
            this.P();
        }
        catch (IllegalStateException illegalStateException) {
            TaskPlannerServerPlugin.LOGGER.error((Throwable)illegalStateException);
        }
        finally {
            this.ch = true;
            this.ck.writeLock().unlock();
        }
    }

    private void e(GUID gUID) {
        List list;
        Object object;
        try {
            object = UserManager.getInstance().getBinaryData(gUID, bX);
            try {
                if (object == null) {
                    return;
                }
                HashMap hashMap = new HashMap();
                list = (List)new Json().fromJson((Reader)new EncodedReader((InputStream)object), (Type)new JsonParameterizedType(List.class, new Type[]{InternalTask.class}), hashMap, null);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (JsonException | IOException throwable) {
            TaskPlannerServerPlugin.LOGGER.error((Throwable)new IllegalStateException(String.format("Tasks of user %s will not be initialized because persisted data could not be deserialized.", gUID), throwable));
            return;
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        object = new CopyOnWriteArrayList();
        for (InternalTask internalTask : list) {
            List<ExecutionInformationImpl> list2 = internalTask.getExecutionHistory().getLastExecutions();
            if (!this.ch && list2.size() > 0) {
                for (ExecutionInformationImpl executionInformationImpl : list2) {
                    if (executionInformationImpl.getExecutionFinishTime() != 0L) continue;
                    executionInformationImpl.setExecutionFinishTime(-1L);
                }
            }
            if (internalTask.getOwnerId() == null || !internalTask.getOwnerId().equals((Object)gUID)) {
                internalTask.setOwnerId(gUID);
            }
            GUID gUID2 = internalTask.getTaskID();
            Map<TriggerDefinition, Trigger> object22 = this.a(internalTask.getModel().getTriggers(), gUID2);
            this.ca.put(gUID2, internalTask);
            this.cb.put(gUID2, object22);
            ((CopyOnWriteArrayList)object).add(internalTask);
            this.cc.put(internalTask.getOwnerId(), (CopyOnWriteArrayList<InternalTask>)object);
            if (!internalTask.getModel().isActivated()) continue;
            this.b(gUID2, object22);
        }
    }

    private void P() {
        List<InternalTask> list;
        Object object;
        try {
            object = new h();
            list = ((h)object).T();
        }
        catch (Exception exception) {
            TaskPlannerServerPlugin.LOGGER.error((Throwable)new IllegalStateException("System tasks will not be initialized because persisted data could not be deserialized.", exception));
            return;
        }
        if (list == null || list.isEmpty()) {
            return;
        }
        object = new CopyOnWriteArrayList();
        GUID gUID = UserManager.PRIVILEGED_ACCOUNT_ID;
        for (InternalTask internalTask : list) {
            if (internalTask.getOwnerId() == null || !UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)internalTask.getOwnerId())) {
                internalTask.setOwnerId(gUID);
            }
            GUID gUID2 = internalTask.getTaskID();
            Map<TriggerDefinition, Trigger> map = this.a(internalTask.getModel().getTriggers(), gUID2);
            this.ca.put(gUID2, internalTask);
            this.cb.put(gUID2, map);
            ((CopyOnWriteArrayList)object).add(internalTask);
            this.cc.put(gUID, (CopyOnWriteArrayList<InternalTask>)object);
            if (!internalTask.getModel().isActivated()) continue;
            this.b(gUID2, map);
        }
    }

    void f(GUID gUID) {
        this.b(gUID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void b(GUID gUID, boolean bl) {
        try {
            this.ck.readLock().lock();
            try (ThreadUtils.Semaphore semaphore = this.m(gUID);){
                ThreadUtils.Semaphore semaphore2 = semaphore;
                synchronized (semaphore2) {
                    Object object;
                    GUID gUID2;
                    HashSet<GUID> hashSet = new HashSet<GUID>();
                    CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)this.cc.remove(gUID);
                    if (copyOnWriteArrayList != null) {
                        for (InternalTask internalTask : copyOnWriteArrayList) {
                            gUID2 = internalTask.getTaskID();
                            hashSet.add(gUID2);
                            object = (Map)this.cb.remove(gUID2);
                            if (object != null) {
                                for (Trigger trigger : object.values()) {
                                    trigger.deactivate();
                                }
                            }
                            this.ca.remove(gUID2);
                        }
                    }
                    this.e(gUID);
                    if (bl) {
                        copyOnWriteArrayList = (CopyOnWriteArrayList)this.cc.get(gUID);
                        if (copyOnWriteArrayList != null) {
                            for (InternalTask internalTask : copyOnWriteArrayList) {
                                gUID2 = internalTask.getTaskID();
                                object = hashSet.remove(gUID2) ? TaskEvent.TaskEventType.MODIFIED : TaskEvent.TaskEventType.ADDED;
                                this.a(new TaskEvent((TaskEvent.TaskEventType)((Object)object), gUID2));
                            }
                        }
                        for (GUID gUID3 : hashSet) {
                            this.a(new TaskEvent(TaskEvent.TaskEventType.REMOVED, gUID3));
                        }
                    }
                }
            }
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void g(GUID gUID) {
        block28: {
            this.N();
            try {
                this.ck.readLock().lock();
                List list = (List)this.cc.get(gUID);
                if (UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)gUID)) {
                    try (ThreadUtils.Semaphore semaphore = this.m(gUID);){
                        ThreadUtils.Semaphore semaphore2 = semaphore;
                        synchronized (semaphore2) {
                            h h2 = new h();
                            if (list == null || list.isEmpty()) {
                                h2.U();
                            } else {
                                h2.b(list);
                            }
                            break block28;
                        }
                    }
                }
                if (list == null) {
                    UserManager.getInstance().deleteBinaryData(gUID, bX);
                    break block28;
                }
                try (ThreadUtils.Semaphore semaphore = this.m(gUID);){
                    ThreadUtils.Semaphore semaphore3 = semaphore;
                    synchronized (semaphore3) {
                        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
                        Object object = ServerPluginManager.DEBUG ? new UTF8StreamWriter((OutputStream)fastByteArrayOutputStream) : new EncodedWriter((OutputStream)fastByteArrayOutputStream);
                        new Json().toJson((Object)list, (Appendable)object);
                        byte[] byArray = fastByteArrayOutputStream.toByteArray();
                        FastByteArrayInputStream fastByteArrayInputStream = new FastByteArrayInputStream(byArray);
                        UserManager.getInstance().storeBinaryData(gUID, bX, (InputStream)fastByteArrayInputStream, byArray.length);
                    }
                }
            }
            catch (Throwable throwable) {
                TaskPlannerServerPlugin.LOGGER.error(throwable);
                this.b(gUID, false);
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)throwable;
                    throw runtimeException;
                }
                throw new IllegalStateException(StringFunctions.getUserFriendlyErrorMessage((Throwable)throwable), throwable);
            }
            finally {
                this.ck.readLock().unlock();
            }
        }
        TaskNodeSynchronizer.d(gUID);
    }

    private void Q() {
        for (Map map : this.cb.values()) {
            for (Trigger trigger : map.values()) {
                trigger.deactivate();
            }
        }
    }

    public void registerEventListener(@Nonnull TaskEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("task event listener must not be null");
        }
        this.bZ.add(listener);
    }

    public void unregisterEventListener(@Nonnull TaskEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("task event listener must not be null");
        }
        this.bZ.remove(listener);
    }

    private void a(TaskEvent taskEvent) {
        Runnable runnable = () -> this.bZ.forEach(taskEventListener -> {
            try {
                taskEventListener.notify(taskEvent);
            }
            catch (Exception exception) {
                TaskPlannerServerPlugin.LOGGER.error((Throwable)exception);
            }
            finally {
                SessionLocal.allRemoveThreadFromSession();
            }
        });
        ce.dispatchEvent(runnable);
    }

    public InternalTask h(@Nonnull GUID gUID) {
        if (gUID == null) {
            throw new IllegalArgumentException("taskID cannot be null!");
        }
        this.N();
        try {
            this.ck.readLock().lock();
            InternalTask internalTask = (InternalTask)this.ca.get(gUID);
            return internalTask;
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    public TaskExecution getTaskExecution(final GUID taskID) {
        final InternalTask internalTask = this.h(taskID);
        if (internalTask == null) {
            return null;
        }
        final ExecutionHistoryImpl executionHistoryImpl = new ExecutionHistoryImpl();
        for (ExecutionInformationImpl object : internalTask.getExecutionHistory().getLastExecutions()) {
            executionHistoryImpl.addExecution(object);
        }
        List list = (List)this.cd.get(internalTask.getTaskID());
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                c c2 = (c)iterator.next();
                executionHistoryImpl.updateExecution(c2.H());
            }
        }
        return new TaskExecution(){

            @Override
            public boolean isRunning() {
                return internalTask.isRunning();
            }

            @Override
            public GUID getTaskID() {
                return taskID;
            }

            @Override
            public Map<String, String> getStateProperties() {
                return internalTask.getStateProperties();
            }

            @Override
            public GUID getOwnerId() {
                return internalTask.getOwnerId();
            }

            @Override
            public long getLastModified() {
                return internalTask.getLastModified();
            }

            @Override
            public ExecutionHistory getExecutionHistory() {
                return executionHistoryImpl;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GUID> getUserTaskIDs(GUID userAccountId) {
        this.N();
        try {
            ArrayList<GUID> arrayList;
            this.ck.readLock().lock();
            if (userAccountId != null && (arrayList = (ArrayList<GUID>)this.cc.get(userAccountId)) != null) {
                List<GUID> list = arrayList.stream().map(InternalTask::getTaskID).collect(Collectors.toList());
                return list;
            }
            arrayList = new ArrayList<GUID>(0);
            return arrayList;
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    private static boolean c(InternalTask internalTask) {
        if (!cj) {
            return true;
        }
        if (!UserManager.MASTER_ACCOUNT_ID.equals((Object)internalTask.getOwnerId())) {
            return true;
        }
        return UserManager.MASTER_ACCOUNT_ID.equals((Object)UserManager.getInstance().getCurrentUserAccountID());
    }

    private static boolean d(InternalTask internalTask) {
        if (internalTask == null || internalTask.getModel() == null) {
            return true;
        }
        if (!internalTask.getModel().isSystemTask()) {
            return true;
        }
        return g.S();
    }

    public List<GUID> getAllTaskIDs() {
        this.N();
        try {
            this.ck.readLock().lock();
            List<GUID> list = this.ca.values().stream().filter(f::c).filter(f::d).map(InternalTask::getTaskID).collect(Collectors.toList());
            return list;
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    public CompletableFuture<Void> executeTask(TaskDefinition definition, GUID ownerId) {
        if (definition == null) {
            throw new IllegalArgumentException("A null definition is not allowed to execute");
        }
        c c2 = new c();
        return new d().a(definition, null, c2, ownerId, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GUID addTask(TaskDefinition task, GUID ownerId) {
        if (task.isSystemTask() && !g.S()) {
            throw new IllegalArgumentException("Insufficient permissions to set system task");
        }
        if (task == null) {
            throw new IllegalArgumentException("Given task cannot be null!");
        }
        if (ownerId == null) {
            throw new IllegalArgumentException("Given ownerId cannot be null!");
        }
        this.N();
        try {
            GUID gUID;
            this.ck.readLock().lock();
            TaskDefinition taskDefinition = task.copyTaskModel();
            if (taskDefinition.isSystemTask()) {
                TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Creating system task '%s' as privileged owner", taskDefinition.getName()));
                ownerId = UserManager.PRIVILEGED_ACCOUNT_ID;
            }
            GUID gUID2 = gUID = this.a(ownerId, taskDefinition, true);
            return gUID2;
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTask(GUID taskID, TaskDefinition taskModel) {
        if (taskModel.isSystemTask() && !g.S()) {
            throw new IllegalArgumentException("Insufficient permissions to modify system task setting");
        }
        this.N();
        try {
            this.ck.readLock().lock();
            GUID gUID = this.b(taskID, taskModel.copyTaskModel(), true);
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GUID a(GUID gUID, TaskDefinition taskDefinition, boolean bl) {
        GUID gUID2 = GUID.generateNew();
        if (this.ca.containsKey(gUID2)) {
            throw new IllegalStateException("task already exists, taskID =  " + String.valueOf(gUID2));
        }
        Map<TriggerDefinition, Trigger> map = this.a(taskDefinition.getTriggers(), gUID2);
        InternalTask internalTask = new InternalTask(gUID2, gUID, taskDefinition, System.currentTimeMillis());
        try (ThreadUtils.Semaphore semaphore = this.g(internalTask);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                CopyOnWriteArrayList<InternalTask> copyOnWriteArrayList = (CopyOnWriteArrayList<InternalTask>)this.cc.get(gUID);
                if (copyOnWriteArrayList == null) {
                    copyOnWriteArrayList = new CopyOnWriteArrayList<InternalTask>();
                    this.cc.put(gUID, copyOnWriteArrayList);
                }
                copyOnWriteArrayList.add(internalTask);
                this.ca.put(gUID2, internalTask);
                this.cb.put(gUID2, map);
                if (taskDefinition.isActivated()) {
                    taskDefinition.setActivated(false);
                    this.c(gUID2, false);
                }
                this.g(gUID);
                if (bl) {
                    this.a(new TaskEvent(TaskEvent.TaskEventType.ADDED, gUID2));
                }
                TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Task '%s:%s' was added by user '%s'", this.i(gUID), taskDefinition.getName(), this.J()));
                GUID gUID3 = gUID2;
                return gUID3;
            }
        }
    }

    private String i(GUID gUID) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
        if (userAccount == null) {
            return null;
        }
        return userAccount.getDisplayName();
    }

    private String J() {
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            return null;
        }
        return userAccount.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GUID b(GUID gUID, final TaskDefinition taskDefinition, boolean bl) {
        InternalTask internalTask = (InternalTask)this.ca.get(gUID);
        if (internalTask == null) {
            throw new IllegalArgumentException("task does not exist, taskID = " + String.valueOf(gUID));
        }
        try (ThreadUtils.Semaphore semaphore = this.g(internalTask);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                GUID gUID2;
                final TaskDefinition taskDefinition2 = internalTask.getModel();
                Map map = (Map)this.cb.get(gUID);
                ArrayList<TriggerDefinition> arrayList = new ArrayList<TriggerDefinition>(){
                    {
                        this.addAll(taskDefinition2.getTriggers());
                        this.removeAll(taskDefinition.getTriggers());
                    }
                };
                ArrayList<TriggerDefinition> arrayList2 = new ArrayList<TriggerDefinition>(){
                    {
                        this.addAll(taskDefinition.getTriggers());
                        this.removeAll(taskDefinition2.getTriggers());
                    }
                };
                for (TriggerDefinition triggerDefinition : arrayList) {
                    Trigger trigger = (Trigger)map.remove(triggerDefinition);
                    if (trigger == null || !taskDefinition2.isActivated()) continue;
                    trigger.clearState();
                    trigger.deactivate();
                }
                Map<TriggerDefinition, Trigger> map2 = this.a((List<TriggerDefinition>)arrayList2, gUID);
                if (taskDefinition2.isActivated() && !taskDefinition.isActivated()) {
                    this.d(gUID, false);
                    map.putAll(map2);
                } else if (taskDefinition2.isActivated() && taskDefinition.isActivated()) {
                    map.putAll(map2);
                    this.b(gUID, map2);
                } else if (!taskDefinition2.isActivated() && !taskDefinition.isActivated()) {
                    map.putAll(map2);
                } else if (!taskDefinition2.isActivated() && taskDefinition.isActivated()) {
                    map.putAll(map2);
                    this.c(gUID, false);
                }
                boolean bl2 = taskDefinition2.isSystemTask();
                boolean bl3 = taskDefinition.isSystemTask();
                GUID gUID3 = internalTask.getOwnerId();
                if (!bl2 && bl3) {
                    TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Task '%s' switched to System Task by user '%s'", taskDefinition.getName(), this.J()));
                    this.a(internalTask, UserManager.PRIVILEGED_ACCOUNT_ID);
                } else if (bl2 && !bl3) {
                    gUID2 = UserManager.getInstance().getCurrentUserAccountID();
                    TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Task '%s' switched from System Task to normal by user '%s'", taskDefinition.getName(), this.J()));
                    if (gUID2 != null) {
                        this.a(internalTask, gUID2);
                    }
                }
                internalTask.setModel(taskDefinition);
                internalTask.setLastModified(System.currentTimeMillis());
                if (!internalTask.getOwnerId().equals((Object)gUID3)) {
                    this.g(gUID3);
                }
                this.g(internalTask.getOwnerId());
                if (bl) {
                    this.a(new TaskEvent(TaskEvent.TaskEventType.MODIFIED, gUID));
                }
                TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Task '%s:%s' was modified by user '%s'", this.i(internalTask.getOwnerId()), internalTask.getModel().getName(), this.J()));
                gUID2 = internalTask.getOwnerId();
                return gUID2;
            }
        }
    }

    private void a(InternalTask internalTask, GUID gUID) {
        if (gUID == null) {
            return;
        }
        CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)this.cc.get(internalTask.getOwnerId());
        if (copyOnWriteArrayList != null) {
            copyOnWriteArrayList.remove(internalTask);
            if (copyOnWriteArrayList.isEmpty()) {
                this.cc.remove(internalTask.getOwnerId());
            }
        }
        internalTask.setOwnerId(gUID);
        CopyOnWriteArrayList<InternalTask> copyOnWriteArrayList2 = (CopyOnWriteArrayList<InternalTask>)this.cc.get(gUID);
        if (copyOnWriteArrayList2 == null) {
            copyOnWriteArrayList2 = new CopyOnWriteArrayList<InternalTask>();
            this.cc.put(gUID, copyOnWriteArrayList2);
        }
        if (!copyOnWriteArrayList2.contains(internalTask)) {
            copyOnWriteArrayList2.add(internalTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(GUID taskID) {
        this.N();
        try {
            this.ck.readLock().lock();
            InternalTask internalTask = (InternalTask)this.ca.get(taskID);
            if (internalTask == null) {
                return;
            }
            try (ThreadUtils.Semaphore semaphore = this.g(internalTask);){
                ThreadUtils.Semaphore semaphore2 = semaphore;
                synchronized (semaphore2) {
                    this.d(taskID, false);
                    this.ca.remove(taskID);
                    this.cb.remove(taskID);
                    List list = (List)this.cc.get(internalTask.getOwnerId());
                    list.remove(internalTask);
                    if (list.isEmpty()) {
                        this.cc.remove(internalTask.getOwnerId());
                    }
                    this.g(internalTask.getOwnerId());
                    this.a(new TaskEvent(TaskEvent.TaskEventType.REMOVED, taskID));
                    TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Task '%s:%s' was removed  by user '%s'", this.i(internalTask.getOwnerId()), internalTask.getModel().getName(), this.J()));
                }
            }
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    public void activateTask(GUID taskID) {
        this.N();
        try {
            this.ck.readLock().lock();
            this.c(taskID, true);
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(GUID gUID, boolean bl) {
        InternalTask internalTask = (InternalTask)this.ca.get(gUID);
        if (internalTask == null) {
            throw new IllegalArgumentException(TaskPlannerServerPlugin.MSG.getMsg("taskplanner.task.notfound", new Object[]{gUID}));
        }
        try (ThreadUtils.Semaphore semaphore = this.g(internalTask);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                TaskDefinition taskDefinition;
                block13: {
                    taskDefinition = internalTask.getModel();
                    if (!taskDefinition.isActivated()) break block13;
                    return;
                }
                taskDefinition.setActivated(true);
                this.b(gUID, (Map)this.cb.get(gUID));
                if (bl) {
                    this.g(internalTask.getOwnerId());
                    this.a(new TaskEvent(TaskEvent.TaskEventType.ACTIVATED, gUID));
                }
            }
        }
    }

    public void finish() {
        Runnable runnable;
        while ((runnable = this.cl.poll()) != null) {
            runnable.run();
        }
    }

    private void b(GUID gUID, Map<TriggerDefinition, Trigger> map2) {
        this.N();
        if (ConfigurationManager.isRecoveryMode()) {
            return;
        }
        if (VetoManager.getInstance().isCurrentlyVetoed()) {
            return;
        }
        if (!this.cg) {
            return;
        }
        if (!this.k(((InternalTask)this.ca.get(gUID)).getOwnerId())) {
            return;
        }
        for (Map.Entry<TriggerDefinition, Trigger> entry : map2.entrySet()) {
            entry.getValue().activate(gUID, map -> {
                MaintenanceMode maintenanceMode = MaintenanceMode.getState();
                Queue<Runnable> queue = this.cl;
                synchronized (queue) {
                    if (maintenanceMode != MaintenanceMode.NONE || this.cl.size() > 0) {
                        TaskPlannerServerPlugin.LOGGER.debug((Object)("Would have normally triggered " + String.valueOf(gUID) + " but queuing because MaintenanceMode: " + maintenanceMode.name() + ", queue size: " + this.cl.size()));
                        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
                        this.cl.add(this.a(gUID, entry, map, completableFuture));
                        return completableFuture;
                    }
                }
                return this.a(gUID, entry, (Map<String, String>)map);
            });
        }
    }

    private Runnable a(GUID gUID, Map.Entry<TriggerDefinition, Trigger> entry, Map<String, String> map, CompletableFuture<Void> completableFuture) {
        return () -> {
            TaskPlannerServerPlugin.LOGGER.debug((Object)("Running queued execution of " + String.valueOf(gUID)));
            CompletableFuture<Void> completableFuture2 = this.a(gUID, entry, map);
            if (completableFuture2 != null) {
                completableFuture2.whenComplete((void_, throwable) -> {
                    if (throwable != null) {
                        completableFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        completableFuture.complete(null);
                    }
                });
            } else {
                completableFuture.complete(null);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private CompletableFuture<Void> a(GUID gUID, Map.Entry<TriggerDefinition, Trigger> entry, Map<String, String> map) {
        InternalTask internalTask;
        try {
            this.ck.readLock().lock();
            internalTask = (InternalTask)this.ca.get(gUID);
        }
        finally {
            this.ck.readLock().unlock();
        }
        if (internalTask == null) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)String.format("Task %s was triggered, but is already removed", gUID));
            return null;
        }
        String string = entry.getKey().getExtensionName();
        TriggerFactory triggerFactory = (TriggerFactory)ServerPluginManager.getInstance().getSingleInstanceByName(TriggerFactory.class, string, false);
        try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)internalTask.getOwnerId());){
            boolean bl = triggerFactory.isAvailable();
            if (bl) return this.a(internalTask, false, map);
            try (ThreadUtils.Semaphore semaphore = this.g(internalTask);){
                ThreadUtils.Semaphore semaphore2 = semaphore;
                synchronized (semaphore2) {
                    c c2 = this.f(internalTask);
                    c2.I().add(TaskPlannerServerPlugin.MSG.getMsg("error.execution.triggerNotAvailable", new Object[]{internalTask.getModel().getName(), this.i(internalTask.getOwnerId()), string}));
                    this.a(internalTask, c2);
                }
            }
            semaphore = null;
            return semaphore;
        }
        catch (IOException iOException) {
            TaskPlannerServerPlugin.LOGGER.error((Throwable)iOException);
        }
        return this.a(internalTask, false, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> a(@Nonnull InternalTask internalTask, boolean bl, @Nullable Map<String, String> map) {
        GUID gUID = internalTask.getTaskID();
        TaskDefinition taskDefinition = internalTask.getModel();
        String string = taskDefinition.getName();
        try (ThreadUtils.Semaphore semaphore = this.g(internalTask);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                block19: {
                    if (!a.c(gUID)) {
                        TaskPlannerServerPlugin.LOGGER.warn((Object)String.format("[LoopCheck] Attempted to start %s but was already executed in this sequence", string));
                        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
                        completableFuture.complete(null);
                        CompletableFuture<Void> completableFuture2 = completableFuture;
                        return completableFuture2;
                    }
                    if (this.k(internalTask.getOwnerId())) break block19;
                    TaskPlannerServerPlugin.LOGGER.warn((Object)String.format("Attempted to start %s but the account of the owner is not active", string));
                    IllegalStateException illegalStateException = new IllegalStateException(String.format("The owner of the task %s has been deactivated", string));
                    if (bl) {
                        throw illegalStateException;
                    }
                    CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
                    completableFuture.completeExceptionally(illegalStateException);
                    CompletableFuture<Void> completableFuture3 = completableFuture;
                    return completableFuture3;
                }
                if (!this.j(internalTask.getOwnerId())) {
                    TaskPlannerServerPlugin.LOGGER.error((Object)String.format("Attempted to start %s but owner has no taskplanner permission", string));
                    c c2 = this.f(internalTask);
                    c2.I().add(TaskPlannerServerPlugin.MSG.getMsg("error.execution.noPermission", new Object[]{internalTask.getModel().getName(), this.i(internalTask.getOwnerId())}));
                    this.a(internalTask, c2);
                    CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
                    completableFuture.completeExceptionally((Throwable)new AccessDeniedException("Owner must have takplanner permission. OwnerID=" + String.valueOf(internalTask.getOwnerId())));
                    CompletableFuture<Void> completableFuture4 = completableFuture;
                    return completableFuture4;
                }
                if (this.e(internalTask)) {
                    TaskPlannerServerPlugin.LOGGER.error((Object)String.format("Attempted to start %s but is already running too many times", string));
                    c c3 = this.f(internalTask);
                    c3.I().add(TaskPlannerServerPlugin.MSG.getMsg("error.execution.parallel_limit_reached", new Object[]{internalTask.getModel().getName(), 100}));
                    this.a(internalTask, c3);
                    CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
                    completableFuture.completeExceptionally(new IllegalStateException("Limit of parallel execution reached"));
                    CompletableFuture<Void> completableFuture5 = completableFuture;
                    return completableFuture5;
                }
                TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Start Execution of task %s", string));
                c c4 = this.f(internalTask);
                Runnable runnable = () -> {
                    try (ThreadUtils.Semaphore semaphore = this.g(internalTask);){
                        ThreadUtils.Semaphore semaphore2 = semaphore;
                        synchronized (semaphore2) {
                            TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Execution of task %s finished", string));
                            InternalTask internalTask2 = (InternalTask)this.ca.get(internalTask.getTaskID());
                            if (internalTask2 != null) {
                                this.a(internalTask2, c4);
                            }
                        }
                    }
                };
                if (taskDefinition.isSystemTask()) {
                    TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Executing system task %s with privileged owner", string));
                }
                CompletableFuture<Void> completableFuture = new d().a(taskDefinition, map, c4, internalTask.getOwnerId(), gUID, n2 -> this.a(new TaskEvent(n2, gUID, c4.getExecutionID())), runnable);
                c4.a(completableFuture);
                CompletableFuture<Void> completableFuture6 = completableFuture;
                return completableFuture6;
            }
        }
    }

    private boolean e(InternalTask internalTask) {
        long l2 = internalTask.getExecutionHistory().getLastExecutions().stream().filter(executionInformationImpl -> executionInformationImpl.getExecutionFinishTime() == 0L).count();
        return l2 >= 100L;
    }

    private void a(InternalTask internalTask, c c2) {
        internalTask.finish(c2);
        this.g(internalTask.getOwnerId());
        List list = (List)this.cd.get(internalTask.getTaskID());
        if (list != null) {
            list.remove(c2);
            if (list.isEmpty()) {
                this.cd.remove(internalTask.getTaskID());
            }
        }
        this.a(new TaskEvent(TaskEvent.TaskEventType.EXECUTION_ENDED, internalTask.getTaskID(), c2.getExecutionID()));
    }

    private c f(InternalTask internalTask) {
        c c2 = internalTask.start();
        this.g(internalTask.getOwnerId());
        CopyOnWriteArrayList<c> copyOnWriteArrayList = (CopyOnWriteArrayList<c>)this.cd.get(internalTask.getTaskID());
        if (copyOnWriteArrayList == null) {
            copyOnWriteArrayList = new CopyOnWriteArrayList<c>();
            this.cd.put(internalTask.getTaskID(), copyOnWriteArrayList);
        }
        copyOnWriteArrayList.add(c2);
        this.a(new TaskEvent(TaskEvent.TaskEventType.EXECUTION_STARTED, internalTask.getTaskID(), c2.getExecutionID()));
        return c2;
    }

    private boolean j(GUID gUID) {
        try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)gUID);){
            boolean bl = SystemPermissionChecker.checkAccess((Permission)TaskPlanner.PERMISSION_TASKPLANNER);
            return bl;
        }
    }

    private boolean k(GUID gUID) {
        UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
        if (userAccount == null) {
            return false;
        }
        return userAccount.isActive();
    }

    public void deactivateTask(GUID taskID) {
        this.N();
        try {
            this.ck.readLock().lock();
            this.d(taskID, true);
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(GUID gUID, boolean bl) {
        InternalTask internalTask = (InternalTask)this.ca.get(gUID);
        if (internalTask == null) {
            throw new IllegalArgumentException("task does not exist, taskID =  " + String.valueOf(gUID));
        }
        try (ThreadUtils.Semaphore semaphore = this.g(internalTask);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                TaskDefinition taskDefinition;
                block14: {
                    taskDefinition = internalTask.getModel();
                    if (taskDefinition.isActivated()) break block14;
                    return;
                }
                for (Trigger trigger : ((Map)this.cb.get(gUID)).values()) {
                    trigger.clearState();
                    trigger.deactivate();
                }
                taskDefinition.setActivated(false);
                if (bl) {
                    this.g(internalTask.getOwnerId());
                    this.a(new TaskEvent(TaskEvent.TaskEventType.DEACTIVATED, gUID));
                }
            }
        }
    }

    private Map<TriggerDefinition, Trigger> a(List<TriggerDefinition> list, GUID gUID) {
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        HashMap<TriggerDefinition, Trigger> hashMap = new HashMap<TriggerDefinition, Trigger>();
        for (TriggerDefinition triggerDefinition : list) {
            try {
                TriggerFactory triggerFactory = (TriggerFactory)serverPluginManager.getSingleInstanceByName(TriggerFactory.class, triggerDefinition.getExtensionName(), false);
                Trigger trigger = (Trigger)triggerFactory.createFrom(triggerDefinition, gUID);
                if (trigger == null) {
                    TaskPlannerServerPlugin.LOGGER.error((Object)String.format("Trigger returned from TriggerFactory %s was null!", triggerDefinition.getExtensionName()));
                    continue;
                }
                hashMap.put(triggerDefinition, trigger);
            }
            catch (IllegalStateException illegalStateException) {
                TaskPlannerServerPlugin.LOGGER.error((Object)String.format("No TriggerFactory %s can be found!", triggerDefinition.getExtensionName()));
                TaskPlannerServerPlugin.LOGGER.error((Throwable)illegalStateException);
            }
            catch (Exception exception) {
                TaskPlannerServerPlugin.LOGGER.error((Object)String.format("TriggerFactory %s threw exception: Trigger cannot be activated", triggerDefinition.getExtensionName()));
                TaskPlannerServerPlugin.LOGGER.error((Throwable)exception);
            }
        }
        return hashMap;
    }

    public void cancelTask(GUID taskID, boolean waitForCancelation) {
        this.cancelTaskExecution(taskID, null, waitForCancelation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTaskExecution(GUID taskID, GUID executionID, boolean waitForCancelation) {
        ArrayList<c> arrayList;
        block11: {
            this.N();
            try {
                this.ck.readLock().lock();
                InternalTask internalTask = (InternalTask)this.ca.get(taskID);
                if (internalTask == null) {
                    TaskPlannerServerPlugin.LOGGER.debug((Object)String.format("Cannot cancel task %s because does not exist", taskID.toString()));
                    return;
                }
                arrayList = (ArrayList<c>)this.cd.get(taskID);
                if (arrayList != null) {
                    arrayList = new ArrayList<c>(arrayList);
                    break block11;
                }
                return;
            }
            finally {
                this.ck.readLock().unlock();
            }
        }
        if (executionID != null) {
            arrayList.removeIf(c2 -> !c2.getExecutionID().equals((Object)executionID));
        }
        boolean bl = false;
        for (c c3 : arrayList) {
            CompletableFuture<Void> completableFuture = c3.G();
            if (completableFuture == null) continue;
            bl = true;
            completableFuture.cancel(true);
            if (!waitForCancelation) continue;
            try {
                completableFuture.get();
            }
            catch (Exception exception) {}
        }
        if (!bl) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)String.format("Cannot cancel task %s because it is not running", taskID.toString()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskShortDescription> l(GUID gUID) {
        this.N();
        try {
            this.ck.readLock().lock();
            List list = (List)this.cc.get(gUID);
            if (list != null) {
                List<TaskShortDescription> list2 = list.stream().map(internalTask -> TaskShortDescription.from(internalTask)).collect(Collectors.toList());
                return list2;
            }
            ArrayList<TaskShortDescription> arrayList = new ArrayList<TaskShortDescription>(0);
            return arrayList;
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    public List<TaskShortDescription> listAllTasks() {
        this.N();
        try {
            this.ck.readLock().lock();
            List<TaskShortDescription> list = this.ca.values().stream().filter(f::d).map(internalTask -> TaskShortDescription.from(internalTask)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    public void userAccountCreated(UserAccount userAccount) {
    }

    public void userAccountBeforeUpdate(UserAccount userAccountBefore) {
    }

    public void userAccountUpdated(UserAccount userAccountBefore, UserAccount userAccountAfter) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userAccountDeactivated(UserAccount userAccount) {
        this.N();
        try {
            this.ck.readLock().lock();
            GUID gUID = userAccount.getID();
            List list = (List)this.cc.get(gUID);
            if (list == null) {
                return;
            }
            try (ThreadUtils.Semaphore semaphore = this.m(gUID);){
                ThreadUtils.Semaphore semaphore2 = semaphore;
                synchronized (semaphore2) {
                    for (InternalTask internalTask : list) {
                        if (!internalTask.getModel().isActivated()) continue;
                        for (Trigger trigger : ((Map)this.cb.get(internalTask.getTaskID())).values()) {
                            trigger.deactivate();
                        }
                    }
                }
            }
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userAccountReactivated(UserAccount userAccount) {
        this.N();
        try {
            this.ck.readLock().lock();
            GUID gUID = userAccount.getID();
            List list = (List)this.cc.get(gUID);
            if (list == null) {
                return;
            }
            try (ThreadUtils.Semaphore semaphore = this.m(gUID);){
                ThreadUtils.Semaphore semaphore2 = semaphore;
                synchronized (semaphore2) {
                    for (InternalTask internalTask : list) {
                        if (!internalTask.getModel().isActivated()) continue;
                        this.b(internalTask.getTaskID(), (Map)this.cb.get(internalTask.getTaskID()));
                    }
                }
            }
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userAccountBeforeDeleted(UserAccount userAccount) {
        this.N();
        GUID gUID = userAccount.getID();
        try {
            this.ck.readLock().lock();
            List list = (List)this.cc.get(gUID);
            if (list == null) {
                return;
            }
            try (ThreadUtils.Semaphore semaphore = this.m(gUID);){
                ThreadUtils.Semaphore semaphore2 = semaphore;
                synchronized (semaphore2) {
                    for (InternalTask internalTask : list) {
                        GUID gUID2 = internalTask.getTaskID();
                        this.d(gUID2, false);
                        this.ca.remove(gUID2);
                        this.cb.remove(gUID2);
                        this.a(new TaskEvent(TaskEvent.TaskEventType.REMOVED, gUID2));
                    }
                }
            }
            this.cc.remove(gUID);
            TaskPlannerServerPlugin.LOGGER.info((Object)String.format("Tasks of user '%s' were removed because the account was deleted by user '%s'", userAccount.getDisplayName(), this.J()));
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    private ThreadUtils.Semaphore g(InternalTask internalTask) {
        return this.m(internalTask.getOwnerId());
    }

    private ThreadUtils.Semaphore m(GUID gUID) {
        return ThreadUtils.getSemaphore((Object)("taskplanner-" + gUID.toString()));
    }

    public void userAccountDeleted(UserAccount userAccount) {
    }

    public void R() {
        this.N();
        try {
            this.ck.readLock().lock();
            this.cg = true;
            for (Map.Entry entry : this.cb.entrySet()) {
                if (!((InternalTask)this.ca.get(entry.getKey())).getModel().isActivated()) continue;
                this.b((GUID)entry.getKey(), (Map)entry.getValue());
            }
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean n(GUID gUID) {
        try {
            this.ck.readLock().lock();
            for (List list : this.cd.values()) {
                for (c c2 : list) {
                    if (!c2.getExecutionID().equals((Object)gUID)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.ck.readLock().unlock();
        }
    }

    static {
        ce = new EventDispatcher();
        cj = ServerPluginManager.getInstance().isPluginLoaded("hosting");
    }
}

