/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.internal;

import com.inet.annotations.JsonData;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.internal.ExecutionHistoryImpl;
import com.inet.taskplanner.server.internal.c;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonData
public class InternalTask {
    private GUID taskID;
    private GUID ownerId;
    private TaskDefinition model;
    private ExecutionHistoryImpl executionHistory;
    private long lastModified;
    private Map<String, String> stateProperties;

    public InternalTask(GUID taskID, GUID ownerId, TaskDefinition model, long lastModified) {
        this(taskID, ownerId, model, lastModified, new ExecutionHistoryImpl());
    }

    public InternalTask(GUID taskID, GUID ownerId, TaskDefinition model, long lastModified, ExecutionHistoryImpl executionHistory) {
        if (taskID == null) {
            throw new IllegalArgumentException("taskID must not be null");
        }
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        if (executionHistory == null) {
            throw new IllegalArgumentException("executionHistory must not be null");
        }
        this.taskID = taskID;
        this.ownerId = ownerId;
        this.model = model;
        this.executionHistory = executionHistory;
        this.lastModified = lastModified;
    }

    private InternalTask() {
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setModel(@Nonnull TaskDefinition model) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        this.model = model;
    }

    public c start() {
        c c2 = new c();
        this.executionHistory.addExecution(c2.H());
        return c2;
    }

    public void finish(c execInfo) {
        execInfo.setExecutionFinishTime(System.currentTimeMillis());
        this.executionHistory.updateExecution(execInfo.H());
    }

    public boolean isRunning() {
        return this.executionHistory.isRunning();
    }

    public Map<String, String> getStateProperties() {
        if (this.stateProperties == null) {
            this.stateProperties = new HashMap<String, String>();
        }
        return this.stateProperties;
    }

    public GUID getTaskID() {
        return this.taskID;
    }

    public GUID getOwnerId() {
        return this.ownerId;
    }

    public TaskDefinition getModel() {
        return this.model;
    }

    public ExecutionHistoryImpl getExecutionHistory() {
        return this.executionHistory;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    void setOwnerId(GUID ownerId) {
        this.ownerId = ownerId;
    }
}

