/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.action.savefile;

import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.action.ResultActionHelper;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.error.TaskPlannerCodes;
import com.inet.taskplanner.server.api.fileservice.FileServiceForTaskPlanner;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.result.FileResult;
import com.inet.taskplanner.server.api.result.Result;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;

public class a
extends ResultAction {
    private String t;
    private String q;
    private boolean am;
    private long an;

    public a(@Nonnull String string, String string2, String string3) {
        this.t = string;
        if (string2 == null || string2.isEmpty()) {
            string2 = "[filename] [date] [time]";
        }
        this.q = ResultActionHelper.normalize(string2);
        try {
            int n2 = Integer.valueOf(string3);
            if (n2 >= 0) {
                this.an = System.currentTimeMillis() - (long)(((double)n2 + 0.5) * 8.64E7);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void handle(List<JobResultContainer> containers) throws TaskExecutionException {
        this.setProgress(0);
        for (int i2 = 0; i2 < containers.size(); ++i2) {
            int n2 = 0;
            JobResultContainer jobResultContainer = containers.get(i2);
            List<Result> list = jobResultContainer.getResults(ResultFlavor.FILE);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                if (this.am) {
                    return;
                }
                Result result = list.get(i3);
                String string = ((FileResult)result).getFileName();
                FileServiceForTaskPlanner fileServiceForTaskPlanner = FileServiceForTaskPlanner.getServiceFor(this.t);
                if (fileServiceForTaskPlanner == null || !SystemPermissionChecker.checkAccess((Permission)fileServiceForTaskPlanner.getRequiredPermission())) {
                    throw new TaskExecutionException(new RuntimeException(TaskPlannerServerPlugin.MSG.getMsg("result.savefile.error.cannotwritetodir", new Object[0])), TaskPlannerCodes.FileCannotBeWritten);
                }
                try (InputStream inputStream = ((FileResult)result).getFileContent();){
                    fileServiceForTaskPlanner.saveFile(string, this.q, this.t, inputStream, jobResultContainer.getMetaProperties());
                }
                catch (Exception exception) {
                    throw new TaskExecutionException(exception, TaskPlannerCodes.FileCannotBeWritten);
                }
                try {
                    fileServiceForTaskPlanner.deleteOldFiles(string, this.q, this.t, this.an);
                }
                catch (Exception exception) {
                    throw new TaskExecutionException(exception, TaskPlannerCodes.OldFilesCannotBeDeleted);
                }
                n2 = 100 * (i2 + 1) / containers.size();
                this.setProgress(n2 * (i3 + 1) / list.size());
            }
            this.setProgress(n2);
        }
        this.setProgress(100);
    }

    @Override
    public void stopRequested() {
        this.am = true;
    }
}

