'use strict';clearreportsApp.service("taskplannerfactory",function($rootScope,$timeout,taskPlannerModel,websocketdataservice,dataservice,errorservice,dialogservice){var $this=this;this.EVENT={TASKS:"tasks"};this.renderer={};this.getScrollParent=function(alertSelector){if(alertSelector!=undefined&&alertSelector!="#taskdetailserror")return undefined;if($rootScope.layout=="xs")return"body";else return".taskpanel"};this.registerHandler=function(errorHandler,reconnectHandler,reconnectingHandler,reconnectedHandler){websocketdataservice.registerErrorHandler(errorHandler);
websocketdataservice.registerReconnectHandler(reconnectHandler);websocketdataservice.registerReconnectingHandler(reconnectingHandler);websocketdataservice.registerReconnectedHandler(reconnectedHandler)};this.connect=function(){websocketdataservice.sendEvent("taskplanner.connect")};this.disconnect=function(){websocketdataservice.sendEvent("taskplanner.disconnect")};var getSettingsAsMap=function(settingsList){var availableSettings={};for(var i=0;i<settingsList.length;i++){var setting=settingsList[i];
if(setting.id!=undefined)availableSettings[setting.id]=setting;else{setting.index=i;availableSettings[setting.key]=setting}}return availableSettings};websocketdataservice.onEvent("error",function(data){errorservice.showerrorcontent(data)});websocketdataservice.onEvent("taskplanner.initialdata",function(data){taskPlannerModel.admin=data.admin;taskPlannerModel.hasConfigurationPermission=data.hasConfigurationPermission;taskPlannerModel.tasks=data.tasks;taskPlannerModel.availableTrigger=getSettingsAsMap(data.availableTrigger);
taskPlannerModel.availableJobs=getSettingsAsMap(data.availableJobs);taskPlannerModel.availableResultHandler=getSettingsAsMap(data.availableResultHandler);taskPlannerModel.availableSeries=getSettingsAsMap(data.availableSeries);taskPlannerModel.executionQualifications=getSettingsAsMap(data.executionQualifications);taskPlannerModel.availableFlavors=getSettingsAsMap(data.flavors);taskPlannerModel.taskTemplates=data.taskTemplates;taskPlannerModel.setViewOptions(data.viewOptions);$this.updateTaskList()});
websocketdataservice.onEvent("taskplanner.taskprogress",function(data){if(taskPlannerModel.tasks!=undefined)for(var i=0;i<taskPlannerModel.tasks.length;i++){var task=taskPlannerModel.tasks[i];if(task.id==data.id){if(task.history!=undefined&&task.history.length>0){task.history[0].progress=data.progress;task.history[0].executedSeriesCount=data.executedSeriesCount}break}}});this.loadTaskSettings=function(callback){errorservice.clearErrorContent("#taskdetailserror");dataservice.execute("taskplanner.loadfields",
{alertSelector:"#taskdetailserror",animateScrollSelector:this.getScrollParent(),data:JSON.stringify({id:taskPlannerModel.activeSetting.description.id,type:taskPlannerModel.activeSetting.type,taskId:taskPlannerModel.activeTask.id}),handleSuccess:function(response){if(typeof callback=="function")callback(response)}})};var onTaskChanged=function(data,preventUpdate){if(taskPlannerModel.tasks==undefined)return;var index=-1;for(var i=0;i<taskPlannerModel.tasks.length;i++){var task=taskPlannerModel.tasks[i];
if(task.id==data.task.id){index=i;break}}if(index>=0)if(data.deleted){taskPlannerModel.tasks.splice(index,1);if(taskPlannerModel.activeTask!=undefined&&taskPlannerModel.activeTask.id==data.task.id)taskPlannerModel.activeTask=undefined}else if(taskPlannerModel.activeTask!=undefined&&taskPlannerModel.activeTask.id==data.task.id)$this.loadTaskDetails();else{if(taskPlannerModel.tasks[index].lastmodified<=data.task.lastmodified)taskPlannerModel.tasks[index]=data.task}else if(data.deleted===false)taskPlannerModel.tasks.push(data.task);
if(!preventUpdate)$this.updateTaskList()};websocketdataservice.onEvent("taskplanner.taskchanged",onTaskChanged);var onTaskListChanged=function(data){if(data.resetTaskList)taskPlannerModel.tasks=[];taskPlannerModel.tasks=taskPlannerModel.tasks.concat(data.tasks);for(var i=0;i<data.tasks.length;i++){var change={task:data.tasks[i]};onTaskChanged(change,true)}$this.updateTaskList()};websocketdataservice.onEvent("taskplanner.tasklistchanged",onTaskListChanged);this.loadTaskDetails=function(){errorservice.clearErrorContent("#taskdetailserror");
dataservice.execute("taskplanner.taskdetails",{alertSelector:"#taskdetailserror",animateScrollSelector:this.getScrollParent(),data:JSON.stringify({id:taskPlannerModel.activeTask.id}),handleSuccess:function(response){if(response.task!=undefined)for(var i=0;i<taskPlannerModel.tasks.length;i++){var task=taskPlannerModel.tasks[i];if(task.id==response.task.id){taskPlannerModel.tasks.splice(i,1,response.task);$this.updateTaskList();break}}},beforeError:function(){errorservice.clearErrorContent("#taskdetailserror")}})};
this.deleteTask=function(callback){errorservice.clearErrorContent("#taskdetailserror");var deleteId=taskPlannerModel.activeTask.id;dataservice.execute("taskplanner.deletetask",{alertSelector:"#taskdetailserror",animateScrollSelector:this.getScrollParent(),data:JSON.stringify({id:deleteId}),handleSuccess:function(response){onTaskChanged({task:{id:deleteId},deleted:true});if(typeof callback=="function")callback()}})};this.cancelTask=function(executionId,callback){errorservice.clearErrorContent("#taskdetailserror");
var cancelId=taskPlannerModel.activeTask.id;dataservice.execute("taskplanner.canceltask",{alertSelector:"#taskdetailserror",animateScrollSelector:this.getScrollParent(),data:JSON.stringify({id:cancelId,executionId:executionId}),handleSuccess:function(response){onTaskChanged({task:{id:cancelId}});if(typeof callback=="function")callback()}})};this.activateTask=function(active,alertSelector,callback){errorservice.clearErrorContent(alertSelector);dataservice.execute("taskplanner.activatetask",{alertSelector:alertSelector,
animateScrollSelector:this.getScrollParent(alertSelector),data:JSON.stringify({id:taskPlannerModel.activeTask.id,active:active}),handleSuccess:function(response){taskPlannerModel.activeTask.active=active;$this.updateTaskList();if(typeof callback=="function")callback()}})};this.executeTask=function(callback){errorservice.clearErrorContent("#taskdetailserror");dataservice.execute("taskplanner.executetask",{alertSelector:"#taskdetailserror",animateScrollSelector:this.getScrollParent(),data:JSON.stringify({id:taskPlannerModel.activeTask.id}),
handleSuccess:function(response){if(typeof callback=="function")callback()}})};this.updatePropertyValues=function(callback){if(taskPlannerModel.activeSetting==undefined||taskPlannerModel.activeTask==undefined)return;var activeProperties=$.extend(true,{},taskPlannerModel.activeSetting.description.properties);$this.removeUnsaveableValues(activeProperties);var requestID=(new Date).getTime();dataservice.execute("taskplanner.updatesettings",{alertSelector:"#taskSettingsError",data:JSON.stringify({requestID:requestID,
id:taskPlannerModel.activeSetting.id,taskid:taskPlannerModel.activeTask.id,type:taskPlannerModel.activeSetting.type,properties:activeProperties,seriesId:taskPlannerModel.activeTask.serie!=undefined?taskPlannerModel.activeTask.serie.id:undefined,seriesProperties:taskPlannerModel.activeTask.serie!=undefined?taskPlannerModel.activeTask.serie.properties:undefined}),beforeExecute:function(){},afterExecute:function(){},beforeError:function(){errorservice.clearErrorContent("#taskSettingsError")},handleSuccess:function(response){if(requestID!=
response.requestID)return;if(taskPlannerModel.activeSetting==undefined)return;if(response.properties!=undefined){$.extend(true,taskPlannerModel.activeSetting.description.properties,response.properties);if(callback!=undefined)callback()}}})};this.removeUnsaveableValues=function(properties){var fields=taskPlannerModel.activeSetting.fields;if(fields!=undefined)for(var i=0;i<fields.length;i++){var field=fields[i];if(field.key!=null&&!field.valueSavable)delete properties[field.key]}};this.validateSetting=
function(callback){if(taskPlannerModel.activeSetting==undefined||taskPlannerModel.activeTask==undefined)return;errorservice.clearErrorContent("#taskSettingsError");var activeProperties=$.extend(true,{},taskPlannerModel.activeSetting.description.properties);$this.removeUnsaveableValues(activeProperties);var conditionProperties=undefined;if("condition"==taskPlannerModel.activeSetting.type){conditionProperties=activeProperties;for(let i=0;i<taskPlannerModel.activeTask.jobs.length;i++){let job=taskPlannerModel.activeTask.jobs[i];
if(job.id==taskPlannerModel.activeSetting.id){activeProperties=$.extend(true,{},job.properties);$this.removeUnsaveableValues(activeProperties);break}}}else for(let i=0;i<taskPlannerModel.activeTask.jobs.length;i++){let job=taskPlannerModel.activeTask.jobs[i];if(job.id==taskPlannerModel.activeSetting.id){conditionProperties=$.extend(true,{},job.conditionproperties);$this.removeUnsaveableValues(conditionProperties);break}}dataservice.execute("taskplanner.validatesettings",{alertSelector:"#taskSettingsError",
data:JSON.stringify({id:taskPlannerModel.activeSetting.id,taskid:taskPlannerModel.activeTask.id,type:taskPlannerModel.activeSetting.type,properties:activeProperties,conditionProperties:conditionProperties,serie:taskPlannerModel.activeTask.serie}),handleSuccess:function(response){if(typeof callback=="function")callback()}})};this.saveActiveTask=function(alertSelector,callback){this.saveTaskModel(alertSelector,taskPlannerModel.activeTask,callback)};this.saveTaskModel=function(alertSelector,taskModel,
callback){errorservice.clearErrorContent(alertSelector);dataservice.execute("taskplanner.savetask",{alertSelector:alertSelector,animateScrollSelector:this.getScrollParent(alertSelector),data:JSON.stringify({task:taskModel}),handleSuccess:function(response){taskModel.id=response.id;onTaskChanged({task:taskModel,deleted:false});if(typeof callback=="function")callback(response.id)}})};this.createTaskWithTemplate=function(alertSelector,taskModel,callback){errorservice.clearErrorContent(alertSelector);
dataservice.execute("taskplanner.createtaskwithtemplate",{alertSelector:alertSelector,animateScrollSelector:this.getScrollParent(alertSelector),data:JSON.stringify({name:taskModel.name,description:taskModel.description,templateKey:taskModel.templateKey}),handleSuccess:function(response){taskModel.id=response.id;onTaskChanged({task:taskModel,deleted:true});if(typeof callback=="function")callback(response.task.id)}})};this.updateConditions=function(){var getProperty=function(key){return taskPlannerModel.activeSetting.description.properties[key]};
if(taskPlannerModel.activeSetting==undefined||taskPlannerModel.activeSetting.fields==undefined)return;for(let i=0;i<taskPlannerModel.activeSetting.fields.length;i++){let field=taskPlannerModel.activeSetting.fields[i];delete field.hidden;delete field.disabled;if(field.conditions==undefined)continue;for(let j=0,c=field.conditions.length;j<c;j++){let condition=field.conditions[j];if(condition!=null)if(condition.type=="visible"){let value=condition.value;let fieldKey=condition.field.key;let fieldValue=
getProperty(fieldKey);let parentField=undefined;for(let p=0;p<taskPlannerModel.activeSetting.fields.length;p++){let pField=taskPlannerModel.activeSetting.fields[p];if(pField.key==fieldKey){parentField=pField;break}}if(condition.operation=="equals")if(field.hidden==undefined)field.hidden=fieldValue!=value||parentField.hidden===true;else field.hidden=field.hidden&&(fieldValue!=value||parentField.hidden===true);else if(condition.operation=="notequal")if(field.hidden==undefined)field.hidden=fieldValue==
value||parentField.hidden===true;else field.hidden=field.hidden&&(fieldValue==value||parentField.hidden===true);else if(condition.operation=="startswith")if(field.hidden==undefined)field.hidden=(fieldValue||"").lastIndexOf(value,0)!==0||parentField.hidden===true;else field.hidden=field.hidden&&((fieldValue||"").lastIndexOf(value,0)!==0||parentField.hidden===true);else console.error("no action for operation "+condition.operation+" found")}else if(condition.type=="disabled"){let value=condition.value;
let fieldKey=condition.field.key;let fieldValue=getProperty(fieldKey);let parentField=undefined;for(let p=0;p<taskPlannerModel.activeSetting.fields.length;p++){let pField=taskPlannerModel.activeSetting.fields[p];if(pField.key==fieldKey){parentField=pField;break}}if(condition.operation=="equals")if(field.disabled==undefined)field.disabled=fieldValue==value||parentField.disabled===true;else field.disabled=field.disabled&&(fieldValue==value||parentField.disabled===true);else if(condition.operation==
"notequal")if(field.disabled==undefined)field.disabled=fieldValue!=value||parentField.disabled===true;else field.disabled=field.disabled&&(fieldValue!=value||parentField.disabled===true);else if(condition.operation=="startswith")if(field.disabled==undefined)field.disabled=(fieldValue||"").lastIndexOf(value,0)===0||parentField.disabled===true;else field.disabled=field.disabled&&((fieldValue||"").lastIndexOf(value,0)===0||parentField.disabled===true);else console.error("no action for operation "+condition.operation+
" found")}else console.error("no action for type: "+condition.type+" found")}}$timeout(function(){var placeholdersActive=false;if(taskPlannerModel.activeSetting.placeholders!=undefined&&taskPlannerModel.activeSetting.placeholders.length>0)placeholdersActive=$('#tasksettingsdialog input[type\x3d"text"]:not(.colorchooser), #tasksettingsdialog textarea').length>0;if(taskPlannerModel.activeSetting.placeholders!=undefined)taskPlannerModel.activeSetting.displayPlaceholders=placeholdersActive})};this.registerRenderer=
function(type,renderFunction){if(this.renderer[type]!=undefined){console.error("The renderer "+type+" is already registered.");return}this.renderer[type]=renderFunction};this.getRenderer=function(type){return this.renderer[type]};this.getSelectInputChunkData=function(fieldId,chunkSize,currentSize,filter,customvalue,callback,alertSelector){dataservice.execute("selectinput_getdata",{alertSelector:alertSelector,data:JSON.stringify({inputFieldId:fieldId,chunkSize:chunkSize,currentSize:currentSize,filter:filter}),
handleSuccess:function(dataResponse){callback(dataResponse.entries,dataResponse.totalCount)},beforeExecute:function(){},afterExecute:function(){}})};this.sendViewOptions=function(){var optionsToSave=$.extend({},taskPlannerModel.viewoptions);delete optionsToSave.filter;dataservice.execute("taskplanner.viewoptions",{data:JSON.stringify({pollingID:websocketdataservice.getPollingID(),viewOptions:optionsToSave}),handleSuccess:function(response){}})};this.updateTaskList=function(){var tasks=[];for(let i=
0;i<taskPlannerModel.tasks.length;i++)if(taskPlannerModel.tasks[i].isDivider==undefined||taskPlannerModel.tasks[i].isDivider!=true)tasks.push(taskPlannerModel.tasks[i]);tasks.sort(function(a,b){var desc=taskPlannerModel.viewoptions.sorting_order=="desc";var va=a.isDivider?a.id:taskPlannerModel.getElementByID(taskPlannerModel.sorting.type,taskPlannerModel.viewoptions.sorting_type).tovalue(a);var vb=b.isDivider?b.id:taskPlannerModel.getElementByID(taskPlannerModel.sorting.type,taskPlannerModel.viewoptions.sorting_type).tovalue(b);
if(va>vb)return desc?-1:1;if(va<vb)return desc?1:-1;va=a.isDivider?a.id:taskPlannerModel.getElementByID(taskPlannerModel.sorting.type,"lastmodified").tovalue(a);vb=b.isDivider?b.id:taskPlannerModel.getElementByID(taskPlannerModel.sorting.type,"lastmodified").tovalue(b);if(va>vb)return desc?-1:1;if(va<vb)return desc?1:-1;va=a.isDivider?a.id:taskPlannerModel.getElementByID(taskPlannerModel.sorting.type,"name").tovalue(a);vb=b.isDivider?b.id:taskPlannerModel.getElementByID(taskPlannerModel.sorting.type,
"name").tovalue(b);if(va>vb)return desc?-1:1;if(va<vb)return desc?1:-1;return 0});var currentGroupLabel,previousGroupLabel;var groupType=taskPlannerModel.getElementByID(taskPlannerModel.sorting.type,taskPlannerModel.viewoptions.sorting_type);for(let i=0;i<tasks.length;i++){let value=tasks[i];let currentGroupValue=taskPlannerModel.getElementByID(taskPlannerModel.sorting.type,taskPlannerModel.viewoptions.sorting_type).tovalue(value);if(taskPlannerModel.viewoptions.sorting_type=="nextexecution"||taskPlannerModel.viewoptions.sorting_type==
"lastmodified"||taskPlannerModel.viewoptions.sorting_type=="lastexecution"){currentGroupValue=taskPlannerModel.toFixedDate(currentGroupValue);currentGroupLabel=taskPlannerModel.timeToText(currentGroupValue*1E3)}else currentGroupLabel=""+currentGroupValue;if(!previousGroupLabel||currentGroupLabel!=previousGroupLabel){let divider={isDivider:true,name:"_",id:currentGroupValue};divider[groupType.id]=currentGroupValue;if(groupType.id!="name"){tasks.splice(i,0,divider);i++}}previousGroupLabel=currentGroupLabel}taskPlannerModel.tasks=
tasks}});