/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.webapi.handler.guid.viewtask;

import com.inet.annotations.JsonData;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.job.JobInfo;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;

@Schema(description="Container for information about a single job.")
@JsonData
public class JobDescription {
    @Schema(description="Unique identifier of the job.", example="job123")
    private String id;
    @Schema(description="Properties of the job.")
    private Map<String, String> properties;
    @Schema(description="Condition properties of the job.")
    private Map<String, String> conditionproperties;

    private JobDescription() {
    }

    public static JobDescription from(JobDefinition definition) {
        JobDescription jobDescription = new JobDescription();
        jobDescription.id = definition.getExtensionName();
        jobDescription.properties = definition.getProperties();
        ConditionDefinition conditionDefinition = definition.getCondition();
        jobDescription.conditionproperties = conditionDefinition != null ? conditionDefinition.getProperties() : null;
        return jobDescription;
    }

    public static JobDefinition toJobDefinition(JobDescription description, GUID taskId, SeriesDefinition seriesDefinition) {
        JobFactory jobFactory = (JobFactory)ServerPluginManager.getInstance().getSingleInstanceByName(JobFactory.class, description.id, false);
        JobInfo jobInfo = (JobInfo)jobFactory.getInformation(taskId);
        for (Field field : jobInfo.getFields()) {
            if (description.properties.containsKey(field.getKey())) continue;
            description.properties.put(field.getKey(), field.getValue());
        }
        JobDefinition jobDefinition = new JobDefinition(description.id, description.properties);
        if (description.conditionproperties != null) {
            jobDefinition.setCondition(new ConditionDefinition(description.conditionproperties));
        }
        try {
            jobFactory.validate(jobDefinition, seriesDefinition, taskId);
            if (description.conditionproperties != null) {
                jobFactory.validateCondition(jobDefinition, seriesDefinition, taskId);
            }
        }
        catch (ValidationException validationException) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)validationException);
            throw new ClientMessageException(validationException.getMessage());
        }
        return jobDefinition;
    }
}

