/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.event;

import com.inet.annotations.PublicApi;
import com.inet.id.GUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public class TaskEvent {
    private final TaskEventType aq;
    private final GUID taskID;
    private final GUID ar;
    private final int progress;

    public TaskEvent(@Nonnull TaskEventType type, @Nonnull GUID taskID) {
        this(type, taskID, null, 0);
    }

    public TaskEvent(@Nonnull TaskEventType type, @Nonnull GUID taskID, @Nonnull GUID executionID) {
        this(type, taskID, executionID, 0);
        if (executionID == null) {
            throw new IllegalArgumentException("executionID must not be null");
        }
    }

    private TaskEvent(@Nonnull TaskEventType type, @Nonnull GUID taskID, @Nullable GUID executionID, int progress) {
        this.progress = progress;
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (taskID == null) {
            throw new IllegalArgumentException("taskID must not be null");
        }
        this.ar = executionID;
        this.aq = type;
        this.taskID = taskID;
    }

    public TaskEvent(int progress, @Nonnull GUID taskID, @Nonnull GUID executionID) {
        this(TaskEventType.PROGRESS, taskID, executionID, progress);
        if (executionID == null) {
            throw new IllegalArgumentException("executionID must not be null");
        }
    }

    @Nonnull
    public TaskEventType getType() {
        return this.aq;
    }

    @Nonnull
    public GUID getTaskID() {
        return this.taskID;
    }

    public int getProgress() {
        return this.progress;
    }

    @Nullable
    public GUID getExecutionID() {
        return this.ar;
    }

    public String toString() {
        return String.valueOf(this.taskID) + " " + String.valueOf((Object)this.aq);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.taskID == null ? 0 : this.taskID.hashCode());
        n3 = 31 * n3 + (this.aq == null ? 0 : this.aq.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskEvent taskEvent = (TaskEvent)obj;
        if (this.taskID == null ? taskEvent.taskID != null : !this.taskID.equals((Object)taskEvent.taskID)) {
            return false;
        }
        return this.aq == taskEvent.aq;
    }

    @PublicApi
    public static final class TaskEventType
    extends Enum<TaskEventType> {
        public static final /* enum */ TaskEventType ADDED = new TaskEventType();
        public static final /* enum */ TaskEventType MODIFIED = new TaskEventType();
        public static final /* enum */ TaskEventType ACTIVATED = new TaskEventType();
        public static final /* enum */ TaskEventType DEACTIVATED = new TaskEventType();
        public static final /* enum */ TaskEventType REMOVED = new TaskEventType();
        public static final /* enum */ TaskEventType EXECUTION_STARTED = new TaskEventType();
        public static final /* enum */ TaskEventType PROGRESS = new TaskEventType();
        public static final /* enum */ TaskEventType EXECUTION_ENDED = new TaskEventType();
        private static final /* synthetic */ TaskEventType[] as;

        public static TaskEventType[] values() {
            return (TaskEventType[])as.clone();
        }

        public static TaskEventType valueOf(String name) {
            return Enum.valueOf(TaskEventType.class, name);
        }

        private static /* synthetic */ TaskEventType[] o() {
            return new TaskEventType[]{ADDED, MODIFIED, ACTIVATED, DEACTIVATED, REMOVED, EXECUTION_STARTED, PROGRESS, EXECUTION_ENDED};
        }

        static {
            as = TaskEventType.o();
        }
    }
}

