/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigurationManager;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.http.PluginServlet;
import com.inet.http.websocket.WebSocketEvent;
import com.inet.id.GUID;
import com.inet.logging.CoreLoggers;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.maintenance.api.MaintenanceExtension;
import com.inet.maintenance.api.MaintenanceHandler;
import com.inet.notification.Notification;
import com.inet.notification.NotificationGroup;
import com.inet.notification.NotificationManager;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.Executable;
import com.inet.plugin.FeatureLicenseInformation;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.ServerPluginManagerListener;
import com.inet.plugin.help.HelpPage;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.plugin.webapi.api.WebAPIExtension;
import com.inet.remote.gui.IModule;
import com.inet.setupwizard.api.SetupStep;
import com.inet.setupwizard.basicsteps.plugins.PluginActivationInformation;
import com.inet.taskplanner.a;
import com.inet.taskplanner.d;
import com.inet.taskplanner.maintenance.handler.e;
import com.inet.taskplanner.maintenance.handler.f;
import com.inet.taskplanner.maintenance.handler.g;
import com.inet.taskplanner.maintenance.handler.h;
import com.inet.taskplanner.maintenance.job.b;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.email.EmailResultActionFactory;
import com.inet.taskplanner.server.api.action.print.PrintResultActionFactory;
import com.inet.taskplanner.server.api.action.savefile.SaveFileResultActionFactory;
import com.inet.taskplanner.server.api.fileservice.FileServiceForTaskPlanner;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.series.db.DbSeriesFactory;
import com.inet.taskplanner.server.api.series.folder.FolderSeriesFactory;
import com.inet.taskplanner.server.api.series.json.JsonSeriesFactory;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.cron.CronTriggerFactory;
import com.inet.taskplanner.server.api.trigger.filechange.FileChangeService;
import com.inet.taskplanner.server.api.trigger.filechange.FileChangeTriggerFactory;
import com.inet.taskplanner.server.api.trigger.filechange.c;
import com.inet.taskplanner.server.api.trigger.lowmemory.LowMemoryTriggerFactory;
import com.inet.taskplanner.server.api.trigger.serverstart.ServerStartTriggerFactory;
import com.inet.taskplanner.server.api.trigger.serverstop.ServerStopTriggerFactory;
import com.inet.taskplanner.server.api.trigger.time.TimeTriggerFactory;
import com.inet.taskplanner.server.internal.i;
import com.inet.taskplanner.server.internal.j;
import com.inet.theme.server.ThemeResource;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.FieldAndGroupTypeAssociation;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import com.inet.usersandgroups.api.user.UserEventListener;
import com.inet.usersandgroupsmanager.api.UserDeletionMessageProvider;
import java.net.URL;
import java.util.List;
import javax.annotation.Nonnull;

@PluginInfo(id="taskplanner", dependencies="remotegui;htmlengine", optionalDependencies="theme;setupwizard;webapi.core;mail;maintenance;usersandgroupsmanager;ai", packages="com.inet.taskplanner.server.api;com.inet.taskplanner.server.internalapi", group="applications;taskplanner;webapi", version="25.10.217", icon="com/inet/taskplanner/structure/taskplanner_48.png", internal="cron-utils.jar;guava.jar;commons-cli.jar", flags="optional")
public class TaskPlannerServerPlugin
implements ServerPlugin {
    public static final String PLUGIN_ID = "taskplanner";
    public static final String TASKPLANNER_APP_JS = "taskplanner.js";
    public static final String TASKPLANNER_APP_EXTRAS_JS = "taskplanner.extras.js";
    @Nonnull
    public static final Logger LOGGER = LogManager.getLogger((String)"Task Planner");
    public static final I18nMessages MSG = new I18nMessages("com.inet.taskplanner.i18n.taskplanner", TaskPlannerServerPlugin.class);
    public static final I18nMessages MSG_CLIENT = new I18nMessages("com.inet.taskplanner.client.i18n.LanguageResources", TaskPlannerServerPlugin.class);
    public static final I18nMessages MSG_MAINTENANCE_CLIENT = new I18nMessages("com.inet.taskplanner.maintenance.i18n.LanguageResources", TaskPlannerServerPlugin.class);
    public static final UserField<String> USERFIELD_TASKPLANNERVIEWOPTIONS = new UserField<String>("taskplannerviewoptions", FieldTypeFactory.auto().withoutSearchTag()){};
    private com.inet.taskplanner.server.webinterface.c a;
    private com.inet.taskplanner.b b;
    private PrintResultActionFactory c;

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("programming", 9102, new Permission[]{TaskPlanner.PERMISSION_TASKPLANNER}){}, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl(PLUGIN_ID, 9101, new Permission[]{TaskPlanner.PERMISSION_TASKPLANNER}){

            public boolean isVisible(@Nonnull HelpPage helpPage) {
                if (!super.isVisible(helpPage)) {
                    return false;
                }
                if (ConfigurationManager.isHelpCenterMode()) {
                    return true;
                }
                try {
                    if ("taskplanner.action.savefile".equals(helpPage.getKey())) {
                        ResultActionFactory resultActionFactory = (ResultActionFactory)ServerPluginManager.getInstance().getSingleInstanceByName(ResultActionFactory.class, "result.savefile", false);
                        return resultActionFactory.isAvailable();
                    }
                    if ("taskplanner.series.json".equals(helpPage.getKey())) {
                        SeriesFactory seriesFactory = (SeriesFactory)ServerPluginManager.getInstance().getSingleInstanceByName(SeriesFactory.class, "series.json", false);
                        return seriesFactory.isAvailable();
                    }
                    if ("taskplanner.trigger.filechange".equals(helpPage.getKey())) {
                        TriggerFactory triggerFactory = (TriggerFactory)ServerPluginManager.getInstance().getSingleInstanceByName(TriggerFactory.class, "trigger.filechange", false);
                        return triggerFactory.isAvailable();
                    }
                    if ("taskplanner.action.email".equals(helpPage.getKey())) {
                        ResultActionFactory resultActionFactory = (ResultActionFactory)ServerPluginManager.getInstance().getSingleInstanceByName(ResultActionFactory.class, "result.email", false);
                        return resultActionFactory.isAvailable();
                    }
                    if ("taskplanner.trigger.serverstop".equals(helpPage.getKey())) {
                        return SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    LOGGER.error((Throwable)illegalStateException);
                    return false;
                }
                return true;
            }
        }, new String[0]);
        container.add((HelpProvider)new HelpProviderImpl("webapi", 9152, true, new Permission[]{Permission.valueOfExistingOrCreate((String)"webapi.core"), Permission.CONFIGURATION}){}, new String[]{"webapi.core"});
        container.add((HelpProvider)new HelpProviderImpl("maintenance", 9153, new Permission[]{Permission.CONFIGURATION}){}, new String[]{"maintenance"});
    }

    public void registerExtension(final ServerPluginManager spm) {
        CoreLoggers.addLoggers((String[])new String[]{"Task Planner"});
        spm.register(UserField.class, USERFIELD_TASKPLANNERVIEWOPTIONS);
        spm.register(FeatureLicenseInformation.class, (Object)new com.inet.taskplanner.c());
        this.a = new com.inet.taskplanner.server.webinterface.c();
        spm.register(WebSocketEvent.class, (Object)new com.inet.taskplanner.server.webinterface.events.b(this.a));
        spm.register(WebSocketEvent.class, (Object)new com.inet.taskplanner.server.webinterface.events.c(this.a));
        spm.register(IModule.class, (Object)new d());
        this.b = new com.inet.taskplanner.b();
        spm.register(PluginServlet.class, (Object)this.b);
        spm.register(TriggerFactory.class, (Object)new TimeTriggerFactory());
        spm.register(TriggerFactory.class, (Object)new CronTriggerFactory());
        spm.register(TriggerFactory.class, (Object)new LowMemoryTriggerFactory());
        spm.register(TriggerFactory.class, (Object)new FileChangeTriggerFactory());
        spm.register(FileChangeService.class, (Object)new c());
        spm.register(TriggerFactory.class, (Object)new ServerStartTriggerFactory());
        spm.register(TriggerFactory.class, (Object)new ServerStopTriggerFactory());
        spm.runIfPluginLoaded("mail", () -> new Executable(){

            public void execute() {
                spm.register(ResultActionFactory.class, (Object)new EmailResultActionFactory());
            }
        });
        spm.register(ResultActionFactory.class, (Object)new SaveFileResultActionFactory());
        spm.register(ResultActionFactory.class, (Object)new com.inet.taskplanner.server.api.action.nexttask.b());
        spm.register(FileServiceForTaskPlanner.class, (Object)new com.inet.taskplanner.server.api.fileservice.a());
        this.c = new PrintResultActionFactory();
        spm.register(ResultActionFactory.class, (Object)this.c);
        spm.register(SeriesFactory.class, (Object)new JsonSeriesFactory());
        spm.register(SeriesFactory.class, (Object)new DbSeriesFactory());
        spm.register(SeriesFactory.class, (Object)new FolderSeriesFactory());
        FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
        combinedFile.add(this.getClass(), "client/js/app.js");
        combinedFile.add(this.getClass(), "client/js/fields/boolean.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/colorField.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/filechooserAddonButton.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/numberRange.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/numberWrapper.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/passwordTextField.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/renderer.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/simpleDateTimeField.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/simpleFileFolderField.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/simpleGroup.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/simpleLabel.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/simpleLink.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/simpleSelect.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/simpleTextField.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/stringTable.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/textAreaField.directive.js");
        combinedFile.add(this.getClass(), "client/js/fields/simpleCurrencyField.directive.js");
        combinedFile.add(this.getClass(), "client/js/model.js");
        combinedFile.add(this.getClass(), "client/js/factory.js");
        combinedFile.add(this.getClass(), "client/js/controller.js");
        combinedFile.addMessages(MSG_CLIENT);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", TASKPLANNER_APP_JS, combinedFile));
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", TASKPLANNER_APP_EXTRAS_JS, new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0])));
        spm.runIfPluginLoaded("theme", () -> new Executable(){

            public void execute() {
                spm.register(ThemeResource.class, (Object)new ThemeResource(100, "remotegui", ((Object)((Object)this)).getClass().getResource("client/css/taskplanner.less")));
                spm.register(ThemeResource.class, (Object)new ThemeResource(101, "remotegui", ((Object)((Object)this)).getClass().getResource("client/css/taskplanner_sprites.less")));
            }
        });
        FileCombiner.CombinedFile combinedFile2 = new FileCombiner.CombinedFile("text/css; charset=utf-8", new URL[0]);
        combinedFile2.add(this.getClass(), "client/css/taskplanner.css");
        combinedFile2.add(this.getClass(), "client/css/taskplanner_sprites.css");
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "defaulttheme.css", combinedFile2));
        spm.runIfPluginLoaded("setupwizard", () -> new Executable(){

            public void execute() {
                spm.register(PluginActivationInformation.class, (Object)new com.inet.taskplanner.webapi.b());
                spm.register(SetupStep.class, (Object)new com.inet.taskplanner.setup.actionmigration.b());
                spm.register(SetupStep.class, (Object)new com.inet.taskplanner.setup.actionmigration.a());
            }
        });
        spm.register(ServerPluginManagerListener.class, (Object)new com.inet.taskplanner.setup.a());
        spm.register(UserEventListener.class, (Object)new j());
        spm.runIfPluginLoaded("webapi.core", () -> new Executable(){

            public void execute() {
                spm.register(WebAPIExtension.class, (Object)new com.inet.taskplanner.webapi.a());
            }
        });
        spm.runIfPluginLoaded("maintenance", () -> new Executable(){

            public void execute() {
                spm.register(MaintenanceExtension.class, (Object)new com.inet.taskplanner.maintenance.a());
                spm.register(MaintenanceHandler.class, (Object)new g());
                spm.register(MaintenanceHandler.class, (Object)new f());
                spm.register(MaintenanceHandler.class, (Object)new com.inet.taskplanner.maintenance.handler.c());
                spm.register(MaintenanceHandler.class, (Object)new h());
                spm.register(MaintenanceHandler.class, (Object)new e());
                spm.register(MaintenanceHandler.class, (Object)new com.inet.taskplanner.maintenance.handler.b());
                spm.register(MaintenanceHandler.class, (Object)new com.inet.taskplanner.maintenance.handler.d());
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("text/html; charset=utf-8", new URL[0]);
                combinedFile.add(TaskPlannerServerPlugin.class, "/com/inet/taskplanner/maintenance/taskplanner_maintenance.html");
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "taskplanner_maintenance/taskplanner_maintenance.html", combinedFile));
                FileCombiner.CombinedFile combinedFile2 = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile2.add(TaskPlannerServerPlugin.class, "/com/inet/taskplanner/maintenance/taskplanner_maintenance.js");
                combinedFile2.addMessages(MSG_MAINTENANCE_CLIENT);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 102, "maintenance.js", combinedFile2));
                spm.register(JobFactory.class, (Object)new b());
            }
        });
        spm.register(NotificationGroup.class, (Object)new NotificationGroup(){

            @Nonnull
            public String getExtensionName() {
                return "taskplanner.notification.error";
            }

            public URL getIconURL() {
                return TaskPlannerServerPlugin.class.getResource("/com/inet/taskplanner/structure/taskplanner_error_32.png");
            }

            public String getDisplayName() {
                return MSG.getMsg("taskplanner.notification.error.title", new Object[0]);
            }

            public LocalizedKey getParentGroup() {
                return new LocalizedKey("taskplanner.notification", MSG.getMsg("plugin.id", new Object[0]));
            }

            public boolean isDefaultActiveForWebnotifications() {
                return true;
            }

            public boolean canBeConfiguredByUser() {
                return SystemPermissionChecker.checkAccess((Permission)TaskPlanner.PERMISSION_TASKPLANNER);
            }
        });
        spm.register(NotificationGroup.class, (Object)new NotificationGroup(){

            @Nonnull
            public String getExtensionName() {
                return "taskplanner.notification.status";
            }

            public URL getIconURL() {
                return TaskPlannerServerPlugin.class.getResource("/com/inet/taskplanner/structure/taskplanner_state_32.png");
            }

            public String getDisplayName() {
                return MSG.getMsg("taskplanner.notification.status.title", new Object[0]);
            }

            public LocalizedKey getParentGroup() {
                return new LocalizedKey("taskplanner.notification", MSG.getMsg("plugin.id", new Object[0]));
            }

            public boolean isDefaultActiveForWebnotifications() {
                return false;
            }

            public boolean canBeConfiguredByUser() {
                return SystemPermissionChecker.checkAccess((Permission)TaskPlanner.PERMISSION_TASKPLANNER);
            }
        });
        spm.register(UserGroupField.class, com.inet.taskplanner.server.internal.e.bW);
        spm.register(FieldAndGroupTypeAssociation.class, (Object)new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_ALLUSERS, new String[]{com.inet.taskplanner.server.internal.e.bW.getKey()}));
        spm.runIfPluginLoaded("usersandgroupsmanager", () -> new Executable(){

            public void execute() {
                DynamicExtensionManager dynamicExtensionManager = DynamicExtensionManager.getInstance();
                dynamicExtensionManager.register(UserDeletionMessageProvider.class, (Object)new i());
                spm.register(NotificationGroup.class, (Object)new NotificationGroup(){

                    @Nonnull
                    public String getExtensionName() {
                        return "taskplanner.notification.warning";
                    }

                    public URL getIconURL() {
                        return TaskPlannerServerPlugin.class.getResource("/com/inet/taskplanner/structure/taskplanner_warning_32.png");
                    }

                    public String getDisplayName() {
                        return MSG.getMsg("taskplanner.notification.warning.title", new Object[0]);
                    }

                    public LocalizedKey getParentGroup() {
                        return new LocalizedKey("taskplanner.notification", MSG.getMsg("plugin.id", new Object[0]));
                    }

                    public boolean isDefaultActiveForWebnotifications() {
                        return true;
                    }

                    public boolean canBeConfiguredByUser() {
                        return SystemPermissionChecker.isAdministrator();
                    }
                });
                spm.register(UserEventListener.class, (Object)new UserEventAdapter(){

                    public void userAccountDeactivated(@Nonnull UserAccount userAccount) {
                        List<GUID> list = TaskPlanner.getInstance().getUserTaskIDs(userAccount.getID());
                        int n2 = list.size();
                        if (n2 > 0) {
                            Notification notification = new Notification("", "");
                            notification.setGroupingKey("taskplanner.notification.warning");
                            notification.setId(userAccount.getID());
                            notification.setTargetUrl("/taskplanner".substring(1) + "/");
                            notification.setTitle(MSG.getMsg("taskplanner.notification.task.userdeactivated.title", new Object[]{userAccount.getDisplayName()}));
                            notification.setMessage(MSG.getMsg("taskplanner.notification.task.userdeactivated.message", new Object[]{n2}));
                            notification.setCritical(true);
                            NotificationManager.getInstance().sendNotificationToAllAdministrators(notification);
                        }
                    }
                });
            }
        });
    }

    public void init(ServerPluginManager spm) {
        TaskPlanner.getInstance().registerEventListener(new a());
        this.a.a();
        if (ServerPluginManager.IS_SERVLET_API) {
            this.b.a();
        }
        this.c.init(spm);
    }

    public void reset() {
        this.a.reset();
        try {
            com.inet.taskplanner.server.internal.f.M().reset();
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.debug((Object)illegalStateException);
        }
    }

    public void restart() {
    }
}

