/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.webinterface.data;

import com.inet.annotations.JsonData;
import com.inet.taskplanner.server.internalapi.NextExecutionDescription;
import com.inet.taskplanner.server.webinterface.data.AvailableKeyListDescription;
import com.inet.taskplanner.server.webinterface.data.HistoryDescription;
import com.inet.taskplanner.server.webinterface.data.JobDescription;
import com.inet.taskplanner.server.webinterface.data.ResultActionDescription;
import com.inet.taskplanner.server.webinterface.data.SerieDescription;
import com.inet.taskplanner.server.webinterface.data.TriggerDescription;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@JsonData
@Schema(description="Model representing a task with various attributes.")
public class TaskDescription {
    @Schema(description="Unique identifier of the task.", example="b6nmv97sutmnvhtw8hen0yh7y")
    private String id;
    @Schema(description="Timestamp of the last modification.")
    private long lastmodified;
    @Schema(description="Name of the task.", example="Sample Task")
    private String name;
    @Schema(description="Description of the task.", example="This is a sample task.")
    private String description;
    @Schema(description="Owner of the task.", example="user123")
    private String owner;
    @Schema(description="Indicates if the task is active.")
    private boolean active;
    @Schema(description="Indicates if the owner is deactivated.")
    private boolean ownerDeactivated;
    @Schema(description="Next execution details of the task.")
    private NextExecutionDescription nextExecution;
    @Schema(description="List of triggers associated with the task.")
    private List<TriggerDescription> trigger;
    @Schema(description="List of jobs associated with the task.")
    private List<JobDescription> jobs;
    @Schema(description="List of result actions associated with the task.")
    private List<ResultActionDescription> results;
    @Schema(description="Series description of the task.")
    private SerieDescription serie;
    @Schema(description="History of the task.")
    private List<HistoryDescription> history;
    @Schema(description="Indicates if full details are available.")
    private boolean fullDetails;
    @Schema(description="Available keys for the task.")
    private AvailableKeyListDescription availableKeys;
    @Schema(description="Indicates if this is a system task (executed with privileged scope).")
    private boolean systemTask;

    private TaskDescription() {
    }

    public TaskDescription(String id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getLastmodified() {
        return this.lastmodified;
    }

    public void setLastmodified(long lastmodified) {
        this.lastmodified = lastmodified;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<TriggerDescription> getTrigger() {
        return this.trigger;
    }

    public void setTrigger(List<TriggerDescription> trigger) {
        this.trigger = trigger;
    }

    public List<JobDescription> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<JobDescription> jobs) {
        this.jobs = jobs;
    }

    public List<ResultActionDescription> getResults() {
        return this.results;
    }

    public void setResults(List<ResultActionDescription> results) {
        this.results = results;
    }

    public void setSerie(SerieDescription serie) {
        this.serie = serie;
    }

    public SerieDescription getSerie() {
        return this.serie;
    }

    public List<HistoryDescription> getHistory() {
        return this.history;
    }

    public void setHistory(List<HistoryDescription> history) {
        this.history = history;
    }

    public boolean isFullDetails() {
        return this.fullDetails;
    }

    public void setFullDetails(boolean fullDetails) {
        this.fullDetails = fullDetails;
    }

    public NextExecutionDescription getNextExecution() {
        return this.nextExecution;
    }

    public void setNextExecution(NextExecutionDescription nextExecution) {
        this.nextExecution = nextExecution;
    }

    public void setAvailables(AvailableKeyListDescription availableKeys) {
        this.availableKeys = availableKeys;
    }

    public AvailableKeyListDescription getAvailables() {
        return this.availableKeys;
    }

    public boolean isSystemTask() {
        return this.systemTask;
    }

    public void setSystemTask(boolean systemTask) {
        this.systemTask = systemTask;
    }

    public boolean isOwnerDeactivated() {
        return this.ownerDeactivated;
    }

    public void setOwnerDeactivated(boolean ownerDeactivated) {
        this.ownerDeactivated = ownerDeactivated;
    }
}

