/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.trigger.time;

import com.inet.annotations.PublicApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.id.GUID;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.DateField;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.NumberField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TimeField;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.taskplanner.server.api.trigger.cron.CronTriggerFactory;
import com.inet.taskplanner.server.api.trigger.time.MonthlyDay;
import com.inet.taskplanner.server.api.trigger.time.RepeatInterval;
import com.inet.taskplanner.server.api.trigger.time.TimeTriggerForCustomSettings;
import com.inet.taskplanner.server.api.trigger.time.a;
import com.inet.taskplanner.server.webinterface.b;
import java.net.URL;
import java.time.DayOfWeek;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Predicate;

@PublicApi
public class TimeTriggerFactory
extends TriggerFactory<Trigger> {
    public static final String EXTENSION_NAME = "trigger.time";
    public static final String PROP_START_DAY = "start.day";
    public static final String PROP_START_TIME = "start.time";
    public static final String PROP_REPEAT_SELECT = "repeat.select";
    public static final String PROP_WHICH_SELECT = "which.select";

    public TimeTriggerFactory() {
        super(EXTENSION_NAME);
    }

    @Override
    protected Trigger createInstanceFrom(TriggerDefinition definition, GUID taskID) {
        RepeatInterval repeatInterval = RepeatInterval.valueOf(definition.getProperty(PROP_REPEAT_SELECT));
        if (repeatInterval == RepeatInterval.CUSTOM) {
            return new TimeTriggerForCustomSettings(definition);
        }
        return new a(definition);
    }

    @Override
    public TriggerInfo getInformation(GUID taskID) {
        String string = TaskPlannerServerPlugin.MSG.getMsg("trigger.time.name", new Object[0]);
        String string2 = TaskPlannerServerPlugin.MSG.getMsg("trigger.time.description", new Object[0]);
        URL uRL = this.getClass().getResource("/com/inet/taskplanner/server/api/trigger/time/time.png");
        String string3 = "taskplanner.trigger.time";
        TriggerInfo triggerInfo = new TriggerInfo(this.getExtensionName(), string, string2, uRL, string3, this.s());
        return triggerInfo;
    }

    private List<Field> s() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        TimeTriggerFactory.addTimeZoneDifferenceHintIfRequired(arrayList);
        Date date = new Date(System.currentTimeMillis() + 3600000L);
        DateField dateField = new DateField(PROP_START_DAY, TaskPlannerServerPlugin.MSG.getMsg("trigger.time.start.day", new Object[0]));
        dateField.setValue(String.valueOf(date.getTime()));
        dateField.setUpdateValuesOnChange(true);
        arrayList.add(dateField);
        TimeField timeField = new TimeField(PROP_START_TIME, TaskPlannerServerPlugin.MSG.getMsg("trigger.time.start.time", new Object[0]));
        timeField.setValue(String.valueOf(date.getTime()));
        timeField.setUpdateValuesOnChange(true);
        arrayList.add(timeField);
        ArrayList<LocalizedKey> arrayList2 = new ArrayList<LocalizedKey>();
        arrayList2.add(new LocalizedKey(RepeatInterval.NONE.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.repeat.none", new Object[0])));
        arrayList2.add(new LocalizedKey(RepeatInterval.DAILY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.repeat.daily", new Object[0])));
        arrayList2.add(new LocalizedKey(RepeatInterval.WORKDAYS.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.repeat.workdays", new Object[0])));
        arrayList2.add(new LocalizedKey(RepeatInterval.WEEKLY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.repeat.weekly", new Object[0])));
        arrayList2.add(new LocalizedKey(RepeatInterval.TWOWEEKS.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.repeat.twoweeks", new Object[0])));
        arrayList2.add(new LocalizedKey(RepeatInterval.MONTHLY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.repeat.monthly", new Object[0])));
        arrayList2.add(new LocalizedKey(RepeatInterval.QUARTERLY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.repeat.quarterly", new Object[0])));
        arrayList2.add(new LocalizedKey(RepeatInterval.YEARLY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.exection.yearly", new Object[0])));
        arrayList2.add(new LocalizedKey(RepeatInterval.CUSTOM.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.exection.custom", new Object[0])));
        SelectField selectField = new SelectField(PROP_REPEAT_SELECT, TaskPlannerServerPlugin.MSG.getMsg(PROP_REPEAT_SELECT, new Object[0]), arrayList2);
        selectField.setValue(RepeatInterval.NONE.name());
        selectField.setUpdateValuesOnChange(true);
        arrayList.add(selectField);
        ArrayList<FieldCondition> arrayList3 = new ArrayList<FieldCondition>();
        arrayList3.add(FieldCondition.visible(selectField, FieldCondition.OP.equals, RepeatInterval.MONTHLY.name()));
        ArrayList<LocalizedKey> arrayList4 = new ArrayList<LocalizedKey>();
        arrayList4.add(new LocalizedKey(MonthlyDay.INITIAL.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.which.initial", new Object[0])));
        arrayList4.add(new LocalizedKey(MonthlyDay.FIRST.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.which.first", new Object[0])));
        arrayList4.add(new LocalizedKey(MonthlyDay.SECOND.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.which.second", new Object[0])));
        arrayList4.add(new LocalizedKey(MonthlyDay.THIRD.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.which.third", new Object[0])));
        arrayList4.add(new LocalizedKey(MonthlyDay.FOURTH.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.which.fourth", new Object[0])));
        arrayList4.add(new LocalizedKey(MonthlyDay.LAST.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.which.last", new Object[0])));
        SelectField selectField2 = new SelectField(PROP_WHICH_SELECT, TaskPlannerServerPlugin.MSG.getMsg(PROP_WHICH_SELECT, new Object[0]), arrayList4);
        selectField2.setConditions(arrayList3);
        selectField2.setValue(MonthlyDay.INITIAL.name());
        selectField2.setUpdateValuesOnChange(true);
        arrayList.add(selectField2);
        ArrayList<LocalizedKey> arrayList5 = new ArrayList<LocalizedKey>();
        arrayList5.add(new LocalizedKey("1", TaskPlannerServerPlugin.MSG.getMsg("trigger.time.customtype.daily", new Object[0])));
        arrayList5.add(new LocalizedKey("2", TaskPlannerServerPlugin.MSG.getMsg("trigger.time.customtype.weekly", new Object[0])));
        arrayList5.add(new LocalizedKey("3", TaskPlannerServerPlugin.MSG.getMsg("trigger.time.customtype.monthly", new Object[0])));
        SelectField selectField3 = new SelectField("custom.intervaltype", TaskPlannerServerPlugin.MSG.getMsg("trigger.time.custom.intervaltype", new Object[0]), arrayList5);
        FieldCondition fieldCondition = FieldCondition.visible(selectField, FieldCondition.OP.equals, RepeatInterval.CUSTOM.name());
        selectField3.setConditions(Collections.singletonList(fieldCondition));
        selectField3.setValue("1");
        selectField3.setUpdateValuesOnChange(true);
        arrayList.add(selectField3);
        FieldCondition fieldCondition2 = FieldCondition.visible(selectField3, FieldCondition.OP.equals, "3");
        FieldCondition fieldCondition3 = FieldCondition.visible(selectField3, FieldCondition.OP.equals, "2");
        NumberField numberField = new NumberField("custom.interval", TaskPlannerServerPlugin.MSG.getMsg("trigger.time.custom.interval", new Object[0]));
        numberField.setValue(String.valueOf(1));
        numberField.setUpdateValuesOnChange(true);
        numberField.setConditions(Collections.singletonList(fieldCondition));
        arrayList.add(numberField);
        ArrayList<LocalizedKey> arrayList6 = new ArrayList<LocalizedKey>();
        arrayList6.add(new LocalizedKey(DayOfWeek.MONDAY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.MONDAY.name(), new Object[0])));
        arrayList6.add(new LocalizedKey(DayOfWeek.TUESDAY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.TUESDAY.name(), new Object[0])));
        arrayList6.add(new LocalizedKey(DayOfWeek.WEDNESDAY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.WEDNESDAY.name(), new Object[0])));
        arrayList6.add(new LocalizedKey(DayOfWeek.THURSDAY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.THURSDAY.name(), new Object[0])));
        arrayList6.add(new LocalizedKey(DayOfWeek.FRIDAY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.FRIDAY.name(), new Object[0])));
        arrayList6.add(new LocalizedKey(DayOfWeek.SATURDAY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.SATURDAY.name(), new Object[0])));
        arrayList6.add(new LocalizedKey(DayOfWeek.SUNDAY.name(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.SUNDAY.name(), new Object[0])));
        SelectField selectField4 = new SelectField("custom.weekly.dayofweek", TaskPlannerServerPlugin.MSG.getMsg("trigger.time.custom.dayofweek", new Object[0]), arrayList6);
        selectField4.setValue(DayOfWeek.MONDAY.name());
        selectField4.setUpdateValuesOnChange(true);
        selectField4.setConditions(Collections.singletonList(fieldCondition3));
        arrayList.add(selectField4);
        SelectField selectField5 = new SelectField("custom.monthly.cardinality", TaskPlannerServerPlugin.MSG.getMsg(PROP_WHICH_SELECT, new Object[0]), arrayList4);
        selectField5.setValue(MonthlyDay.FIRST.name());
        selectField5.setUpdateValuesOnChange(true);
        selectField5.setConditions(Collections.singletonList(fieldCondition2));
        arrayList.add(selectField5);
        ArrayList<LocalizedKey> arrayList7 = new ArrayList<LocalizedKey>();
        arrayList7.add(new LocalizedKey("8", TaskPlannerServerPlugin.MSG.getMsg("trigger.time.custom.monthlyday.day", new Object[0])));
        arrayList7.add(new LocalizedKey("9", TaskPlannerServerPlugin.MSG.getMsg("trigger.time.custom.monthlyday.weekDay", new Object[0])));
        arrayList7.add(new LocalizedKey("" + DayOfWeek.MONDAY.getValue(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.MONDAY.name(), new Object[0])));
        arrayList7.add(new LocalizedKey("" + DayOfWeek.TUESDAY.getValue(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.TUESDAY.name(), new Object[0])));
        arrayList7.add(new LocalizedKey("" + DayOfWeek.WEDNESDAY.getValue(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.WEDNESDAY.name(), new Object[0])));
        arrayList7.add(new LocalizedKey("" + DayOfWeek.THURSDAY.getValue(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.THURSDAY.name(), new Object[0])));
        arrayList7.add(new LocalizedKey("" + DayOfWeek.FRIDAY.getValue(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.FRIDAY.name(), new Object[0])));
        arrayList7.add(new LocalizedKey("" + DayOfWeek.SATURDAY.getValue(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.SATURDAY.name(), new Object[0])));
        arrayList7.add(new LocalizedKey("" + DayOfWeek.SUNDAY.getValue(), TaskPlannerServerPlugin.MSG.getMsg("trigger.time.weekday." + DayOfWeek.SUNDAY.name(), new Object[0])));
        SelectField selectField6 = new SelectField("custom.monthly.day", "", arrayList7);
        selectField6.setValue("8");
        selectField6.setUpdateValuesOnChange(true);
        selectField6.setConditions(Collections.singletonList(fieldCondition2));
        arrayList.add(selectField6);
        TriggerDefinition triggerDefinition = new TriggerDefinition(this.getExtensionName());
        triggerDefinition.setProperty(dateField.getKey(), dateField.getValue());
        triggerDefinition.setProperty(timeField.getKey(), timeField.getValue());
        triggerDefinition.setProperty(selectField.getKey(), selectField.getValue());
        triggerDefinition.setProperty(selectField2.getKey(), selectField2.getValue());
        b.c(triggerDefinition.getProperties());
        arrayList.add(new LabelField("label.summary", TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.label", new Object[0]), this.e(triggerDefinition)));
        arrayList.add(new LabelField("label.nextexecutions", TaskPlannerServerPlugin.MSG.getMsg("trigger.cron.summary.nextExecutionsLabel", new Object[0]), CronTriggerFactory.getNextExecutionsSummaryText(this.getNextExecutionTimes(triggerDefinition))));
        return arrayList;
    }

    public static void addTimeZoneDifferenceHintIfRequired(ArrayList<Field> fields) {
        if (!Objects.equals(ClientTimezone.getTimeZone(), TimeZone.getDefault())) {
            String string = TimeZone.getDefault().toZoneId().getDisplayName(TextStyle.SHORT, ClientLocale.getThreadLocale());
            String string2 = ClientTimezone.getTimeZone().toZoneId().getDisplayName(TextStyle.SHORT, ClientLocale.getThreadLocale());
            String string3 = TaskPlannerServerPlugin.MSG.getMsg("trigger.time.label.timezone", new Object[]{string, string2});
            fields.add(new LabelField("unusedZoneLabel", "", string3));
        }
    }

    @Override
    public Map<String, String> updateValues(TriggerDefinition definition, GUID taskID) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.e(definition);
        hashMap.put("label.summary", string);
        String string2 = CronTriggerFactory.getNextExecutionsSummaryText(this.getNextExecutionTimes(definition));
        hashMap.put("label.nextexecutions", string2);
        return hashMap;
    }

    private String e(TriggerDefinition triggerDefinition) {
        String string = TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.unknown", new Object[0]);
        try {
            string = a.d(triggerDefinition);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void validate(TriggerDefinition triggerDefinition, GUID taskID) throws ValidationException {
        String string;
        String string2;
        String string3 = triggerDefinition.getProperty(PROP_START_DAY);
        String string4 = triggerDefinition.getProperty(PROP_START_TIME);
        String string5 = triggerDefinition.getProperty(PROP_REPEAT_SELECT);
        String string6 = triggerDefinition.getProperty(PROP_WHICH_SELECT);
        String string7 = triggerDefinition.getProperty("custom.interval");
        String string8 = triggerDefinition.getProperty("custom.intervaltype");
        String string9 = triggerDefinition.getProperty("custom.weekly.dayofweek");
        String string10 = triggerDefinition.getProperty("custom.monthly.cardinality");
        String string11 = triggerDefinition.getProperty("custom.monthly.day");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string3 == null || string3.trim().isEmpty()) {
            arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.noStartDay", new Object[0]));
        } else {
            try {
                Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.invalidStartDay", new Object[]{string3}));
            }
        }
        if (string4 == null || string4.trim().isEmpty()) {
            arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.noStartTime", new Object[0]));
        } else {
            try {
                Long.parseLong(string4);
            }
            catch (NumberFormatException numberFormatException) {
                arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.invalidStartTime", new Object[]{string4}));
            }
        }
        if (string5 == null || string5.trim().isEmpty()) {
            arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.noRepetition", new Object[0]));
        } else if (!this.a(RepeatInterval.class, string5)) {
            arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.invalidRepetition", new Object[]{string5}));
        } else if (string5.equals(RepeatInterval.MONTHLY.name())) {
            if (string6 == null || string6.trim().isEmpty()) {
                arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.noWhichDay", new Object[0]));
            } else if (!this.a(MonthlyDay.class, string6)) {
                arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.invalidWhichDay", new Object[]{string6}));
            }
        } else if (string5.equals(RepeatInterval.CUSTOM.name())) {
            int n2;
            try {
                n2 = Integer.parseInt(string8);
                if (n2 != 1 && n2 != 3 && n2 != 2) {
                    n2 = -1;
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
                arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.custom.invalidType", new Object[]{string8}));
            }
            if (n2 != -1) {
                if (n2 == 2) {
                    try {
                        DayOfWeek.valueOf(string9);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.custom.invalidDayOfWeek", new Object[]{string9}));
                    }
                }
                int n3 = 1;
                try {
                    n3 = Integer.parseInt(string7);
                    if (n3 <= 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.custom.invalidInterval", new Object[]{string7}));
                }
                if (n2 == 3) {
                    int n4 = 1;
                    try {
                        MonthlyDay monthlyDay = MonthlyDay.valueOf(string10);
                        n4 = TimeTriggerForCustomSettings.getCardinalityFromSetting(a.c(triggerDefinition), monthlyDay);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.custom.invalidMonthlyCardinality", new Object[]{string10}));
                    }
                    int n5 = 0;
                    try {
                        n5 = Integer.parseInt(string11);
                        if (n5 <= 0 || n5 > 9) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.custom.invalidMonthlyDay", new Object[]{string11}));
                    }
                    if (n5 == 9) {
                        if (n4 > 23) {
                            arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.custom.invalidMonthlyDayCardinalityCombination", new Object[0]));
                        }
                    } else if (n5 != 8 && n4 > 5) {
                        arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.custom.invalidMonthlyDayCardinalityCombination", new Object[0]));
                    }
                }
            }
        }
        if (arrayList.isEmpty() && string5 != null && !string5.equals(RepeatInterval.CUSTOM.name()) && (string2 = CronTriggerFactory.validateCronExpression(string = a.b(triggerDefinition))) != null) {
            arrayList.add(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.error.implementationBug", new Object[]{string, ((ApplicationDescription)ServerPluginManager.getInstance().getSingleInstance(ApplicationDescription.class)).getDefaultSupportAddress(), string2}));
        }
        if (!arrayList.isEmpty()) {
            throw new ValidationException(arrayList);
        }
    }

    @Override
    public SummaryInfo getSummary(TriggerDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        try {
            arrayList.add(new SummaryEntry(TaskPlannerServerPlugin.MSG.getMsg("trigger.time.msg.label", new Object[0]), a.d(definition)));
            arrayList.addAll(CronTriggerFactory.getNextExecutionsAsSummary(this.getNextExecutionTimes(definition)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)illegalArgumentException);
        }
        return new SummaryInfo(arrayList);
    }

    @Override
    public List<ZonedDateTime> getNextExecutionTimes(TriggerDefinition definition) {
        try {
            RepeatInterval repeatInterval = RepeatInterval.valueOf(definition.getProperty(PROP_REPEAT_SELECT));
            if (repeatInterval == RepeatInterval.CUSTOM) {
                return TimeTriggerForCustomSettings.getNextExecutionDates(definition);
            }
            String string = a.b(definition);
            Predicate<ZonedDateTime> predicate = this.f(definition);
            return CronTriggerFactory.getNextExecutionsForCronExpression(string, a.a(definition), predicate);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            TaskPlannerServerPlugin.LOGGER.debug((Object)illegalArgumentException);
            return super.getNextExecutionTimes(definition);
        }
    }

    private Predicate<ZonedDateTime> f(TriggerDefinition triggerDefinition) {
        Predicate<ZonedDateTime> predicate = null;
        String string = triggerDefinition.getProperty(PROP_REPEAT_SELECT);
        if (string != null && RepeatInterval.valueOf(string) == RepeatInterval.TWOWEEKS) {
            ZonedDateTime zonedDateTime = a.c(triggerDefinition);
            predicate = zonedDateTime2 -> a.a(zonedDateTime2, zonedDateTime);
        }
        return predicate;
    }

    private <E extends Enum<E>> boolean a(Class<E> clazz, String string) {
        try {
            Enum.valueOf(clazz, string);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

