/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.template;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.classloader.I18nMessages;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.template.TaskTemplateDefinition;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;

@JsonData
@InternalApi
public class TaskTemplateDefinitionImpl
implements TaskTemplateDefinition {
    private String key = "key";
    private I18nMessages MSG;
    private String label;
    private String description;
    private TaskDefinition taskDefinition;
    private List<String> keysNeedingLocalization;

    public TaskTemplateDefinitionImpl(String key, I18nMessages MSG, String title, String description, TaskDefinition taskDefinition, List<String> keysNeedingLocalization) {
        this.key = key;
        this.MSG = MSG;
        this.label = title;
        this.description = description;
        this.taskDefinition = taskDefinition;
        this.keysNeedingLocalization = keysNeedingLocalization;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName(Locale locale) {
        return this.MSG.getMsg(locale, this.label, new Object[0]);
    }

    @Override
    public String getDescription(Locale locale) {
        return this.MSG.getMsg(locale, this.description, new Object[0]);
    }

    @Override
    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    @Override
    public String getLabel(String key, Locale locale) {
        return this.MSG.getMsg(locale, key, new Object[0]);
    }

    @Override
    public boolean needsLocalization(@Nonnull String key) {
        return this.keysNeedingLocalization.contains(key);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

