/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.action.print;

import com.inet.annotations.InternalApi;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.action.print.PrinterDescription;
import com.inet.taskplanner.server.api.action.print.PrinterProvider;
import com.inet.taskplanner.server.api.action.print.PrinterProviderDefaultImpl;
import com.inet.taskplanner.server.api.action.print.a;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.TaskPlannerCodes;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.FileField;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.SuppressFBWarnings;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

@InternalApi
public class PrintResultActionFactory
extends ResultActionFactory<a> {
    public static final String EXTENSION_NAME = "result.print";
    public static final String PRINTER = "printer";
    public static final String FILE = "file";
    private static PrinterProvider ae = null;

    public PrintResultActionFactory() {
        super(EXTENSION_NAME);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ResultActionInfo getInformation(GUID taskID) {
        Object object;
        String string = TaskPlannerServerPlugin.MSG.getMsg("result.print.name", new Object[0]);
        String string2 = TaskPlannerServerPlugin.MSG.getMsg("result.print.description", new Object[0]);
        URL uRL = this.getClass().getResource("print.png");
        String string3 = "taskplanner.action.print";
        ArrayList<Field> arrayList = new ArrayList<Field>();
        FileField fileField = new FileField(FILE, TaskPlannerServerPlugin.MSG.getMsg("result.print.file", new Object[0]));
        ArrayList<FieldCondition> arrayList2 = new ArrayList<FieldCondition>();
        fileField.setConditions(arrayList2);
        ArrayList<LocalizedKey> arrayList3 = new ArrayList<LocalizedKey>();
        SelectField selectField = new SelectField(PRINTER, TaskPlannerServerPlugin.MSG.getMsg("result.print.printer", new Object[0]), arrayList3);
        boolean bl = PrintResultActionFactory.k();
        if (ae != null) {
            for (PrinterDescription object2 : ae.availablePrinters()) {
                PrintService printService = object2.getService();
                String string4 = printService.getName();
                if (object2.l() && !bl) continue;
                arrayList3.add(new LocalizedKey(string4, string4));
                if (!object2.l()) continue;
                arrayList2.add(FieldCondition.visible(selectField, FieldCondition.OP.equals, string4));
            }
        }
        if (arrayList3.size() == 0) {
            arrayList.add(new LabelField("printer.label", TaskPlannerServerPlugin.MSG.getMsg("result.print.printer", new Object[0]), TaskPlannerServerPlugin.MSG.getMsg("result.print.noprinter", new Object[0])));
        } else {
            void var13_18;
            void var13_16;
            object = PrintServiceLookup.lookupDefaultPrintService();
            Object var13_14 = null;
            if (object != null && arrayList3.stream().filter(arg_0 -> PrintResultActionFactory.a((PrintService)object, arg_0)).count() > 0L) {
                String string5 = object.getName();
            }
            if (var13_16 == null) {
                String string6 = arrayList3.get(0).getKey();
            }
            selectField.setValue((String)var13_18);
            arrayList.add(selectField);
            if (bl) {
                arrayList.add(fileField);
            }
        }
        object = new ResultActionInfo(this.getExtensionName(), string, string2, uRL, string3, arrayList);
        return object;
    }

    private static boolean k() {
        return SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION);
    }

    static PrinterDescription b(String string) {
        return ae == null ? null : ae.getPrinterForName(string);
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Files are not read, just referenced for validation")
    protected void validate(ResultActionDefinition definition, GUID taskID) throws ValidationException {
        String string = definition.getProperty(PRINTER);
        if (string == null) {
            throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("result.print.noprinter", new Object[0])});
        }
        PrinterDescription printerDescription = PrintResultActionFactory.b(string);
        if (printerDescription == null) {
            throw new ValidationException(new String[]{TaskPlannerCodes.PrinterNotExists.getMsg(new Object[]{string})});
        }
        String string2 = definition.getProperty(FILE);
        if (printerDescription.l()) {
            if (string2 == null || string2.trim().isEmpty()) {
                throw new ValidationException(new String[]{TaskPlannerServerPlugin.MSG.getMsg("result.print.nofile", new Object[0])});
            }
            String string3 = ConfigValidator.checkWritableFilePossible((String)string2, (Locale)ClientLocale.getThreadLocale());
            if (string3 != null) {
                throw new ValidationException(new String[]{StringFunctions.encodeHTML((String)string3, (boolean)false)});
            }
            new File(string2).toURI();
        }
    }

    protected a b(ResultActionDefinition resultActionDefinition, GUID gUID) {
        return new a(resultActionDefinition);
    }

    @Override
    public SummaryInfo getSummary(ResultActionDefinition definition) {
        ArrayList<SummaryEntry> arrayList = new ArrayList<SummaryEntry>();
        Object object = definition.getProperty(PRINTER);
        PrinterDescription printerDescription = PrintResultActionFactory.b((String)object);
        if (printerDescription != null && printerDescription.l()) {
            object = (String)object + ": " + definition.getProperty(FILE);
        }
        arrayList.add(new SummaryEntry(null, (String)object));
        return new SummaryInfo(arrayList);
    }

    @Override
    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.PRINT);
    }

    public void init(ServerPluginManager spm) {
        ae = (PrinterProvider)spm.getOptionalInstance(PrinterProvider.class);
        if (ae == null) {
            ae = new PrinterProviderDefaultImpl();
        }
    }

    @Override
    protected /* synthetic */ Object createInstanceFrom(AbstractDefinition abstractDefinition, GUID gUID) {
        return this.b((ResultActionDefinition)abstractDefinition, gUID);
    }

    private static /* synthetic */ boolean a(PrintService printService, LocalizedKey localizedKey) {
        return localizedKey.getDisplayName().equals(printService.getName());
    }
}

