/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.action;

import com.inet.annotations.PublicApi;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import javax.annotation.Nonnull;

@PublicApi
public class EmailResultActionBuilder {
    private String n = "";
    private String o = "";
    private String p = "";
    private String q = "[filename]";
    private boolean r = true;

    public EmailResultActionBuilder(String subject, String message, String ... receiver) {
        this.withSubject(subject).withMessage(message).withReceiver(receiver);
    }

    public EmailResultActionBuilder withSubject(@Nonnull String subject) {
        if (subject == null) {
            throw new IllegalArgumentException("subject cannot be null");
        }
        this.n = subject;
        return this;
    }

    public EmailResultActionBuilder withMessage(@Nonnull String message) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        this.o = message;
        return this;
    }

    public EmailResultActionBuilder withReceiver(String ... receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException("receiver cannot be null");
        }
        for (String string : receiver) {
            try {
                new InternetAddress(string, true);
            }
            catch (AddressException addressException) {
                throw new IllegalArgumentException(TaskPlannerServerPlugin.MSG.getMsg("result.email.error.notValidAddress", new Object[]{string, addressException.getMessage()}));
            }
        }
        this.p = String.join((CharSequence)";", receiver);
        return this;
    }

    public EmailResultActionBuilder withAttachendFiles(boolean attachFiles) {
        this.r = attachFiles;
        return this;
    }

    public EmailResultActionBuilder withFilenameFormat(@Nonnull String filenameFormat) {
        if (filenameFormat == null || filenameFormat.isEmpty()) {
            throw new IllegalArgumentException("filenameFormat cannot be null or empty");
        }
        this.q = filenameFormat;
        return this;
    }

    public ResultActionDefinition create() {
        ResultActionDefinition resultActionDefinition = new ResultActionDefinition("result.email");
        resultActionDefinition.setProperty("prop_attach_files", String.valueOf(this.r));
        resultActionDefinition.setProperty("prop_message", this.o);
        resultActionDefinition.setProperty("prop_subject", this.n);
        resultActionDefinition.setProperty("prop_receiver", this.p);
        resultActionDefinition.setProperty("filenameformat", this.q);
        return resultActionDefinition;
    }
}

