/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.job;

import com.inet.annotations.PublicApi;
import com.inet.taskplanner.TaskPlannerServerPlugin;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.result.Result;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@PublicApi
public class ResultContainer
extends JobResultContainer {
    private final List<Result> results;
    private Map<String, String> aw;

    public ResultContainer(@Nonnull List<Result> results) {
        this(results, new HashMap<String, String>());
    }

    public ResultContainer(@Nonnull List<Result> results, @Nonnull Map<String, String> metaProperties) {
        this.aw = metaProperties;
        this.results = results;
    }

    @Override
    public List<ResultFlavor> getFlavors() {
        HashSet hashSet = new HashSet();
        this.results.forEach(result -> hashSet.addAll(result.getFlavors()));
        return new ArrayList<ResultFlavor>(hashSet);
    }

    @Override
    public List<Result> getResults(ResultFlavor flavor) {
        return this.results.stream().filter(result -> result.getFlavors().contains(flavor)).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> getMetaProperties() {
        return this.aw;
    }

    @Override
    public void cleanup() {
        this.results.forEach(result -> {
            try {
                result.cleanup();
            }
            catch (Exception exception) {
                TaskPlannerServerPlugin.LOGGER.error((Throwable)exception);
            }
        });
    }
}

