/*
 * Decompiled with CFR 0.152.
 */
package com.inet.taskplanner.server.api.common;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.taskplanner.server.api.field.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
@PublicApi
public abstract class AbstractInfo {
    private String extensionName;
    private String displayName;
    private String description;
    private URL iconURL;
    private String helpKey;
    private List<Field> fields;

    public AbstractInfo(@Nonnull String extensionName, @Nonnull String displayName, @Nonnull String description, URL iconURL, String helpKey) {
        this(extensionName, displayName, description, iconURL, helpKey, Collections.emptyList());
    }

    public AbstractInfo(@Nonnull String extensionName, @Nonnull String displayName, @Nonnull String description, URL iconURL, String helpKey, List<Field> fields) {
        if (extensionName == null) {
            throw new IllegalArgumentException("extension name must not be null");
        }
        if (displayName == null) {
            throw new IllegalArgumentException("display name must not be null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description must not be null");
        }
        if (fields == null) {
            fields = Collections.emptyList();
        }
        this.extensionName = extensionName;
        this.displayName = displayName;
        this.description = description;
        this.iconURL = iconURL;
        this.helpKey = helpKey;
        this.fields = new ArrayList<Field>(fields);
    }

    @Nonnull
    public String getExtensionName() {
        return this.extensionName;
    }

    @Nonnull
    public String getDisplayName() {
        return this.displayName;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public URL getIconURL() {
        return this.iconURL;
    }

    @Nullable
    public String getHelpKey() {
        return this.helpKey;
    }

    public List<Field> getFields() {
        return this.fields;
    }
}

