/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.taskplanner;

import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.error.ErrorCode;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.EngineBundle;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.PromptField;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.ReportGenerator;
import com.inet.report.Trigger;
import com.inet.report.cache.Cache;
import com.inet.report.cache.EngineFactory;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.event.EngineFinishEvent;
import com.inet.report.event.EngineFinishListener;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.prompt.DefaultValuesQuery;
import com.inet.report.prompt.Prompt;
import com.inet.report.prompt.PromptManager;
import com.inet.report.renderer.api.RendererFactoryManager;
import com.inet.report.renderer.api.ToClientCmd;
import com.inet.report.taskplanner.PromptDescription;
import com.inet.report.taskplanner.ReportJobFactory;
import com.inet.report.taskplanner.ReportTaskPlannerServerPlugin;
import com.inet.report.taskplanner.a;
import com.inet.report.taskplanner.b;
import com.inet.report.taskplanner.d;
import com.inet.report.taskplanner.e;
import com.inet.report.taskplanner.g;
import com.inet.report.util.EngineUtils;
import com.inet.report.util.RenderDataUtils;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.PasswordField;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.job.ResultContainer;
import com.inet.taskplanner.server.api.result.ByteArrayFileResult;
import com.inet.taskplanner.server.api.result.LazyInputStreamFileResult;
import com.inet.taskplanner.server.api.result.Result;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

public class c
extends Job {
    private final Properties d;
    private final String e;
    private Trigger f;
    private String g;
    private String c;
    private List<Engine> h = new ArrayList<Engine>();
    private ReportGenerator i;
    private String j;
    public static final I18nMessages k = new I18nMessages("com.inet.report.taskplanner.structure.i18n.ConfigStructure", ReportJobFactory.class);
    private static final ConfigValue<Double> l = new ConfigValue(ConfigKey.ENGINE_CACHE_TIMEOUT);

    public c(JobDefinition jobDefinition, boolean bl) {
        super(jobDefinition.getCondition());
        PromptDescription[] promptDescriptionArray;
        this.d = new Properties();
        Map map = jobDefinition.getProperties();
        this.a(map);
        String string = (String)map.get("prompts");
        if (string != null) {
            promptDescriptionArray = (PromptDescription[])new Json().fromJson(string, PromptDescription[].class, new HashMap());
            for (PromptDescription promptDescription : promptDescriptionArray) {
                String string2 = promptDescription.getValue();
                if (string2 == null) {
                    string2 = "formula:null";
                } else if (string2.matches("(?s).*[{].*[}].*")) {
                    if (bl) {
                        string2 = "formula:null";
                    } else {
                        throw new IllegalStateException(k.getMsg("no.placeholder.value", new Object[]{string2}));
                    }
                }
                this.d.put("prompt" + promptDescription.getKey(), string2);
            }
        }
        promptDescriptionArray = jobDefinition.getCondition() != null ? jobDefinition.getCondition().getProperties() : null;
        this.e = ReportJobFactory.d((Map<String, String>)promptDescriptionArray);
        String string3 = (String)map.get("reports");
        if (string3 != null) {
            if (string3.split(";").length == 1) {
                this.d.setProperty("report", string3);
            } else {
                this.d.setProperty("reports", string3);
            }
        }
        this.d.put("taskplanner", Long.toString(System.currentTimeMillis()));
        this.d.put("cmd", "rfsh");
        String string4 = (String)map.get("datasource");
        if (!StringFunctions.isEmpty((String)string4)) {
            List<String> list = a.a.getDataSourceNames();
            if (list.contains(string4)) {
                this.j = string4;
            } else {
                ErrorCode.throwAny((Throwable)new ValidationException(new String[]{k.getMsg("dataSourceDoesNotExists", new Object[]{string4})}));
            }
        }
    }

    private void a(@Nonnull Map<String, String> map) {
        this.g = map.get("formula");
        String string = com.inet.report.taskplanner.c.a(map, "export_fmt", "pdf");
        this.d.put("export_fmt", string);
        block16 : switch (string) {
            case "pdf": {
                String string2;
                this.a(map, "navview", "pdftags");
                switch (string2 = com.inet.report.taskplanner.c.a(map, "pdf_extended", "none")) {
                    case "pdfa": 
                    case "fastwebview": {
                        this.d.put(string2, "true");
                        break block16;
                    }
                    case "encrypted": {
                        this.b(map, "upass", "opass");
                        break block16;
                    }
                }
                break;
            }
            case "htm": 
            case "htm.zip": {
                this.a(map, "layout");
                break;
            }
            case "txt": {
                this.b(map);
                this.a(map, "encoding");
                switch (com.inet.report.taskplanner.c.a(map, "pagebreak_type", "line")) {
                    case "line": {
                        break;
                    }
                    case "form_feed": {
                        this.d.setProperty("pagebreak", "\f");
                        break;
                    }
                    case "other": {
                        this.a(map, "pagebreak");
                    }
                }
                break;
            }
            case "rtf": 
            case "docx": {
                this.a(map, "editable");
                break;
            }
            case "xls": 
            case "xlsx": 
            case "ods": {
                this.a(map, "celltruncate", "celldistribution", "firstgroupassheets", "grouplevel");
                break;
            }
            case "csv": {
                String string3;
                switch (com.inet.report.taskplanner.c.a(map, "csv_type", "dataAndLabels")) {
                    case "dataOnly": {
                        this.d.put("export_fmt", "data");
                        this.d.put("columnnames", "false");
                        break;
                    }
                    case "dataOnlyColumnnames": {
                        this.d.put("export_fmt", "data");
                        this.d.put("columnnames", "true");
                    }
                }
                this.a(map, "quotechar", "encoding");
                this.b(map);
                switch (string3 = com.inet.report.taskplanner.c.a(map, "delimiter_type", "other")) {
                    case "other": {
                        this.a(map, "delimiter");
                        break block16;
                    }
                    case "fix": {
                        this.a(map, "colswidth");
                        break block16;
                    }
                }
                this.d.setProperty("delimiter", string3);
                break;
            }
            case "jpg": 
            case "png": 
            case "bmp": 
            case "gif": {
                this.a(map, "background", com.inet.report.taskplanner.c.a(map, "zoom_type", ""));
                break;
            }
        }
    }

    private void a(Map<String, String> map, String ... stringArray) {
        for (String string : stringArray) {
            String string2 = map.get(string);
            if (string2 == null) continue;
            this.d.setProperty(string, string2);
        }
    }

    private void b(Map<String, String> map, String ... stringArray) {
        for (String string : stringArray) {
            String string2 = map.get(string);
            if (StringFunctions.isEmpty((String)string2)) continue;
            try {
                string2 = PasswordField.decodePassword((String)string2);
                if (StringFunctions.isEmpty((String)string2)) continue;
                this.d.setProperty(string, string2);
            }
            catch (IOException iOException) {
                ReportTaskPlannerServerPlugin.LOGGER.error((Throwable)iOException);
            }
        }
    }

    @Nonnull
    private static String a(@Nonnull Map<String, String> map, String string, @Nonnull String string2) {
        String string3 = map.get(string);
        return string3 == null ? string2 : string3;
    }

    private void b(@Nonnull Map<String, String> map) {
        switch (com.inet.report.taskplanner.c.a(map, "newline", "")) {
            case "windows": {
                this.d.setProperty("newline", "\r\n");
                break;
            }
            case "macos": {
                this.d.setProperty("newline", "\r");
                break;
            }
            case "unix": {
                this.d.setProperty("newline", "\n");
                break;
            }
        }
    }

    private ReportCacheKey c(final @Nonnull Map<String, String> map) throws ReportException {
        Cache cache = Cache.getCache();
        PropertiesChecker propertiesChecker = new PropertiesChecker(){
            private PropertiesChecker m = Cache.getPropertiesChecker();

            public void checkProperties(final Engine engine, Properties props, Object req) throws ReportException {
                Fields fields;
                String string;
                if (this.m != null) {
                    this.m.checkProperties(engine, props, req);
                }
                if (c.this.c == null || c.this.c.trim().isEmpty()) {
                    c.this.c = engine.getSummaryInfo().getReportTitle();
                }
                String string2 = string = !StringFunctions.isEmpty((String)c.this.e) ? c.this.e : c.this.g;
                if (!StringFunctions.isEmpty((String)string)) {
                    fields = engine.getFields();
                    FormulaField formulaField = fields.addFormulaField("trigger", string, 3);
                    c.this.f = engine.getTrigger();
                    c.this.f.setFormula(formulaField);
                }
                engine.addFinishListener(new EngineFinishListener(){

                    public void engineFinish(EngineFinishEvent event) {
                        try {
                            Object object;
                            map.put("report.pages", Integer.toString(engine.getDocumentPageCount()));
                            if (c.this.f != null && (object = c.this.f.getResult()) != null) {
                                map.put("report.formula", object.toString());
                            }
                        }
                        catch (ReportException reportException) {
                            ReportTaskPlannerServerPlugin.LOGGER.debug((Object)reportException);
                        }
                    }

                    public void updateProgress(int totalPercentageProgress) {
                        c.this.setProgress(totalPercentageProgress);
                    }
                });
                if (c.this.j != null) {
                    com.inet.report.taskplanner.c.a(engine, c.this.j);
                }
                c.this.h.add(engine);
                fields = engine.getFields();
                for (int i = 0; i < fields.getPromptFieldsCount(); ++i) {
                    PromptField promptField = fields.getPromptField(i);
                    String string3 = promptField.isPasswordField() ? "****" : PromptManager.getInstance().getDisplayValue(promptField.getPromptValue(), engine, promptField);
                    map.put("prompt." + promptField.getName(), string3);
                }
            }

            public void checkProperties(Properties props, Object req) throws ReportException {
                if (this.m != null) {
                    this.m.checkProperties(props, req);
                }
            }
        };
        return cache.getKey(this.d, propertiesChecker, null);
    }

    private static void a(@Nonnull Engine engine, @Nonnull String string) throws ReportException {
        int n;
        DatabaseTables databaseTables = engine.getDatabaseTables();
        int n2 = databaseTables.getDatasourceCount();
        for (n = 0; n < n2; ++n) {
            Datasource datasource = databaseTables.getDatasource(n);
            datasource.setDataSourceConfigurationName(string);
        }
        n = engine.getSubReportCount();
        for (int i = 0; i < n; ++i) {
            com.inet.report.taskplanner.c.a(engine.getSubReport(i), string);
        }
    }

    protected JobResultContainer run() throws TaskExecutionException {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            ReportCacheKey reportCacheKey = this.c(hashMap);
            this.c();
            hashMap.put("report.title", this.c);
            hashMap.put("report.path", this.d.getProperty("report", this.d.getProperty("reports")));
            return new ResultContainer(this.a(reportCacheKey), hashMap);
        }
        catch (Throwable throwable) {
            throw new TaskExecutionException(throwable);
        }
    }

    private List<Result> a(ReportCacheKey reportCacheKey) throws Throwable {
        ArrayList<Result> arrayList = new ArrayList<Result>();
        Cache cache = Cache.getCache();
        int n = com.inet.report.taskplanner.c.a(cache, reportCacheKey);
        for (Engine object : this.h) {
            object.getPageCount();
        }
        Throwable throwable = cache.getFailureCause(reportCacheKey);
        if (throwable != null) {
            throw throwable;
        }
        switch (reportCacheKey.getFormat()) {
            case "java": {
                arrayList.add(new e(reportCacheKey));
                break;
            }
            case "txt": {
                arrayList.add(new b(reportCacheKey, this.c){

                    @Override
                    @Nonnull
                    public List<ResultFlavor> getFlavors() {
                        return Arrays.asList(ResultFlavor.TEXT, ResultFlavor.FILE);
                    }

                    @Override
                    public String getTextContentType() throws Exception {
                        return "text/plain";
                    }
                });
                break;
            }
            case "email": {
                arrayList.add(new b(reportCacheKey, this.c){

                    @Override
                    @Nonnull
                    public List<ResultFlavor> getFlavors() {
                        return Arrays.asList(ResultFlavor.TEXT, ResultFlavor.FILE);
                    }

                    @Override
                    public String getTextContentType() throws Exception {
                        return "text/html; charset=utf-8";
                    }
                });
                break;
            }
            case "htm.zip": {
                ToClientCmd toClientCmd = RendererFactoryManager.getInstance().getToClientHandlerByCommand("htm.zip");
                Objects.requireNonNull(toClientCmd);
                LazyInputStreamFileResult.InputStreamSupplier inputStreamSupplier = () -> toClientCmd.contentStream(cache, () -> reportCacheKey, this.d, null, null);
                arrayList.add((Result)new LazyInputStreamFileResult(this.b(reportCacheKey) + "." + reportCacheKey.getFormat(), inputStreamSupplier));
                break;
            }
            case "htm": {
                byte[] byArray;
                int i;
                boolean bl = this.b();
                if (bl) {
                    i = 1;
                    n = 1;
                } else {
                    i = 0;
                    byArray = RenderDataUtils.getHtmlViewerData();
                    arrayList.add((Result)new ByteArrayFileResult(this.c + ".html", byArray));
                }
                while (i <= n) {
                    int n2;
                    byArray = cache.getPageAndWait(reportCacheKey, i);
                    for (int j = 0; byArray.length > j; j += n2) {
                        n2 = com.inet.report.taskplanner.c.a(byArray, j);
                        j += 4;
                        if (n2 == -1) break;
                        String string = new String(byArray, j, n2, StandardCharsets.UTF_8);
                        j += n2;
                        n2 = com.inet.report.taskplanner.c.a(byArray, j);
                        Object object = bl ? (string.endsWith(".html") ? new g(this.c + "/page.html", new String(byArray, j, n2, StandardCharsets.UTF_8), "text/html; charset=utf-8") : new d(reportCacheKey, this.c + "/" + string, i, j, n2)) : new d(reportCacheKey, this.c + "/" + string, i, j += 4, n2);
                        arrayList.add((Result)object);
                    }
                    ++i;
                }
                break;
            }
            case "jpg": 
            case "png": 
            case "bmp": 
            case "gif": 
            case "svg": {
                for (int i = 1; i <= n; ++i) {
                    arrayList.add(new d(reportCacheKey, this.c + "/page" + i + "." + reportCacheKey.getFormat(), i, 0, -1));
                }
                break;
            }
            default: {
                arrayList.add(new b(reportCacheKey, this.c));
            }
        }
        this.setProgress(100);
        return arrayList;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Report name is provided by user and checked before rendering. Also we're just reading the file name")
    private String b(ReportCacheKey reportCacheKey) {
        File file = new File(reportCacheKey.getReport());
        String string = file.getName();
        string = string.substring(0, string.lastIndexOf("."));
        return string;
    }

    private static int a(Cache cache, ReportCacheKey reportCacheKey) throws ReportException {
        int n = (int)((Double)l.get() * 60000.0) / 2;
        while (true) {
            try {
                cache.resetCacheTimeout(reportCacheKey);
                return cache.getPageCountAndWait(reportCacheKey, n);
            }
            catch (ReportException reportException) {
                if (reportException.getErrorCode() == ReportErrorCode.Timeout.getErrorCodeNumber()) continue;
                throw reportException;
            }
            break;
        }
    }

    private boolean b() {
        String string = this.d.getProperty("layout");
        return "single".equals(string) || "concat".equals(string);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="only file name operations")
    private void c() {
        if (StringFunctions.isEmpty((String)this.c)) {
            String string = this.d.getProperty("report", this.d.getProperty("reports", ""));
            URL uRL = IOFunctions.getURLFromString((String)string);
            String string2 = EncodingFunctions.decodeUrlPath((String)uRL.getPath());
            String string3 = new File(string2).getName();
            if (string3.toLowerCase().endsWith(".rpt")) {
                string3 = string3.substring(0, string3.length() - 4);
            }
            this.c = string3;
        }
    }

    protected boolean evaluateCondition(ConditionDefinition conditionDefinition) {
        if (this.e == null || this.f == null) {
            return true;
        }
        Boolean bl = this.f.getValue();
        return bl != null && bl != false;
    }

    String d() throws ReportException {
        if (this.c == null) {
            List<Engine> list;
            this.g();
            if (this.i instanceof EngineBundle) {
                list = ((EngineBundle)this.i).getEngines();
            } else {
                list = new ArrayList();
                list.add((Engine)this.i);
            }
            for (Engine engine : list) {
                if (this.c != null && !this.c.trim().isEmpty()) continue;
                this.c = engine.getSummaryInfo().getReportTitle();
            }
            this.c();
        }
        return this.c;
    }

    public Prompt[] e() throws ReportException {
        this.g();
        return EngineUtils.createSerializablePrompts((ReportGenerator)this.i);
    }

    void f() throws ValidationException {
        try {
            int n;
            Engine engine;
            this.g();
            Engine engine2 = engine = this.i instanceof EngineBundle ? ((EngineBundle)this.i).getEngine0() : (Engine)this.i;
            if (this.e != null && (n = FormulaField.checkFormula((String)this.e, (boolean)false, (Engine)engine, null, null, (int)3, (int)0)) != 8) {
                throw new ValidationException(new String[]{k.getMsg("conditionWrongType", new Object[0])});
            }
            if (!StringFunctions.isEmpty((String)this.g)) {
                if (this.e != null) {
                    throw new ValidationException(new String[]{k.getMsg("noFormulaWithCondition", new Object[0])});
                }
                FormulaField.checkFormula((String)this.g, (boolean)false, (Engine)engine, null, null, (int)3, (int)0);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            for (Map.Entry<Object, Object> object2 : this.d.entrySet()) {
                if (object2.getKey() == null) continue;
                if (object2.getKey().toString().startsWith("prompt")) {
                    if ("promptonrefresh".equalsIgnoreCase(object2.getKey().toString())) continue;
                    hashMap.put(object2.getKey().toString().substring(6), object2.getValue() == null ? null : object2.getValue().toString());
                    continue;
                }
                hashMap2.put(object2.getKey().toString(), object2.getValue() == null ? null : object2.getValue().toString());
            }
            DefaultValuesQuery defaultValuesQuery = new DefaultValuesQuery();
            defaultValuesQuery.promptValues = hashMap;
            defaultValuesQuery.reportProps = hashMap2;
            Map map = PromptManager.getInstance().validate(defaultValuesQuery);
            Iterator iterator = map.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                throw new ValidationException(new String[]{(String)entry.getKey() + ": " + (String)entry.getValue()});
            }
        }
        catch (ReportException reportException) {
            String string = (String)this.d.get("reports");
            Object object = reportException.getMessage();
            if (string != null && string.contains(";") && reportException.getErrorCode() == ReportErrorCode.RptNotFound.getErrorCodeNumber()) {
                object = (String)object + " (notice that ';' is used as separator between multiple reports, replace with %3B if your path contains ';')";
            }
            ValidationException validationException = new ValidationException(new String[]{object});
            validationException.initCause((Throwable)reportException);
            throw validationException;
        }
    }

    private void g() throws ReportException {
        if (this.i != null) {
            return;
        }
        Cache.getCache().createKey(this.d);
        this.i = EngineUtils.createReportGenerator((Properties)this.d, (PropertiesChecker)Cache.getPropertiesChecker(), (EngineFactory)Cache.getEngineFactory(), null);
    }

    private static int a(byte[] byArray, int n) throws IllegalStateException {
        if (n + 4 > byArray.length) {
            throw new IllegalStateException("Invalid HTML data: length=" + byArray.length + " at " + n);
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    public void stopRequested() {
        for (Engine engine : this.h) {
            engine.stop("Taskplanner.stopRequested");
        }
    }
}

