/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.series.processstarted;

import com.inet.field.Field;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.helpdesk.plugins.taskplanner.server.TicketIterator;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.taskplanner.server.api.series.Series;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class ProcessStartedSeries
implements Series {
    private final GUID guid;
    private final GUID processID;
    private long timeWhenIteratorFinished;
    private static ProcessFetcher fetcher = t -> TicketProcessManager.getProcessOfTicket((TicketVO)t);

    public ProcessStartedSeries(GUID guid, SeriesDefinition definition) {
        this.guid = guid;
        String guidString = definition.getProperties().getOrDefault("processFilter", "");
        this.processID = guidString.isBlank() ? null : GUID.valueOf((String)guidString);
    }

    public void cleanUp(boolean previewOnly) throws Exception {
        if (!previewOnly) {
            this.callCleanUp(this.guid, this.timeWhenIteratorFinished);
        }
    }

    protected void callCleanUp(GUID guid, long timeWhenIteratorFinished) {
        HDTaskPlannerDataListener.getRegisteredInstance().cleanUp(guid, timeWhenIteratorFinished);
    }

    public Iterator<Map<String, String>> iterator() {
        return new TicketIterator(new TicketIterator.TicketListProvider(){

            @Override
            public void registerIteratorFinished(long when) {
                ProcessStartedSeries.this.timeWhenIteratorFinished = when;
            }

            @Override
            public HDTaskPlannerDataListener.TicketEvent getNextTicketAfter(long lastMarker) {
                return ProcessStartedSeries.this.getNextTicketAfter(lastMarker);
            }
        }, this.getTicketsProviderMonitor());
    }

    private HDTaskPlannerDataListener.TicketEvent getNextTicketAfter(long lastMarker) {
        return HDTaskPlannerDataListener.getRegisteredInstance().getNextProcessStartedTicketForTaskAfter(this.guid, lastMarker, processID -> {
            if (this.processID == null) {
                return true;
            }
            return this.processID.equals(processID);
        });
    }

    public static HDTaskPlannerDataListener.TicketEvent getNextProcessStartedTicketForTaskAfter(GUID guid, long lastMarker, long lastAsked, Predicate<GUID> predicate) {
        TicketReader reader = TicketManager.getReader();
        IndexSearchEngine search = reader.getSearchEngine();
        Long date = Math.max(lastAsked, lastMarker);
        AndSearchExpression andExpr = new AndSearchExpression();
        andExpr.add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.BETWEEN, (Object)new Integer[]{0, 299}));
        andExpr.add((SearchExpression)new SearchCondition("processstartdate", SearchCondition.SearchTermOperator.GT, (Object)date));
        SearchCommand command = new SearchCommand(new SearchExpression[]{andExpr});
        Set result = search.simpleSearch(command);
        Optional<TicketVO> nextTicket = result.stream().filter(p -> (long)p.intValue() > lastMarker).map(arg_0 -> ((TicketReader)reader).getTicket(arg_0)).filter(t -> {
            TicketProcess processOfTicket = fetcher.getProcessOfTicket((TicketVO)t);
            return processOfTicket != null && predicate.test(processOfTicket.getId());
        }).min(Comparator.comparing(o -> (Integer)o.getFieldOrAttributeValue((Field)Tickets.ATTRIBUTE_TICKET_ID)));
        if (nextTicket.isPresent()) {
            TicketVO ticket = nextTicket.get();
            return new HDTaskPlannerDataListener.TicketEvent((Long)ticket.getForKey("processstartdate"), ticket.getID());
        }
        return null;
    }

    protected static void setFetcher(ProcessFetcher fetcher) {
        ProcessStartedSeries.fetcher = fetcher;
    }

    protected static ProcessFetcher getFetcher() {
        return fetcher;
    }

    protected Object getTicketsProviderMonitor() {
        return HDTaskPlannerDataListener.getRegisteredInstance();
    }

    protected static interface ProcessFetcher {
        public TicketProcess getProcessOfTicket(TicketVO var1);
    }
}

