/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.job.escalation;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerUtils;
import com.inet.helpdesk.plugins.taskplanner.server.series.ticketswithstatus.TicketsWithStatusSeries;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class SetResourceJob
extends Job {
    private final List<Integer> ticketIds;
    private final Integer resId;
    private GUID taskID;

    public SetResourceJob(JobDefinition definition, @Nullable GUID taskID) {
        super(definition.getCondition());
        this.taskID = taskID;
        Map properties = definition.getProperties();
        String resIdString = properties.getOrDefault("Resource.noCustomEntry", "-1");
        if (resIdString == null) {
            throw new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoResID", new Object[0]));
        }
        this.resId = Integer.valueOf(resIdString);
        String ticketIdString = properties.getOrDefault("Ticket ID", "-1");
        if (ticketIdString != null && ticketIdString.contains("Ticket ID")) {
            throw new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketIDPlaceholder", new Object[0]));
        }
        this.ticketIds = ticketIdString == null ? new ArrayList() : HDPlaceholderUtils.getTicketIds(ticketIdString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobResultContainer run() throws TaskExecutionException {
        HashSet<Integer> changedIds = (HashSet<Integer>)TicketsWithStatusSeries.TICKET_IDS_CHANGED_BY_THIS_TASK.get();
        if (changedIds == null) {
            changedIds = new HashSet<Integer>();
        }
        ArrayList<Exception> toThrow = new ArrayList<Exception>();
        try (UserAccountScope scope = null;){
            GUID ownerId;
            TaskExecution ex = this.getTaskExecution();
            GUID gUID = ownerId = ex != null ? ex.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
            if (ownerId != null && !ownerId.equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID) && !ownerId.equals((Object)UserManager.getInstance().getCurrentUserAccountID())) {
                scope = UserAccountScope.create((GUID)ownerId);
            }
            for (Integer ticketId : this.ticketIds) {
                try {
                    TicketVO ticket;
                    changedIds.add(ticketId);
                    TicketsWithStatusSeries.TICKET_IDS_CHANGED_BY_THIS_TASK.set(changedIds);
                    try {
                        ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                    }
                    catch (AccessDeniedException e) {
                        toThrow.add((Exception)new TaskExecutionException((Throwable)e));
                        continue;
                    }
                    if (ticket == null) {
                        toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketNotAuftragError", new Object[]{ticketId}))));
                        continue;
                    }
                    if (ticket.getStatusID() >= 300) {
                        toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketNotOpenError", new Object[]{ticketId}))));
                        continue;
                    }
                    GUID resGUID = HDUsersAndGroups.getResource((int)this.resId).getID();
                    if (ticket.isSlaveInBundle() || Objects.equals(resGUID, ticket.getResourceID())) continue;
                    Object object = HelpDeskTaskPlannerServerPlugin.TICKET_DATA_CONNECTOR_LOCK;
                    synchronized (object) {
                        try (WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)this.taskID);){
                            if (ticket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_DISPATCHING_REA_STEP_ID) == null) {
                                MutableTicketData data = new MutableTicketData();
                                data.put((TicketField)Tickets.FIELD_RESOURCE_GUID, (Object)resGUID);
                                TicketManager.getManipulator().updateTicketData(ticketId.intValue(), data);
                            } else {
                                TicketManager.getManipulator().escalateTicket(ticketId.intValue(), resGUID, ReaStepTextVO.empty(), true);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    toThrow.add(e);
                }
            }
            if (toThrow.size() > 0) {
                throw HDTaskPlannerUtils.combinedException(toThrow);
            }
        }
        return null;
    }

    @Nullable
    protected TaskExecution getTaskExecution() {
        if (this.taskID == null) {
            return null;
        }
        return TaskPlanner.getInstance().getTaskExecution(this.taskID);
    }

    protected boolean evaluateCondition(ConditionDefinition conditionDefinition) {
        return false;
    }
}

