/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.AddTextToRequestBehavior;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerUtils;
import com.inet.helpdesk.plugins.taskplanner.server.series.ticketswithstatus.TicketsWithStatusSeries;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class AddTextToRequestAction
extends ResultAction {
    private final List<Integer> ticketIds;
    private final String autotext;
    private final String prefixLine;
    private final boolean addToInquiry;
    private GUID taskID;
    private AddTextToRequestBehavior b = new AddTextToRequestBehavior();

    public AddTextToRequestAction(Map<String, String> properties, @Nullable GUID taskID) {
        this.taskID = taskID;
        String ticketIdString = properties.getOrDefault("Ticket ID", "-1");
        if (ticketIdString != null && ticketIdString.contains("Ticket ID")) {
            throw new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketIDPlaceholder", new Object[0]));
        }
        this.ticketIds = ticketIdString == null ? new ArrayList() : HDPlaceholderUtils.getTicketIds(ticketIdString);
        this.autotext = properties.get("AutoText");
        this.prefixLine = properties.get("AutoTextPrefix");
        this.addToInquiry = "inquiry".equals(properties.getOrDefault("InquiryOrLatest", "inquiry"));
    }

    protected void handle(List<JobResultContainer> results) throws TaskExecutionException {
        HashSet<Integer> changedIds = (HashSet<Integer>)TicketsWithStatusSeries.TICKET_IDS_CHANGED_BY_THIS_TASK.get();
        if (changedIds == null) {
            changedIds = new HashSet<Integer>();
        }
        ArrayList<Exception> toThrow = new ArrayList<Exception>();
        for (Integer ticketId : this.ticketIds) {
            try {
                TicketVO ticket;
                changedIds.add(ticketId);
                TicketsWithStatusSeries.TICKET_IDS_CHANGED_BY_THIS_TASK.set(changedIds);
                try {
                    ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                }
                catch (AccessDeniedException e) {
                    HDLogger.warn((Object)("Access denied when reading ticket " + ticketId + " in AddTextToRequestAction: " + e.getMessage()));
                    continue;
                }
                if (ticket == null) {
                    toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalStateException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicket", new Object[]{ticketId}))));
                    continue;
                }
                if (Status.isClosedOrDeletedStatus((int)ticket.getStatusID())) {
                    toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketNotOpenError", new Object[]{ticketId}))));
                    continue;
                }
                if (ticket.isSlaveInBundle()) continue;
                AutoTextManager autoTextManager = this.getAutoTextManager();
                AddTextToRequestBehavior b = this.getBehavior();
                int reaStepId = b.determineReaStepId(ticket, this.addToInquiry);
                AutoTextVO chosenAutoText = b.findAutoText(autoTextManager, ticketId, reaStepId, this.autotext);
                Object autotextInfo = HtmlConverter.getInlinedHtml((String)chosenAutoText.getContentText());
                String delim = "<br/><br/>";
                if (this.prefixLine != null && this.prefixLine.trim().length() > 0) {
                    autotextInfo = HtmlConverter.html2text((String)this.prefixLine) + delim + (String)autotextInfo;
                }
                b.addAutoTextToReastep((String)autotextInfo, delim, reaStepId, chosenAutoText, ticketId, this.taskID);
            }
            catch (Exception e) {
                toThrow.add(e);
            }
        }
        if (toThrow.size() > 0) {
            throw HDTaskPlannerUtils.combinedException(toThrow);
        }
        this.setProgress(100);
    }

    protected AutoTextManager getAutoTextManager() {
        return (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
    }

    protected AddTextToRequestBehavior getBehavior() {
        return this.b;
    }
}

