/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.utils.StringConcatenator;
import com.inet.helpdesk.plugins.attachments.server.api.TicketAttachmentProvider;
import com.inet.helpdesk.plugins.attachments.shared.AttachmentDescription;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerUtils;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.http.upload.AttachmentType;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.error.TaskPlannerCodes;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.result.FileResult;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AddAttachmentToTicketAction
extends ResultAction {
    private final List<Integer> ticketIds;
    private GUID taskID;

    public AddAttachmentToTicketAction(List<Integer> ticketIds, @Nullable GUID taskID) {
        this.ticketIds = ticketIds;
        this.taskID = taskID;
    }

    protected void handle(List<JobResultContainer> results) throws TaskExecutionException {
        this.setProgress(0);
        ArrayList<Exception> toThrow = new ArrayList<Exception>();
        for (Integer ticketId : this.ticketIds) {
            try {
                if (TicketManager.getReader().getTicket(ticketId.intValue()).isSlaveInBundle()) {
                }
            }
            catch (AccessDeniedException e) {}
            continue;
            try {
                TicketAttachmentProvider attachmentsProvider = this.getTicketAttachmentProvider();
                HashMap<String, AttachmentDescription> fileNameToContentStream = new HashMap<String, AttachmentDescription>();
                for (JobResultContainer c : results) {
                    List fileResults = c.getResults(ResultFlavor.FILE);
                    for (FileResult result : fileResults) {
                        String uniqueName = this.getUniqueName(fileNameToContentStream, result);
                        InputStream in = result.getFileContent();
                        AttachmentDescription desc = new AttachmentDescription();
                        desc.setFileName(uniqueName);
                        desc.setLastModified(System.currentTimeMillis());
                        desc.setOwnerId(ticketId);
                        AttachmentDescription addedFile = attachmentsProvider.addFile(desc, in, AttachmentType.Attachment);
                        fileNameToContentStream.put(addedFile.getFileName(), addedFile);
                    }
                }
                WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)this.taskID);
                try {
                    MutableReaStepData stepData = new MutableReaStepData();
                    String prefix = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddedByTaskPlanner", new Object[0]) + " ";
                    List names = fileNameToContentStream.keySet().stream().sorted().collect(Collectors.toList());
                    int maxAttFileNamesLength = 255 - prefix.length();
                    String allAttFileNames = StringConcatenator.concatAndShortenIfNeeded(names, (int)maxAttFileNamesLength);
                    String stepDesc = prefix + allAttFileNames;
                    stepData.put((ReaStepField)ReaStepVO.FIELD_DESC, (Object)stepDesc);
                    ActionVO action = (ActionVO)this.getActionManager().get(-21);
                    ReaStepTextVO stepText = ReaStepTextVO.empty();
                    this.getTicketManipulator().applyAction(ticketId.intValue(), stepData, stepText, action, null);
                }
                finally {
                    if (addReaStepData == null) continue;
                    addReaStepData.close();
                }
            }
            catch (Exception e) {
                if (e instanceof TaskExecutionException) {
                    toThrow.add((Exception)((TaskExecutionException)e));
                    continue;
                }
                toThrow.add((Exception)new TaskExecutionException((Throwable)e, (ErrorCode)TaskPlannerCodes.CannotSendEmail));
            }
        }
        if (toThrow.size() > 0) {
            throw HDTaskPlannerUtils.combinedException(toThrow);
        }
        this.setProgress(100);
    }

    protected TicketAttachmentProvider getTicketAttachmentProvider() {
        return (TicketAttachmentProvider)ServerPluginManager.getInstance().getSingleInstance(TicketAttachmentProvider.class);
    }

    protected TicketManipulator getTicketManipulator() {
        return TicketManager.getManipulator();
    }

    protected ActionManager getActionManager() {
        return ActionManager.getInstance();
    }

    private String getUniqueName(Map<String, AttachmentDescription> fileNameToContentStream, FileResult result) {
        String fileName = result.getFileName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot == -1) {
            lastDot = fileName.length();
        }
        String prefixFilePart = fileName.substring(0, lastDot);
        String suffixFilePart = fileName.substring(lastDot);
        Object tmpName = prefixFilePart;
        int counter = 1;
        while (fileNameToContentStream.containsKey((String)tmpName + suffixFilePart)) {
            tmpName = prefixFilePart + "_" + counter++;
        }
        return (String)tmpName + suffixFilePart;
    }
}

