/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server;

import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDescription;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AdditionalReaStepFieldDefinitionTaskId
extends AdditionalReaStepFieldDefinition<GUID> {
    public AdditionalReaStepFieldDefinitionTaskId() {
        super((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID);
    }

    public List<AdditionalReaStepFieldDescription> convertToDescriptions(ReaStepVO step, Set<Integer> availableStepsIds) {
        if (step == null) {
            return null;
        }
        GUID taskId = (GUID)step.getValue((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID);
        if (taskId == null) {
            return null;
        }
        TaskDefinition taskDefinition = this.getTaskPlannerInstance().getTaskDefinition(taskId);
        ArrayList<AdditionalReaStepFieldDescription> list = new ArrayList<AdditionalReaStepFieldDescription>();
        boolean hasAccessToTask = false;
        if (taskDefinition != null) {
            List userTaskIDs;
            if (SystemPermissionChecker.checkAccess((Permission)TaskPlanner.PERMISSION_TASKPLANNER_ADMIN)) {
                hasAccessToTask = true;
            } else if (SystemPermissionChecker.checkAccess((Permission)TaskPlanner.PERMISSION_TASKPLANNER) && (userTaskIDs = this.getTaskPlannerInstance().getUserTaskIDs(UserManager.getInstance().getCurrentUserAccountID())) != null && userTaskIDs.contains(taskId)) {
                hasAccessToTask = true;
            }
        }
        if (taskDefinition == null || !hasAccessToTask) {
            UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
            if (currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
                HashMap<String, String> linkValues = new HashMap<String, String>();
                linkValues.put("iconclass", "icon-additionalreastepfield-taskplanner");
                linkValues.put("title", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ticketlist.additionalreastepfield.tplink.applied", new Object[0]));
                list.add(new AdditionalReaStepFieldDescription("externallink", linkValues));
                return list;
            }
            return null;
        }
        HashMap<String, Object> linkValues = new HashMap<String, Object>();
        linkValues.put("url", "taskplanner/" + String.valueOf(taskId));
        linkValues.put("iconclass", "icon-additionalreastepfield-taskplanner");
        linkValues.put("title", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ticketlist.additionalreastepfield.tplink.title", new Object[]{taskDefinition.getName()}));
        list.add(new AdditionalReaStepFieldDescription("externallink", linkValues));
        return list;
    }

    protected TaskPlanner getTaskPlannerInstance() {
        return TaskPlanner.getInstance();
    }
}

