/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import java.util.List;

public class AddTextToRequestBehavior {
    public static final String PROPERTY_AUTOTEXT = "AutoText";
    public static final String PROPERTY_INQUIRY_OR_LATEST = "InquiryOrLatest";
    public static final String PROPERTY_VALUE_INQUIRY = "inquiry";
    public static final String PROPERTY_VALUE_LATEST = "latest";
    public static final String PROPERTY_PREFIX = "AutoTextPrefix";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAutoTextToReastep(String autotextInfo, String delim, int initialReaStepID, AutoTextVO chosenAutoText, int ticketId, GUID taskID) throws TaskExecutionException {
        Object newPreview;
        ReaStepTextVO reaStepText;
        try {
            reaStepText = TicketManager.getReader().getReaStepText(initialReaStepID);
        }
        catch (AccessDeniedException e) {
            HDLogger.warn((Object)("Access denied when reading ReaStepText " + initialReaStepID + ": " + e.getMessage()));
            return;
        }
        AutoTextManager autoTextManager = (AutoTextManager)ServerPluginManager.getInstance().getSingleInstance(AutoTextManager.class);
        autotextInfo = autoTextManager.fillPlaceholders(autotextInfo, Integer.valueOf(ticketId), Integer.valueOf(initialReaStepID));
        String oldPreview = reaStepText.getText();
        String contentText = chosenAutoText.getContentText();
        boolean needsSettingToHtml = false;
        if (reaStepText.hasHtmlContent() || contentText.startsWith("<html>")) {
            int index = oldPreview.length();
            int lastIndexOfBody = oldPreview.lastIndexOf("</body>");
            if (lastIndexOfBody != -1) {
                index = lastIndexOfBody;
            }
            StringBuilder newPreviewSB = new StringBuilder(oldPreview);
            newPreviewSB.insert(index, autotextInfo);
            newPreviewSB.insert(index, delim);
            newPreview = newPreviewSB.toString();
            needsSettingToHtml = true;
        } else {
            newPreview = oldPreview + "\n\n" + HtmlConverter.html2text((String)autotextInfo);
        }
        Object object = HelpDeskTaskPlannerServerPlugin.TICKET_DATA_CONNECTOR_LOCK;
        synchronized (object) {
            try (WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)taskID);){
                ReaStepTextVO newText = ReaStepTextVO.of((String)newPreview, (boolean)needsSettingToHtml);
                TicketManager.getManipulator().updateReaStepText(initialReaStepID, newText, ExtensionArguments.create());
            }
        }
    }

    public AutoTextVO findAutoText(AutoTextManager autoTextManager, int ticketId, int reaStepId, String autotextLabel) throws TaskExecutionException {
        List autoTexts = autoTextManager.getAutoTexts(Integer.valueOf(ticketId), Integer.valueOf(reaStepId), null, false);
        if (autoTexts == null || autoTexts.size() == 0) {
            HDLogger.error((Object)"No autotexts found!");
            throw new TaskExecutionException((Throwable)new IllegalStateException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoAutotexts", new Object[0])));
        }
        for (AutoTextVO autoText : autoTexts) {
            if (!autoText.getLabel().equals(autotextLabel)) continue;
            return autoText;
        }
        HDLogger.error((Object)("No autotext '" + autotextLabel + "' found!"));
        throw new TaskExecutionException((Throwable)new IllegalStateException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoAutotextFound", new Object[]{autotextLabel})));
    }

    public int determineReaStepId(TicketVO ticket, boolean addToInquiry) throws TaskExecutionException {
        int reaStepId;
        if (addToInquiry) {
            reaStepId = ticket.getInitialReaStepID();
        } else {
            List reaStepsForTicket;
            try {
                reaStepsForTicket = TicketManager.getReader().getReaStepsForTicket(ticket.getID(), BundleStepsFilter.WITH_BUNDLE_STEPS);
            }
            catch (AccessDeniedException e) {
                HDLogger.warn((Object)("Access denied when reading ReaSteps for ticket " + ticket.getID() + ": " + e.getMessage()));
                throw new TaskExecutionException((Throwable)e);
            }
            if (reaStepsForTicket.size() > 0 && ((ReaStepVO)reaStepsForTicket.get(0)).getActionID() == -22) {
                throw new TaskExecutionException((Throwable)new IllegalStateException("Endless loop detected for ticket-change-trigger"));
            }
            ReaStepVO rs = (ReaStepVO)reaStepsForTicket.get(0);
            Integer mainReaStepID = (Integer)rs.getValue((ReaStepField)ReaStepVO.FIELD_GROUP_REASTEP);
            if (mainReaStepID != null) {
                try {
                    rs = TicketManager.getReader().getReaStep(mainReaStepID.intValue());
                }
                catch (AccessDeniedException e) {
                    HDLogger.warn((Object)("Access denied when reading ReaStep " + mainReaStepID + ": " + e.getMessage()));
                    throw new TaskExecutionException((Throwable)e);
                }
            }
            reaStepId = rs.getID();
        }
        return reaStepId;
    }
}

