/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.emailreceived;

import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.helpdesk.plugins.taskplanner.server.TaskPlannerTicketActionListener;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.statuschange.StatusChangeTrigger;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EmailReceivedTrigger
extends StatusChangeTrigger
implements Trigger,
TaskPlannerTicketActionListener {
    private final String subjectFilter;
    private final String senderFilter;
    private final String recipFilter;
    private final String bodyFilter;
    private GUID taskID;

    public EmailReceivedTrigger(TriggerDefinition definition, GUID taskID) {
        super(definition, new ArrayList<Integer>(), taskID);
        this.taskID = taskID;
        Map props = definition.getProperties();
        this.subjectFilter = props.getOrDefault("SUBJECT_FILTER", "");
        this.senderFilter = props.getOrDefault("RECIPIENT_FILTER", "");
        this.recipFilter = props.getOrDefault("EMAIL_IN_RECIPIENT_FILTER", "");
        this.bodyFilter = props.getOrDefault("BODY_FILTER", "");
    }

    @Override
    public void handleTicketAction(OperationChangedTicket operationChangedTicket, ActionVO actionVO, MutableReaStepData mutableReaStepData) {
        List addedReaSteps = operationChangedTicket.getAddedReaSteps();
        String text = "";
        boolean isHtml = false;
        int reaID = -1;
        if (addedReaSteps.size() > 0) {
            text = ((OperationNewReaStep)addedReaSteps.get(0)).getText().getText();
            isHtml = ((OperationNewReaStep)addedReaSteps.get(0)).getText().hasHtmlContent();
            reaID = ((OperationNewReaStep)addedReaSteps.get(0)).getReaStepId();
        }
        this.appliedAction(actionVO.getId(), operationChangedTicket.getTicketId(), mutableReaStepData, text, isHtml, reaID);
    }

    @Override
    protected TaskExecution getTaskExecutionFor(GUID taskID) {
        return TaskPlanner.getInstance().getTaskExecution(taskID);
    }

    private void appliedAction(int actionId, final int ticketId, MutableReaStepData reaStepData, String text, boolean isHtml, int reaID) {
        if (this.triggerAction == null) {
            return;
        }
        String sender = null;
        String recip = null;
        String subject = null;
        boolean isCreatingTicketFromAnIncomingEmail = false;
        ReaStepVO reaStep = null;
        ReaStepTextVO reaStepText = null;
        if (reaID != -1) {
            TaskExecution execution = TaskPlanner.getInstance().getTaskExecution(this.taskID);
            GUID currentUser = execution != null && execution.getOwnerId() != null ? execution.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
            try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
                reaStep = TicketManager.getReader().getReaStep(reaID);
                if (reaStep != null) {
                    reaStepText = TicketManager.getReader().getReaStepText(reaID);
                    recip = reaStep.getEmailReceiverAddresses();
                    boolean bl = isCreatingTicketFromAnIncomingEmail = recip != null && !recip.isBlank() && (actionId == 5 || actionId == 4);
                    if (isCreatingTicketFromAnIncomingEmail) {
                        reaStepData = reaStep.getReaStepDataCopy();
                    }
                }
            }
            catch (AccessDeniedException exc) {
                return;
            }
        }
        if (actionId == -9 || isCreatingTicketFromAnIncomingEmail) {
            if (sender == null) {
                sender = (String)reaStepData.getOrDefault((ReaStepField)ReaStepVO.FIELD_EMAIL_IN);
            }
            if (recip == null) {
                recip = (String)reaStepData.getOrDefault((ReaStepField)ReaStepVO.FIELD_EMAIL_AN);
            }
            if (subject == null) {
                subject = (String)reaStepData.getOrDefault((ReaStepField)ReaStepVO.FIELD_DESC);
            }
            if (text == null) {
                text = "";
            }
            String bodyFilterText = this.bodyFilter != null ? this.bodyFilter : "";
            String senderFilterText = this.senderFilter != null ? this.senderFilter : "";
            String recipFilterText = this.recipFilter != null ? this.recipFilter : "";
            String subjectFilterText = this.subjectFilter != null ? this.subjectFilter : "";
            String plainText = isHtml ? HtmlConverter.html2text((String)text) : text;
            if (!(plainText.toLowerCase().contains(bodyFilterText.toLowerCase()) && sender.toLowerCase().contains(senderFilterText.toLowerCase()) && recip.toLowerCase().contains(recipFilterText.toLowerCase()) && subject.toLowerCase().contains(subjectFilterText.toLowerCase()))) {
                return;
            }
            TaskExecution execution = this.getTaskExecutionFor(this.taskID);
            GUID currentUser = execution != null && execution.getOwnerId() != null ? execution.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
            ActionVO actionVO = (ActionVO)ActionManager.getInstance().get(actionId);
            try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
                this.ticketsChanged((List<Integer>)new ArrayList<Integer>(){
                    {
                        this.add(ticketId);
                    }
                }, actionVO, reaStep, reaStepText, reaStepData, text, isHtml);
            }
        }
    }

    @Override
    public void activate(GUID taskGUID, Trigger.TriggerAction triggerAction) {
        this.triggerAction = triggerAction;
        this.registerListener();
    }

    @Override
    protected void registerListener() {
        HDTaskPlannerDataListener.addTicketActionListener(this);
        HDTaskPlannerDataListener.addListener(this);
    }

    @Override
    public void deactivate() {
        this.triggerAction = null;
        this.unregisterListener();
    }

    @Override
    protected void unregisterListener() {
        HDTaskPlannerDataListener.removeTicketActionListener(this);
    }

    @Override
    public void handleEvent(TicketEvent ticketEvent) {
        if (this.triggerAction == null) {
            return;
        }
        List changedTickets = ticketEvent.getChangedTickets();
        changedTickets.stream().forEach(t -> {
            boolean isNewTicket;
            boolean bl = isNewTicket = t.getOldTicket() == null && t.getNewTicket() != null && t.getNewTicket().getResourceID() == null;
            if (isNewTicket) {
                int initialReaStepID = t.getNewTicket().getInitialReaStepID();
                TaskExecution execution = TaskPlanner.getInstance().getTaskExecution(this.taskID);
                GUID currentUser = execution != null && execution.getOwnerId() != null ? execution.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
                try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
                    ReaStepVO reaStep = TicketManager.getReader().getReaStep(initialReaStepID);
                    ReaStepTextVO reaStepText = TicketManager.getReader().getReaStepText(initialReaStepID);
                    if (reaStep != null && reaStepText != null) {
                        MutableReaStepData dataCopy = reaStep.getReaStepDataCopy();
                        String text = reaStepText.getText();
                        this.appliedAction(4, t.getTicketID(), dataCopy, text, reaStepText.hasHtmlContent(), initialReaStepID);
                    }
                }
                catch (AccessDeniedException accessDeniedException) {
                    // empty catch block
                }
            }
        });
    }
}

