/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextManager;
import com.inet.helpdesk.core.ticketmanager.model.AutoTextVO;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.action.AddTextToRequestAction;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AddTextToRequestActionFactory
extends ResultActionFactory<AddTextToRequestAction> {
    public static final String EXTENSION_NAME = "taskplanner.helpdesk.addtexttorequestaction";

    public AddTextToRequestActionFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.NONE);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategory", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategoryDesc", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/addtext_32.png");
        String helpKey = "taskplanner.action.addtexttorequest";
        List autoTextValues = AutoTextManager.getInstance().getAllAutoTexts();
        ArrayList<Object> fields = new ArrayList<Object>();
        TextField textField = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        HDPlaceholders.setPlaceholderDynamicallyForTextFieldInAction(taskID, textField);
        fields.add(textField);
        ArrayList autotexts = autoTextValues.stream().map(t -> new LocalizedKey(t.getLabel(), t.getLabel())).collect(Collectors.toCollection(ArrayList::new));
        String autoTextLabelAlways = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategoryAutoTextLabelAlways", new Object[0]);
        SelectField selectFieldAlways = new SelectField("AutoText", autoTextLabelAlways, autotexts);
        fields.add(selectFieldAlways);
        TextField prefixField = new TextField("AutoTextPrefix", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextPrefixLabel", new Object[0]));
        prefixField.setValue(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextPrefixLabel.default", new Object[0]));
        if (autoTextValues.size() > 0) {
            selectFieldAlways.setValue(((AutoTextVO)autoTextValues.get(0)).getLabel());
        } else {
            LabelField label = new LabelField("AddAutoTextCategory.NoAutotext", "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategory.NoAutotext.text", new Object[0]));
            fields.add(label);
            ArrayList<FieldCondition> conditions = new ArrayList<FieldCondition>();
            conditions.add(FieldCondition.visible((Field)prefixField, (FieldCondition.OP)FieldCondition.OP.equals, (String)GUID.generateNew().toString()));
            textField.setConditions(conditions);
            selectFieldAlways.setConditions(conditions);
        }
        fields.add(prefixField);
        String inquiryOrLatestLabel = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextInquiryOrLatestLabel", new Object[0]);
        ArrayList<LocalizedKey> inquiryOrLatestOptions = new ArrayList<LocalizedKey>();
        inquiryOrLatestOptions.add(new LocalizedKey("inquiry", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextInquiryOrLatest.inquiry", new Object[0])));
        inquiryOrLatestOptions.add(new LocalizedKey("latest", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextInquiryOrLatest.latest", new Object[0])));
        SelectField inquiryOrLatestField = new SelectField("InquiryOrLatest", inquiryOrLatestLabel, inquiryOrLatestOptions);
        inquiryOrLatestField.setValue("inquiry");
        fields.add(inquiryOrLatestField);
        return new ResultActionInfo(this.getExtensionName(), name, description, iconURL, helpKey, fields);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
        Map props = definition.getProperties();
        if (props.get("AutoText") == null || ((String)props.get("AutoText")).isBlank()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextCategoryAutoTextMissing", new Object[0])});
        }
        if (props.get("Ticket ID") == null || ((String)props.get("Ticket ID")).isEmpty()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketEmpty", new Object[0])});
        }
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        if (definition.getProperty("AutoText") == null) {
            summary.add(new SummaryEntry("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAutoTextNeedAutoTextSetting", new Object[0])));
            return new SummaryInfo(summary);
        }
        String autoTextLabel = definition.getProperty("AutoText");
        List autoTextValues = AutoTextManager.getInstance().getAllAutoTexts();
        String finalAutoTextLabel = autoTextLabel;
        if (autoTextValues.stream().noneMatch(a -> a.getLabel().equalsIgnoreCase(finalAutoTextLabel))) {
            autoTextLabel = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]);
        }
        String infoKey = "inquiry".equals(definition.getProperty("InquiryOrLatest")) ? "AddAutoTextCategorySummaryInfoValue.inquiry" : "AddAutoTextCategorySummaryInfoValue.latest";
        summary.add(new SummaryEntry("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg(infoKey, new Object[]{autoTextLabel})));
        return new SummaryInfo(summary);
    }

    protected AddTextToRequestAction createInstanceFrom(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) {
        return new AddTextToRequestAction(definition.getProperties(), taskID);
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }
}

