/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeDeadlineLight;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttributeEscalationLight;
import com.inet.helpdesk.core.ticketmanager.timeline.TicketWarningListener;
import com.inet.helpdesk.plugins.taskplanner.server.TaskPlannerTicketActionListener;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.event.TaskEvent;
import com.inet.taskplanner.server.api.event.TaskEventListener;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HDTaskPlannerDataListener
implements TicketEventListener,
TaskEventListener,
TicketActionExtensionFactory {
    private List<TicketEventListener> listeners = new ArrayList<TicketEventListener>();
    private Map<GUID, Long> taskGuidToLastAsked = new HashMap<GUID, Long>();
    private Map<GUID, Set<Integer>> taskGuidToCreatedTickets = new HashMap<GUID, Set<Integer>>();
    private List<TicketEvent> createdTickets = new ArrayList<TicketEvent>();
    private PersistenceEntry taskplannerRoot = Persistence.getInstance().resolve("taskplanner");
    private Long storeCreatedTicketsSometimeSoonTime;
    private List<TaskPlannerTicketActionListener> ticketActionListeners = new ArrayList<TaskPlannerTicketActionListener>();
    private List<TicketWarningListener> ticketWarningListeners = new ArrayList<TicketWarningListener>();

    public HDTaskPlannerDataListener() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            HDTaskPlannerDataListener hDTaskPlannerDataListener = this;
            synchronized (hDTaskPlannerDataListener) {
                if (this.storeCreatedTicketsSometimeSoonTime != null) {
                    String json = new Json().toJson(this.createdTickets);
                    this.taskplannerRoot.resolve("createdTickets").setString(json);
                }
            }
        }));
    }

    public static void addTicketWarningListener(TicketWarningListener ticketWarningTrigger) {
        HDTaskPlannerDataListener l = HDTaskPlannerDataListener.getRegisteredInstance();
        if (l != null) {
            l.addSubTicketWarningListener(ticketWarningTrigger);
        }
    }

    public static void removeTicketWarningListener(TicketWarningListener ticketWarningTrigger) {
        HDTaskPlannerDataListener l = HDTaskPlannerDataListener.getRegisteredInstance();
        if (l != null) {
            l.removeSubTicketWarningListener(ticketWarningTrigger);
        }
    }

    public synchronized void notify(TaskEvent taskEvent) {
        GUID guid = taskEvent.getTaskID();
        if (taskEvent.getType() == TaskEvent.TaskEventType.DEACTIVATED || taskEvent.getType() == TaskEvent.TaskEventType.ACTIVATED || taskEvent.getType() == TaskEvent.TaskEventType.MODIFIED) {
            this.taskGuidToLastAsked.put(guid, this.currentTime());
            this.storeLastAskedMap();
            TaskExecution taskExecution = this.getTaskPlanner().getTaskExecution(guid);
            if (taskExecution != null) {
                Map stateProperties = taskExecution.getStateProperties();
                stateProperties.keySet().stream().filter(k -> k.contains("alreadytriggered")).forEach(k -> stateProperties.put(k, "false"));
                stateProperties.keySet().stream().filter(k -> k.contains("lastexecutiontime")).forEach(k -> stateProperties.put(k, "0"));
            }
        } else if (taskEvent.getType() == TaskEvent.TaskEventType.REMOVED) {
            this.taskGuidToLastAsked.remove(guid);
            this.storeLastAskedMap();
        }
    }

    @Nullable
    public TicketActionExtension createIfApplicable(@Nonnull OperationChangedTicket operationChangedTicket, @Nonnull ActionVO actionVO, @Nonnull ExtensionArguments extensionArguments, @Nonnull MutableReaStepData mutableReaStepData) {
        this.ticketActionListeners.forEach(l -> operationChangedTicket.getAfterWriteOperations().add(() -> l.handleTicketAction(operationChangedTicket, actionVO, mutableReaStepData)));
        return null;
    }

    public synchronized void init() {
        TaskPlanner taskPlanner = this.getTaskPlanner();
        taskPlanner.registerEventListener((TaskEventListener)this);
        String taskGuidToLastAskedJson = this.taskplannerRoot.resolve("taskGuidToLastAsked").getString();
        if (taskGuidToLastAskedJson != null) {
            try {
                HashMap map = (HashMap)new Json().fromJson(taskGuidToLastAskedJson, (Type)new JsonParameterizedType(HashMap.class, new Type[]{GUID.class, Long.class}));
                List allTaskIDs = taskPlanner.getAllTaskIDs();
                Set keysToRemove = map.keySet().stream().filter(k -> !allTaskIDs.contains(k)).collect(Collectors.toSet());
                keysToRemove.stream().forEach(map::remove);
                this.taskGuidToLastAsked = map;
            }
            catch (JsonException e) {
                HDLogger.error((Object)((Object)e));
            }
        } else {
            for (GUID g : taskPlanner.getAllTaskIDs()) {
                TaskDefinition taskDefinition = taskPlanner.getTaskDefinition(g);
                SeriesDefinition series = taskDefinition.getSeries();
                HashSet<String> watchingExtensions = new HashSet<String>(){
                    {
                        this.add("series.helpdesk.ticketcreated");
                        if (ServerPluginManager.getInstance().isPluginLoaded("ticketprocess")) {
                            this.add("series.helpdesk.process-started");
                        }
                    }
                };
                if (series == null || !watchingExtensions.contains(series.getExtensionName())) continue;
                this.taskGuidToLastAsked.put(g, 0L);
            }
            this.storeLastAskedMap();
        }
        String createdTicketsJson = this.taskplannerRoot.resolve("createdTickets").getString();
        if (createdTicketsJson != null) {
            try {
                this.createdTickets = (List)new Json().fromJson(createdTicketsJson, (Type)new JsonParameterizedType(ArrayList.class, new Type[]{TicketEvent.class}));
            }
            catch (JsonException e) {
                HDLogger.error((Object)((Object)e));
            }
        }
    }

    private synchronized void storeLastAskedMap() {
        String json = new Json().toJson(this.taskGuidToLastAsked);
        this.taskplannerRoot.resolve("taskGuidToLastAsked").setString(json);
    }

    private synchronized void storeCreatedTicketsSometimeSoon() {
        if (this.storeCreatedTicketsSometimeSoonTime == null) {
            this.storeCreatedTicketsSometimeSoonTime = System.currentTimeMillis() + 300000L;
        } else if (System.currentTimeMillis() > this.storeCreatedTicketsSometimeSoonTime) {
            this.storeCreatedTicketsSometimeSoonTime = null;
            String json = new Json().toJson(this.createdTickets);
            this.taskplannerRoot.resolve("createdTickets").setString(json);
        }
    }

    public static HDTaskPlannerDataListener getRegisteredInstance() {
        List ticketDataChangeListeners = DynamicExtensionManager.getInstance().get(TicketEventListener.class);
        ticketDataChangeListeners.removeIf(f -> !(f instanceof HDTaskPlannerDataListener));
        if (ticketDataChangeListeners.size() > 0) {
            return (HDTaskPlannerDataListener)ticketDataChangeListeners.get(0);
        }
        return null;
    }

    public static void addListener(TicketEventListener listener) {
        HDTaskPlannerDataListener l = HDTaskPlannerDataListener.getRegisteredInstance();
        if (l != null) {
            l.addSubListener(listener);
        }
    }

    public static void removeListener(TicketEventListener listener) {
        HDTaskPlannerDataListener l = HDTaskPlannerDataListener.getRegisteredInstance();
        if (l != null) {
            l.removeSubListener(listener);
        }
    }

    public synchronized void addSubTicketWarningListener(TicketWarningListener t) {
        this.ticketWarningListeners.add(t);
    }

    public synchronized void removeSubTicketWarningListener(TicketWarningListener t) {
        this.ticketWarningListeners.remove(t);
    }

    public synchronized void addSubTicketActionListener(TaskPlannerTicketActionListener t) {
        this.ticketActionListeners.add(t);
    }

    public synchronized void removeSubTicketActionListener(TaskPlannerTicketActionListener t) {
        this.ticketActionListeners.remove(t);
    }

    public static void addTicketActionListener(TaskPlannerTicketActionListener listener) {
        HDTaskPlannerDataListener l = HDTaskPlannerDataListener.getRegisteredInstance();
        if (l != null) {
            l.addSubTicketActionListener(listener);
        }
    }

    public static void removeTicketActionListener(TaskPlannerTicketActionListener listener) {
        HDTaskPlannerDataListener l = HDTaskPlannerDataListener.getRegisteredInstance();
        if (l != null) {
            l.removeSubTicketActionListener(listener);
        }
    }

    public synchronized void addSubListener(TicketEventListener t) {
        this.listeners.add(t);
    }

    public synchronized void removeSubListener(TicketEventListener t) {
        this.listeners.remove(t);
    }

    public void handleEvent(com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEvent ticketEvent) {
        ArrayList<TicketEventListener> localListeners = new ArrayList<TicketEventListener>(this.listeners);
        localListeners.forEach(t -> {
            try {
                t.handleEvent(ticketEvent);
            }
            catch (Exception exc) {
                HDLogger.error((Object)exc);
            }
        });
        if (this.ticketWarningListeners.size() > 0) {
            ArrayList<TicketWarningPacket> eventsToFire = new ArrayList<TicketWarningPacket>();
            for (ChangedTicketVO v : ticketEvent.getChangedTickets()) {
                TicketAttributeEscalationLight.Value newEscaLight;
                TicketAttributeEscalationLight.Value oldEscaLight;
                TicketAttributeDeadlineLight.Value newDeadLight;
                TicketVO newTicket = v.getNewTicket();
                if (newTicket == null) continue;
                TicketVO oldVO = v.getOldTicket();
                TicketAttributeDeadlineLight.Value oldDeadLight = oldVO == null ? null : (TicketAttributeDeadlineLight.Value)oldVO.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_DEADLINE_LIGHT);
                if (!Objects.equals(oldDeadLight, newDeadLight = (TicketAttributeDeadlineLight.Value)newTicket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_DEADLINE_LIGHT))) {
                    TicketWarningPacket deadPacket = TicketWarningPacket.createForDeadline(newTicket);
                    eventsToFire.add(deadPacket);
                }
                if (Objects.equals(oldEscaLight = oldVO == null ? null : (TicketAttributeEscalationLight.Value)oldVO.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_ESCALATION_LIGHT), newEscaLight = (TicketAttributeEscalationLight.Value)newTicket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_ESCALATION_LIGHT))) continue;
                TicketWarningPacket escaPacket = TicketWarningPacket.createForEscalation(newTicket);
                eventsToFire.add(escaPacket);
            }
            eventsToFire.forEach(e -> this.ticketWarningListeners.forEach(l -> l.warningChanged(e.ticket, e.warningType, e.warningLevel)));
        }
        long now = this.currentTime();
        List changedTickets = ticketEvent.getChangedTickets();
        if (this.taskGuidToLastAsked.size() > 0) {
            changedTickets.stream().filter(vo -> vo.getOldTicket() == null && vo.getNewTicket() != null).forEach(vo -> this.createdTickets.add(new TicketEvent(now, vo.getTicketID())));
            this.storeCreatedTicketsSometimeSoon();
        } else {
            this.createdTickets.clear();
        }
    }

    public synchronized TicketEvent getNextCreatedTicketAfter(GUID guid, long lastMarker, Predicate<Integer> predicate) {
        Long last = this.getTimeLastAsked(guid);
        return this.createdTickets.stream().filter(t -> (long)t.ticketId.intValue() > lastMarker && t.time > last && predicate.test(t.ticketId)).findFirst().orElse(null);
    }

    private synchronized Long getTimeLastAsked(GUID guid) {
        Long lastAsked = this.taskGuidToLastAsked.get(guid);
        if (lastAsked == null) {
            lastAsked = 0L;
            TaskExecution taskExecution = this.getTaskPlanner().getTaskExecution(guid);
            if (taskExecution != null) {
                lastAsked = taskExecution.getLastModified();
            }
        }
        return lastAsked;
    }

    public synchronized TicketEvent getNextProcessStartedTicketForTaskAfter(GUID guid, long lastMarker, Predicate<GUID> predicate) {
        if (ServerPluginManager.getInstance().isPluginLoaded("ticketprocess")) {
            try {
                Long lastAsked = this.getTimeLastAsked(guid);
                Class<?> processStartedSeries = Class.forName("com.inet.helpdesk.plugins.taskplanner.server.series.processstarted.ProcessStartedSeries");
                Method getNextProcessStartedTicketForTaskAfter = processStartedSeries.getMethod("getNextProcessStartedTicketForTaskAfter", GUID.class, Long.TYPE, Long.TYPE, Predicate.class);
                Object result = getNextProcessStartedTicketForTaskAfter.invoke(null, guid, lastMarker, lastAsked, predicate);
                return (TicketEvent)result;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                HDLogger.error((Object)e);
            }
        }
        return null;
    }

    public synchronized void cleanUp(GUID guid, long timeToSet) {
        this.taskGuidToLastAsked.put(guid, timeToSet);
        int size = this.createdTickets.size();
        Long minimumTime = this.taskGuidToLastAsked.values().stream().sorted().findFirst().orElse(0L);
        int removeUpTo = -1;
        for (int i = 0; i < size; ++i) {
            long time = this.createdTickets.get((int)i).time;
            if (time >= minimumTime) continue;
            removeUpTo = i;
        }
        if (removeUpTo >= 0) {
            this.createdTickets.subList(0, removeUpTo + 1).clear();
        }
        this.storeLastAskedMap();
        this.storeCreatedTicketsSometimeSoon();
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    protected TaskPlanner getTaskPlanner() {
        return TaskPlanner.getInstance();
    }

    public void addCreatedTicketForTask(GUID taskID, int ticketID) {
        Set<Integer> integers = this.taskGuidToCreatedTickets.get(taskID);
        if (integers == null) {
            integers = new HashSet<Integer>();
        }
        integers.add(ticketID);
        this.taskGuidToCreatedTickets.put(taskID, integers);
    }

    public boolean wasTicketCreatedByThisTask(int ticketID, GUID taskID) {
        boolean result;
        Set<Integer> integers = this.taskGuidToCreatedTickets.get(taskID);
        boolean bl = result = integers != null && integers.contains(ticketID);
        if (result) {
            HDLogger.warn((Object)("Stopping suspected endless loop in Task Planner trigger for ticket created by task: #" + ticketID));
        }
        return result;
    }

    @JsonData
    public static class TicketEvent {
        protected long time;
        protected Integer ticketId;

        private TicketEvent() {
        }

        public TicketEvent(long now, Integer i) {
            this.time = now;
            this.ticketId = i;
        }

        protected long getMarker() {
            return this.ticketId.intValue();
        }
    }

    private static class TicketWarningPacket {
        TicketVO ticket;
        TicketWarningListener.WarningType warningType;
        TicketWarningListener.WarningLevel warningLevel;

        TicketWarningPacket(TicketVO ticket, TicketWarningListener.WarningType warningType, TicketWarningListener.WarningLevel warningLevel) {
            this.ticket = ticket;
            this.warningType = warningType;
            this.warningLevel = warningLevel;
        }

        @Nonnull
        private static TicketWarningPacket createForEscalation(@Nonnull TicketVO newTicket) {
            TicketAttributeEscalationLight.Value newEscaLight = (TicketAttributeEscalationLight.Value)newTicket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_ESCALATION_LIGHT);
            if (newEscaLight != null) {
                return new TicketWarningPacket(newTicket, TicketWarningListener.WarningType.Autoescalation, TicketWarningListener.WarningLevel.valueOf((String)newEscaLight.name()));
            }
            return new TicketWarningPacket(newTicket, TicketWarningListener.WarningType.Autoescalation, TicketWarningListener.WarningLevel.none);
        }

        @Nonnull
        private static TicketWarningPacket createForDeadline(@Nonnull TicketVO newTicket) {
            TicketAttributeDeadlineLight.Value newDeadLight = (TicketAttributeDeadlineLight.Value)newTicket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_DEADLINE_LIGHT);
            if (newDeadLight != null) {
                return new TicketWarningPacket(newTicket, TicketWarningListener.WarningType.Deadline, TicketWarningListener.WarningLevel.valueOf((String)newDeadLight.name()));
            }
            return new TicketWarningPacket(newTicket, TicketWarningListener.WarningType.Deadline, TicketWarningListener.WarningLevel.none);
        }
    }
}

