/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionForTicketOwner;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.DynamicExtension;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Font;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HDPlaceholderUtils {
    private static final ConfigValue<String> EXTERNAL_URL = new ConfigValue(ConfigKey.SERVER_URL);
    static final DynamicExtension<UserField> userFields = new DynamicExtension(UserField.class);
    private static HDPlaceholderUtils INSTANCE = new HDPlaceholderUtils();

    public static Map<String, String> fillPlaceholderValuesFor(TicketVO ticket) {
        return INSTANCE.fillPlaceholderValuesImpl(ticket);
    }

    public Map<String, String> fillPlaceholderValuesImpl(TicketVO ticket) {
        UserGroupInfo resource;
        if (ticket == null) {
            return new HashMap<String, String>();
        }
        String ticketLink = this.getTicketLink(ticket);
        HashMap<String, String> placeholderValues = new HashMap<String, String>();
        UserAccount owner = this.getOwner(ticket);
        UserAccount creator = this.getCreator(ticket);
        UserAccount dispatcher = this.getDispatcher(ticket);
        UserAccount lastEditor = this.getLastEditor(ticket);
        List fieldDefinitionsRaw = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
        Set visibleUserFieldKeys = fieldDefinitionsRaw.stream().sorted(Comparator.comparingInt(FieldDefinition::getPriority)).filter(f -> f instanceof UserFieldDefinition && f.getFieldKey() != null && f.getLabel() != null && !f.getLabel().isBlank() && ((UserFieldDefinition)f).isAvailable(UserManager.getInstance().getCurrentUserAccount())).map(f -> f.getFieldKey()).collect(Collectors.toSet());
        placeholderValues.put("owner.id", owner != null && owner.getID() != null ? owner.getID().toString() : "");
        if (visibleUserFieldKeys.contains("firstname") || visibleUserFieldKeys.contains("lastname") || visibleUserFieldKeys.contains("email")) {
            placeholderValues.put("owner.name", this.getUserDisplayName(owner));
            placeholderValues.put("creator.name", this.getUserDisplayName(creator));
            placeholderValues.put("dispatcher.name", this.getUserDisplayName(dispatcher));
            placeholderValues.put("lasteditor.name", this.getUserDisplayName(lastEditor));
        }
        if (visibleUserFieldKeys.contains("email")) {
            placeholderValues.put("owner.email", this.getUserField(owner, (UserField<String>)UsersAndGroups.FIELD_EMAIL));
            placeholderValues.put("creator.email", this.getUserField(creator, (UserField<String>)UsersAndGroups.FIELD_EMAIL));
            placeholderValues.put("dispatcher.email", this.getUserField(dispatcher, (UserField<String>)UsersAndGroups.FIELD_EMAIL));
            placeholderValues.put("lasteditor.email", this.getUserField(lastEditor, (UserField<String>)UsersAndGroups.FIELD_EMAIL));
        }
        if (visibleUserFieldKeys.contains("custom1")) {
            placeholderValues.put("owner.custom1", this.getUserField(owner, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom1")));
            placeholderValues.put("creator.custom1", this.getUserField(creator, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom1")));
            placeholderValues.put("dispatcher.custom1", this.getUserField(dispatcher, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom1")));
            placeholderValues.put("lasteditor.custom1", this.getUserField(lastEditor, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom1")));
        }
        if (visibleUserFieldKeys.contains("custom2")) {
            placeholderValues.put("owner.custom2", this.getUserField(owner, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom2")));
            placeholderValues.put("creator.custom2", this.getUserField(creator, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom2")));
            placeholderValues.put("dispatcher.custom2", this.getUserField(dispatcher, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom2")));
            placeholderValues.put("lasteditor.custom2", this.getUserField(lastEditor, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom2")));
        }
        if (visibleUserFieldKeys.contains("custom3")) {
            placeholderValues.put("owner.custom3", this.getUserField(owner, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom3")));
            placeholderValues.put("creator.custom3", this.getUserField(creator, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom3")));
            placeholderValues.put("dispatcher.custom3", this.getUserField(dispatcher, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom3")));
            placeholderValues.put("lasteditor.custom3", this.getUserField(lastEditor, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom3")));
        }
        if (visibleUserFieldKeys.contains("custom4")) {
            placeholderValues.put("owner.custom4", this.getUserField(owner, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom4")));
            placeholderValues.put("creator.custom4", this.getUserField(creator, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom4")));
            placeholderValues.put("dispatcher.custom4", this.getUserField(dispatcher, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom4")));
            placeholderValues.put("lasteditor.custom4", this.getUserField(lastEditor, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom4")));
        }
        if (visibleUserFieldKeys.contains("custom5")) {
            placeholderValues.put("owner.custom5", this.getUserField(owner, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom5")));
            placeholderValues.put("creator.custom5", this.getUserField(creator, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom5")));
            placeholderValues.put("dispatcher.custom5", this.getUserField(dispatcher, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom5")));
            placeholderValues.put("lasteditor.custom5", this.getUserField(lastEditor, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom5")));
        }
        if (visibleUserFieldKeys.contains("custom6")) {
            placeholderValues.put("owner.custom6", this.getUserField(owner, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom6")));
            placeholderValues.put("creator.custom6", this.getUserField(creator, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom6")));
            placeholderValues.put("dispatcher.custom6", this.getUserField(dispatcher, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom6")));
            placeholderValues.put("lasteditor.custom6", this.getUserField(lastEditor, (UserField<String>)UsersAndGroups.getFieldByKey((String)"custom6")));
        }
        if (visibleUserFieldKeys.contains("location")) {
            placeholderValues.put("owner.location", this.getUserLocation(owner));
            placeholderValues.put("creator.location", this.getUserLocation(creator));
            placeholderValues.put("dispatcher.location", this.getUserLocation(dispatcher));
            placeholderValues.put("lasteditor.location", this.getUserLocation(lastEditor));
        }
        if (visibleUserFieldKeys.contains("telephone")) {
            placeholderValues.put("owner.telephone", this.getUserField(owner, (UserField<String>)UsersAndGroups.FIELD_TELEPHONE));
            placeholderValues.put("creator.telephone", this.getUserField(creator, (UserField<String>)UsersAndGroups.FIELD_TELEPHONE));
            placeholderValues.put("dispatcher.telephone", this.getUserField(dispatcher, (UserField<String>)UsersAndGroups.FIELD_TELEPHONE));
            placeholderValues.put("lasteditor.telephone", this.getUserField(lastEditor, (UserField<String>)UsersAndGroups.FIELD_TELEPHONE));
        }
        if (visibleUserFieldKeys.contains("room")) {
            placeholderValues.put("owner.room", this.getUserField(owner, (UserField<String>)HDUsersAndGroups.FIELD_ROOM));
            placeholderValues.put("creator.room", this.getUserField(creator, (UserField<String>)HDUsersAndGroups.FIELD_ROOM));
            placeholderValues.put("dispatcher.room", this.getUserField(dispatcher, (UserField<String>)HDUsersAndGroups.FIELD_ROOM));
            placeholderValues.put("lasteditor.room", this.getUserField(lastEditor, (UserField<String>)HDUsersAndGroups.FIELD_ROOM));
        }
        if (visibleUserFieldKeys.contains("department")) {
            placeholderValues.put("owner.department", this.getUserField(owner, (UserField<String>)UsersAndGroups.getFieldByKey((String)"department")));
            placeholderValues.put("creator.department", this.getUserField(creator, (UserField<String>)UsersAndGroups.getFieldByKey((String)"department")));
            placeholderValues.put("dispatcher.department", this.getUserField(dispatcher, (UserField<String>)UsersAndGroups.getFieldByKey((String)"department")));
            placeholderValues.put("lasteditor.department", this.getUserField(lastEditor, (UserField<String>)UsersAndGroups.getFieldByKey((String)"department")));
        }
        if (visibleUserFieldKeys.contains("language")) {
            placeholderValues.put("owner.language", this.getUserField(owner, (UserField<String>)HDUsersAndGroups.FIELD_LANGUAGE));
            placeholderValues.put("creator.language", this.getUserField(creator, (UserField<String>)HDUsersAndGroups.FIELD_LANGUAGE));
            placeholderValues.put("dispatcher.language", this.getUserField(dispatcher, (UserField<String>)HDUsersAndGroups.FIELD_LANGUAGE));
            placeholderValues.put("lasteditor.language", this.getUserField(lastEditor, (UserField<String>)HDUsersAndGroups.FIELD_LANGUAGE));
        }
        if (visibleUserFieldKeys.contains("computername")) {
            placeholderValues.put("owner.computername", this.getUserField(owner, (UserField<String>)HDUsersAndGroups.FIELD_COMPUTER_NAME));
            placeholderValues.put("creator.computername", this.getUserField(creator, (UserField<String>)HDUsersAndGroups.FIELD_COMPUTER_NAME));
            placeholderValues.put("dispatcher.computername", this.getUserField(dispatcher, (UserField<String>)HDUsersAndGroups.FIELD_COMPUTER_NAME));
            placeholderValues.put("lasteditor.computername", this.getUserField(lastEditor, (UserField<String>)HDUsersAndGroups.FIELD_COMPUTER_NAME));
        }
        if (visibleUserFieldKeys.contains("clientdetails")) {
            placeholderValues.put("owner.clientdetails", this.getUserField(owner, (UserField<String>)HDUsersAndGroups.FIELD_CLIENT_DETAILS));
            placeholderValues.put("creator.clientdetails", this.getUserField(creator, (UserField<String>)HDUsersAndGroups.FIELD_CLIENT_DETAILS));
            placeholderValues.put("dispatcher.clientdetails", this.getUserField(dispatcher, (UserField<String>)HDUsersAndGroups.FIELD_CLIENT_DETAILS));
            placeholderValues.put("lasteditor.clientdetails", this.getUserField(lastEditor, (UserField<String>)HDUsersAndGroups.FIELD_CLIENT_DETAILS));
        }
        if (visibleUserFieldKeys.contains("costcentre")) {
            placeholderValues.put("owner.costcenter", this.getUserField(owner, (UserField<String>)HDUsersAndGroups.FIELD_COST_CENTRE));
            placeholderValues.put("creator.costcenter", this.getUserField(creator, (UserField<String>)HDUsersAndGroups.FIELD_COST_CENTRE));
            placeholderValues.put("dispatcher.costcenter", this.getUserField(dispatcher, (UserField<String>)HDUsersAndGroups.FIELD_COST_CENTRE));
            placeholderValues.put("lasteditor.costcenter", this.getUserField(lastEditor, (UserField<String>)HDUsersAndGroups.FIELD_COST_CENTRE));
        }
        if (visibleUserFieldKeys.contains("note")) {
            placeholderValues.put("owner.note", this.getUserField(owner, (UserField<String>)UsersAndGroups.FIELD_NOTE));
            placeholderValues.put("creator.note", this.getUserField(creator, (UserField<String>)UsersAndGroups.FIELD_NOTE));
            placeholderValues.put("dispatcher.note", this.getUserField(dispatcher, (UserField<String>)UsersAndGroups.FIELD_NOTE));
            placeholderValues.put("lasteditor.note", this.getUserField(lastEditor, (UserField<String>)UsersAndGroups.FIELD_NOTE));
        }
        placeholderValues.put("owner.link", this.getUserLink(owner));
        placeholderValues.put("owner.userclass", this.getUserClass(owner));
        placeholderValues.put("creator.id", creator != null && creator.getID() != null ? creator.getID().toString() : "");
        placeholderValues.put("creator.link", this.getUserLink(creator));
        placeholderValues.put("creator.userclass", this.getUserClass(creator));
        placeholderValues.put("dispatcher.id", dispatcher != null && dispatcher.getID() != null ? dispatcher.getID().toString() : "");
        placeholderValues.put("dispatcher.link", this.getUserLink(dispatcher));
        placeholderValues.put("dispatcher.userclass", this.getUserClass(dispatcher));
        placeholderValues.put("lasteditor.id", lastEditor != null && lastEditor.getID() != null ? lastEditor.getID().toString() : "");
        placeholderValues.put("lasteditor.link", this.getUserLink(lastEditor));
        placeholderValues.put("lasteditor.userclass", this.getUserClass(lastEditor));
        List ticketFieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        ticketFieldDefinitions.forEach(d -> {
            if (!(d instanceof AbstractTicketFieldDefinitionForTicketOwner)) {
                String key = "ticket." + d.getKey();
                Object displayValue = "ticketid".equals(d.getKey()) ? "" + ticket.getID() : d.getDisplayValue(ticket);
                placeholderValues.put(key, (String)displayValue);
                if (HDPlaceholders.IDS_THAT_ARE_ACTUALLY_DISPLAY_NAMES.contains(key)) {
                    placeholderValues.put("ticket." + d.getKey().substring(0, d.getKey().length() - 2) + ".displayname", (String)displayValue);
                }
                if (key.startsWith("ticket.category")) {
                    placeholderValues.put("ticket.category", (String)displayValue);
                } else if (key.startsWith("ticket.classification")) {
                    placeholderValues.put("ticket.classification", (String)displayValue);
                } else if (key.startsWith("ticket.priority")) {
                    placeholderValues.put("ticket.priority", (String)displayValue);
                }
            }
        });
        GUID guid = (GUID)ticket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_TICKET_GUID);
        placeholderValues.put("ticket.guid", guid == null ? "" : guid.toString());
        placeholderValues.put("ticket.link", ticketLink);
        GUID resourceID = ticket.getResourceID();
        String resourceEmail = "";
        if (resourceID != null && (resource = UserGroupManager.getInstance().getGroup(resourceID)) != null) {
            resourceEmail = (String)resource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_EMAIL);
        }
        placeholderValues.put("ticket.resource.email", resourceEmail);
        placeholderValues.put("Ticket ID", ticket.getID() + " ");
        placeholderValues.put("ticket.ticketidlong", Tickets.encodeTicketId((int)ticket.getID()));
        int initialReaStepID = ticket.getInitialReaStepID();
        ReaStepTextVO reaStepText = null;
        try {
            reaStepText = TicketManager.getReader().getReaStepText(initialReaStepID);
        }
        catch (AccessDeniedException e) {
            HDLogger.warn((Object)("Access denied when reading initial ReaStepText " + initialReaStepID + ": " + e.getMessage()));
        }
        if (reaStepText != null) {
            Object inquiryHtml;
            String inquiryPlainText = reaStepText.hasHtmlContent() ? HtmlConverter.html2text((String)reaStepText.getText()) : reaStepText.getText();
            Object object = inquiryHtml = reaStepText.hasHtmlContent() ? reaStepText.getText() : HtmlConverter.text2html((String)reaStepText.getText(), (Font)HDPlaceholders.getDefaultFont());
            if (inquiryHtml != null && !((String)inquiryHtml).toLowerCase().startsWith("<html>")) {
                inquiryHtml = "<html>" + (String)inquiryHtml + "</html>";
            }
            placeholderValues.put("ticket.inquirytext", inquiryPlainText);
            placeholderValues.put("ticket.inquirytext.html", (String)inquiryHtml);
        } else {
            placeholderValues.put("ticket.inquirytext", "");
            placeholderValues.put("ticket.inquirytext.html", "");
        }
        try {
            String reaHistoryHtml = HDPlaceholderUtils.buildReaStepHistoryHtml(ticket);
            placeholderValues.put("ticket.reastephistory", reaHistoryHtml);
        }
        catch (Exception ex) {
            placeholderValues.put("ticket.reastephistory", "");
        }
        List userFieldDefinitions = userFields.get();
        userFieldDefinitions.stream().filter(f -> f.isCustomField() && f.getValueType() == String.class && visibleUserFieldKeys.contains(f.getKey())).forEach(d -> {
            String dispatcherKey = "dispatcher.custom." + d.getKey();
            placeholderValues.put(dispatcherKey, this.getUserField(dispatcher, (UserField<String>)d));
            String ownerKey = "owner.custom." + d.getKey();
            placeholderValues.put(ownerKey, this.getUserField(owner, (UserField<String>)d));
            String creatorKey = "creator.custom." + d.getKey();
            placeholderValues.put(creatorKey, this.getUserField(creator, (UserField<String>)d));
            String lasteditorKey = "lasteditor.custom." + d.getKey();
            placeholderValues.put(lasteditorKey, this.getUserField(lastEditor, (UserField<String>)d));
        });
        return placeholderValues;
    }

    private String getUserClass(UserAccount user) {
        if (user == null) {
            return "";
        }
        Integer userClassID = (Integer)user.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
        UserClassVO userClassVO = (UserClassVO)UserClassManager.getInstance().get(userClassID.intValue());
        return userClassVO == null ? "" : userClassVO.getDisplayValue();
    }

    private String getUserLocation(UserAccount user) {
        if (user == null) {
            return "";
        }
        Integer location = (Integer)user.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
        LocationVO locationVO = (LocationVO)LocationManager.getInstance().get(location.intValue());
        return locationVO == null ? "" : locationVO.getDisplayValue();
    }

    @Nullable
    private UserAccount getDispatcher(TicketVO ticket) {
        Integer dispatchingReaStepID = ticket.getDispatchingReaStepID();
        if (dispatchingReaStepID == null) {
            return null;
        }
        ReaStepVO reaStep = null;
        try {
            reaStep = TicketManager.getReader().getReaStep(dispatchingReaStepID.intValue());
        }
        catch (AccessDeniedException e) {
            HDLogger.warn((Object)("Access denied when reading ReaStep " + dispatchingReaStepID + ": " + e.getMessage()));
            return null;
        }
        if (reaStep == null) {
            return null;
        }
        GUID dispatcher = reaStep.getUserID();
        if (dispatcher == null) {
            return null;
        }
        return UserManager.getInstance().getUserAccount(dispatcher);
    }

    @Nullable
    private UserAccount getLastEditor(TicketVO ticket) {
        GUID lastEditor = (GUID)ticket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_LAST_EDITOR_GUID);
        if (lastEditor == null) {
            return null;
        }
        return UserManager.getInstance().getUserAccount(lastEditor);
    }

    @Nullable
    private UserAccount getOwner(TicketVO ticket) {
        GUID owner = ticket.getOwnerID();
        if (owner == null) {
            return null;
        }
        return UserManager.getInstance().getUserAccount(owner);
    }

    @Nullable
    private UserAccount getCreator(TicketVO ticket) {
        int reaId = ticket.getInitialReaStepID();
        ReaStepVO reaStep = null;
        try {
            reaStep = TicketManager.getReader().getReaStep(reaId);
        }
        catch (AccessDeniedException e) {
            HDLogger.warn((Object)("Access denied when reading ReaStep " + reaId + ": " + e.getMessage()));
            return null;
        }
        if (reaStep == null) {
            return null;
        }
        GUID dispatcher = reaStep.getUserID();
        if (dispatcher == null) {
            return null;
        }
        return UserManager.getInstance().getUserAccount(dispatcher);
    }

    @Nonnull
    private String getUserField(UserAccount account, UserField<String> field) {
        if (account == null) {
            return "";
        }
        return (String)account.getValue(field);
    }

    @Nonnull
    private String getUserDisplayName(UserAccount user) {
        if (user == null) {
            return "";
        }
        return user.getDisplayName();
    }

    @Nonnull
    private String getUserLink(UserAccount user) {
        GUID guid;
        if (user == null) {
            return "";
        }
        String baseURL = (String)EXTERNAL_URL.get();
        if (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        if ((guid = user.getID()) == null) {
            return baseURL;
        }
        return baseURL + "/usersandgroups/user/" + guid.toString();
    }

    @Nonnull
    private String getTicketLink(TicketVO ticket) {
        if (ticket == null) {
            return "";
        }
        String baseURL = (String)EXTERNAL_URL.get();
        if (baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        return baseURL + "/ticketlist/ticket/" + ticket.getID();
    }

    @Nonnull
    public static List<Integer> getTicketIds(String ticketIdString) {
        return Arrays.stream(ticketIdString.trim().split("[ ,;]")).filter(s -> !s.isBlank()).map(Integer::parseInt).collect(Collectors.toList());
    }

    private static String buildReaStepHistoryHtml(@Nonnull TicketVO ticket) {
        List steps = TicketManager.getReader().getReaStepsForTicket(ticket.getID(), BundleStepsFilter.WITH_BUNDLE_STEPS);
        if (steps == null || steps.isEmpty()) {
            return "";
        }
        Font defaultFont = HDPlaceholders.getDefaultFont();
        StringBuilder buffer = new StringBuilder();
        steps.stream().sorted((s1, s2) -> {
            int diff = Long.compare(s1.getEndDate(), s2.getEndDate());
            return diff != 0 ? diff : Integer.compare(s1.getID(), s2.getID());
        }).map(step -> {
            ReaStepTextVO textVO = TicketManager.getReader().getReaStepText(step.getID());
            if (textVO == null) {
                return null;
            }
            String txt = textVO.getText();
            if (txt == null || txt.isEmpty()) {
                return null;
            }
            if (!textVO.hasHtmlContent()) {
                txt = HtmlConverter.text2html((String)txt, (Font)defaultFont, (boolean)true);
            }
            return txt;
        }).filter(Objects::nonNull).forEach(html -> {
            if (buffer.length() > 0) {
                buffer.append("<p><br></p><hr><p><br></p>");
            }
            buffer.append((String)html);
        });
        return HtmlConverter.getCompactHtmlText((String)buffer.toString(), null);
    }
}

