/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner;

import com.inet.classloader.I18nMessages;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.helpdesk.core.data.ConnectionCreationListener;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AdditionalReaStepFieldDefinition;
import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.TicketEventListener;
import com.inet.helpdesk.plugins.forms.server.api.TaskPlannerNotifier;
import com.inet.helpdesk.plugins.taskplanner.server.AdditionalReaStepFieldDefinitionTaskId;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.FormTaskPlannerNotifierImpl;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskTemplateDefinition;
import com.inet.helpdesk.plugins.taskplanner.server.action.AddAttachmentToTicketActionFactory;
import com.inet.helpdesk.plugins.taskplanner.server.action.AddTextToRequestActionFactory;
import com.inet.helpdesk.plugins.taskplanner.server.action.ApplyActionToTicketActionFactory;
import com.inet.helpdesk.plugins.taskplanner.server.action.addticketsharing.AddTicketSharingActionFactory;
import com.inet.helpdesk.plugins.taskplanner.server.action.setticketfield.SetTicketFieldActionFactory;
import com.inet.helpdesk.plugins.taskplanner.server.action.startprocess.StartProcessActionFactory;
import com.inet.helpdesk.plugins.taskplanner.server.job.addattachment.AddAttachmentToTicketJobFactory;
import com.inet.helpdesk.plugins.taskplanner.server.job.addtexttorequestjob.AddTextToRequestJobFactory;
import com.inet.helpdesk.plugins.taskplanner.server.job.changeclassification.ChangeClassificationJobFactory;
import com.inet.helpdesk.plugins.taskplanner.server.job.escalation.SetResourceJobFactory;
import com.inet.helpdesk.plugins.taskplanner.server.job.hdformula.HDFormulaJobFactory;
import com.inet.helpdesk.plugins.taskplanner.server.series.processstarted.ProcessStartedSeriesFactory;
import com.inet.helpdesk.plugins.taskplanner.server.series.targettime.TargetTimePassedSeriesFactory;
import com.inet.helpdesk.plugins.taskplanner.server.series.ticketcreated.TicketCreatedSeriesFactory;
import com.inet.helpdesk.plugins.taskplanner.server.series.ticketswithstatus.TicketsWithStatusSeriesFactory;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.emailreceived.EmailReceivedTriggerFactory;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.formsubmitted.FormsTriggerFactory;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.newticket.NewTicketTriggerFactory;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.processstarted.ProcessStartedTriggerFactory;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.statuschange.StatusChangeTriggerFactory;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.ticketwarning.TicketWarningTriggerFactory;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.toomanytickets.TooManyTicketsTriggerFactory;
import com.inet.helpdesk.plugins.taskplanner.setupwizard.CustomFieldConditionsMigrationSetupStep;
import com.inet.helpdesk.plugins.taskplanner.setupwizard.OnlyMyResourcesMigrationSetupStep;
import com.inet.helpdesk.plugins.taskplanner.setupwizard.ProcessTriggerAndSeriesMigrationToIdSetupStep;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupManager;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.Permission;
import com.inet.plugin.Executable;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.help.HelpPage;
import com.inet.plugin.help.HelpProvider;
import com.inet.plugin.help.HelpProviderImpl;
import com.inet.setupwizard.api.SetupStep;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.field.TaskFieldListGenerator;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobFactory;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.taskplanner.server.api.series.SeriesFactory;
import com.inet.taskplanner.server.api.template.TaskTemplateDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.time.RepeatInterval;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.Type;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

@PluginInfo(id="taskplanner.helpdesk", dependencies="helpdesk;taskplanner;reporting;htmlengine", optionalDependencies="attachments;notification;ticketprocess;setupwizard;inventory;fieldsettings;helpdesk.forms", packages="com.inet.helpdesk.plugins.taskplanner", group="taskplanner;tickets", version="25.10.314", icon="com/inet/helpdesk/plugins/taskplanner/structure/taskplanner_hd_48.png")
public class HelpDeskTaskPlannerServerPlugin
implements ServerPlugin,
ConnectionCreationListener {
    public static final String PROPERTY_TICKET_IDS = "Ticket ID";
    public static final Object TICKET_DATA_CONNECTOR_LOCK = new Object();
    private static final String KEY_SET_CLASSIFICATION_WHEN_TICKET_STATUS = "KEY_SET_CLASSIFICATION_WHEN_TICKET_STATUS";
    private static final String KEY_ADD_ATTACHMENT_TO_TICKET = "KEY_ADD_ATTACHMENT_TO_TICKET";
    private static final String KEY_ADDTEXT_TO_REQUEST = "KEY_ADDTEXT_TO_REQUEST";
    private static final String KEY_HD_NOTIFICATION = "KEY_HD_NOTIFICATION";
    private static final String KEY_ADD_ATTACHMENT_TO_PROCESS_STARTED = "KEY_ADD_ATTACHMENT_TO_PROCESS_STARTED";
    private static final String KEY_SET_TICKET_FIELD = "KEY_SET_TICKET_FIELD";
    private static final String KEY_SET_CLASSIFICATION_WHEN_TARGET_TIME_PASSED = "KEY_SET_CLASSIFICATION_WHEN_TARGET_TIME_PASSED";
    private static final String KEY_SEND_MAIL_WITH_CONTENT = "KEY_SEND_MAIL_WITH_CONTENT";
    private static final String KEY_SET_SUBJECT_PREFIX = "KEY_SET_SUBJECT_PREFIX";
    private static final String KEY_START_PROCESS_WHEN_PRIO_SET_TO_HIGHEST = "KEY_START_PROCESS_WHEN_PRIO_SET_TO_HIGHEST";
    private HDTaskPlannerDataListener triggerTicketDataChangeListener;
    public static final I18nMessages MSG = new I18nMessages("com.inet.helpdesk.plugins.taskplanner.i18n.LanguageResources", HelpDeskTaskPlannerServerPlugin.class);
    public static final I18nMessages MSG_CLIENT = new I18nMessages("com.inet.helpdesk.plugins.taskplanner.client.i18n.LanguageResources", HelpDeskTaskPlannerServerPlugin.class);

    public void registerHelp(HelpProviderContainer container) {
        container.add((HelpProvider)new HelpProviderImpl("taskplanner", 9161, true, new Permission[]{TaskPlanner.PERMISSION_TASKPLANNER}){

            public boolean isVisible(@Nonnull HelpPage helpPage) {
                if (super.isVisible(helpPage)) {
                    UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
                    if (currentUserAccount == null || !HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount)) {
                        return false;
                    }
                    ServerPluginManager spm = ServerPluginManager.getInstance();
                    if (helpPage.getKey().contains("ticketprocess")) {
                        return spm.isPluginLoaded("ticketprocess");
                    }
                    return true;
                }
                return false;
            }
        }, new String[]{"taskplanner"});
    }

    public void registerExtension(final ServerPluginManager spm) {
        spm.register(TaskFieldListGenerator.class, (Object)new FilterableFieldListGenerator());
        spm.register(TriggerFactory.class, (Object)new NewTicketTriggerFactory());
        spm.register(TriggerFactory.class, (Object)new TooManyTicketsTriggerFactory());
        StatusChangeTriggerFactory statusChangeTriggerFactory = new StatusChangeTriggerFactory();
        spm.register(TriggerFactory.class, (Object)statusChangeTriggerFactory);
        spm.register(TriggerFactory.class, (Object)new EmailReceivedTriggerFactory());
        spm.register(TriggerFactory.class, (Object)new TicketWarningTriggerFactory());
        spm.register(SeriesFactory.class, (Object)new TicketCreatedSeriesFactory());
        spm.register(SeriesFactory.class, (Object)new TargetTimePassedSeriesFactory());
        spm.register(SeriesFactory.class, (Object)new TicketsWithStatusSeriesFactory());
        spm.register(ResultActionFactory.class, (Object)new SetTicketFieldActionFactory());
        spm.register(ResultActionFactory.class, (Object)new ApplyActionToTicketActionFactory());
        spm.register(ResultActionFactory.class, (Object)new AddTextToRequestActionFactory());
        spm.runIfPluginLoaded("usersandgroupsmanager", () -> new Executable(){

            public void execute() {
                spm.register(ResultActionFactory.class, (Object)new AddTicketSharingActionFactory());
                FileCombiner.CombinedFile combinedFile = new FileCombiner.CombinedFile("application/x-javascript; charset=utf-8", new URL[0]);
                combinedFile.add(((Object)((Object)this)).getClass(), "/com/inet/helpdesk/plugins/taskplanner/structure/addticketsharing_taskplanner.js");
                combinedFile.addMessages(MSG_CLIENT);
                spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("remotegui", 100, "taskplanner.extras.js", combinedFile));
            }
        });
        this.triggerTicketDataChangeListener = new HDTaskPlannerDataListener();
        spm.register(TicketEventListener.class, (Object)this.triggerTicketDataChangeListener);
        spm.register(TicketActionExtensionFactory.class, (Object)this.triggerTicketDataChangeListener);
        spm.register(ConnectionCreationListener.class, (Object)this);
        spm.register(JobFactory.class, (Object)new AddTextToRequestJobFactory());
        spm.register(JobFactory.class, (Object)new ChangeClassificationJobFactory());
        spm.register(JobFactory.class, (Object)new SetResourceJobFactory());
        spm.register(JobFactory.class, (Object)new HDFormulaJobFactory());
        spm.register(AdditionalReaStepFieldDefinition.class, (Object)new AdditionalReaStepFieldDefinitionTaskId());
        spm.runIfPluginLoaded("ticketprocess", () -> new Executable(){

            public void execute() {
                ProcessStartedTriggerFactory processTriggerFactory = new ProcessStartedTriggerFactory();
                spm.register(TriggerFactory.class, (Object)processTriggerFactory);
                spm.register(TicketActionExtensionFactory.class, (Object)processTriggerFactory);
                spm.register(SeriesFactory.class, (Object)new ProcessStartedSeriesFactory());
                spm.register(ResultActionFactory.class, (Object)new StartProcessActionFactory());
                if (spm.isPluginLoaded("attachments")) {
                    HelpDeskTaskPlannerServerPlugin.this.registerProcessTemplate(spm);
                }
            }
        });
        this.registerTimePassedTemplate(spm);
        this.registerAddAutoTextTemplate(spm);
        this.registerTicketStatusTemplate(spm);
        this.registerSetTicketFieldTemplate(spm);
        this.registerSetSubjectPrefixTemplate(spm);
        this.registerStartProcessWhenPrioritySetToHighestTemplate(spm);
        spm.runIfPluginLoaded("attachments", () -> new Executable(){

            public void execute() {
                HelpDeskTaskPlannerServerPlugin.this.registerAddAttachmentToTicket(spm);
                spm.register(JobFactory.class, (Object)new AddAttachmentToTicketJobFactory());
                spm.register(ResultActionFactory.class, (Object)new AddAttachmentToTicketActionFactory());
            }
        });
        spm.runIfPluginLoaded("notification", () -> new Executable(){

            public void execute() {
                HelpDeskTaskPlannerServerPlugin.this.registerHDNotificationTemplates(spm);
            }
        });
        if (spm.isPluginLoaded("attachments") && spm.isPluginLoaded("taskplanner.reporting")) {
            spm.runIfPluginLoaded("drive", () -> new Executable(){

                public void execute() {
                    HelpDeskTaskPlannerServerPlugin.this.registerSendMessageWithAttachment(spm);
                }
            });
        }
        spm.runIfPluginLoaded("setupwizard", () -> new Executable(){

            public void execute() {
                spm.register(SetupStep.class, (Object)new OnlyMyResourcesMigrationSetupStep());
                spm.register(SetupStep.class, (Object)new CustomFieldConditionsMigrationSetupStep());
                spm.runIfPluginLoaded("ticketprocess", () -> new Executable(){

                    public void execute() {
                        spm.register(SetupStep.class, (Object)new ProcessTriggerAndSeriesMigrationToIdSetupStep());
                    }
                });
            }
        });
        spm.runIfPluginLoaded("helpdesk.forms", () -> new Executable(){

            public void execute() {
                spm.register(TaskPlannerNotifier.class, (Object)new FormTaskPlannerNotifierImpl());
                spm.register(TriggerFactory.class, (Object)new FormsTriggerFactory());
            }
        });
    }

    private void registerTicketStatusTemplate(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_hdticketstatustemplate");
        HashMap<String, String> triggerProps = new HashMap<String, String>();
        triggerProps.put("statusFilter", "200");
        triggerProps.put("FilterType", "FilterTypeNone");
        TriggerDefinition wTrigger = new TriggerDefinition("trigger.helpdesk.statuschange", triggerProps);
        taskDesc.addTrigger(wTrigger);
        HashMap<String, String> jobProps = new HashMap<String, String>();
        jobProps.put(PROPERTY_TICKET_IDS, "{Ticket ID}");
        jobProps.put(Tickets.FIELD_CLASSIFICATION_ID.getKey(), "0");
        JobDefinition jobDefinition = new JobDefinition("taskplanner.helpdesk.change-classification", jobProps);
        taskDesc.addJob(jobDefinition);
        ArrayList<String> keysToLocalize = new ArrayList<String>();
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_SET_CLASSIFICATION_WHEN_TICKET_STATUS, MSG, "Template.TicketStatus", "Template.TicketStatus.desc", taskDesc, keysToLocalize);
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerProcessTemplate(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_hdprocessstarted");
        TriggerDefinition processTrigger = new TriggerDefinition("trigger.helpdesk.processstarted");
        taskDesc.addTrigger(processTrigger);
        HashMap<String, String> jobProps = new HashMap<String, String>();
        jobProps.put(PROPERTY_TICKET_IDS, "{Ticket ID}");
        jobProps.put("FilterType", "FilterTypeNone");
        JobDefinition jobDefinition = new JobDefinition("taskplanner.helpdesk.addattachmenttoticket", jobProps);
        taskDesc.addJob(jobDefinition);
        ArrayList<String> keysToLocalize = new ArrayList<String>();
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_ADD_ATTACHMENT_TO_PROCESS_STARTED, MSG, "Template.AddAttachmentToProcessStarted", "Template.AddAttachmentToProcessStarted.desc", taskDesc, keysToLocalize);
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerSetTicketFieldTemplate(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_hdsetticketfield");
        TriggerDefinition newTicketTrigger = new TriggerDefinition("taskplanner.helpdesk");
        newTicketTrigger.setProperty("FilterType", "FilterTypeNone");
        taskDesc.addTrigger(newTicketTrigger);
        HashMap<String, String> actionProps = new HashMap<String, String>();
        actionProps.put(PROPERTY_TICKET_IDS, "{Ticket ID}");
        actionProps.put("fieldToChange", "custom6");
        actionProps.put("textFieldValueToSet", "SetTicketFieldTemplate.CreatedBy");
        ResultActionDefinition actionDefinition = new ResultActionDefinition("result.setticketfield", actionProps);
        taskDesc.addResultAction(actionDefinition);
        ArrayList<String> keysToLocalize = new ArrayList<String>();
        keysToLocalize.add("textFieldValueToSet");
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_SET_TICKET_FIELD, MSG, "Template.SetTicketField", "Template.SetTicketField.desc", taskDesc, keysToLocalize);
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerSetSubjectPrefixTemplate(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_hdsetpriority");
        TriggerDefinition newTicketTrigger = new TriggerDefinition("taskplanner.helpdesk");
        newTicketTrigger.setProperty("FilterType", Tickets.FIELD_PRIORITY_ID.getKey());
        taskDesc.addTrigger(newTicketTrigger);
        HashMap<String, String> actionProps = new HashMap<String, String>();
        actionProps.put(PROPERTY_TICKET_IDS, "{Ticket ID}");
        actionProps.put("fieldToChange", Tickets.FIELD_SUBJECT.getKey());
        actionProps.put("textFieldValueToSet", "SetSubjectPrefixTemplate.Subject");
        ResultActionDefinition actionDefinition = new ResultActionDefinition("result.setticketfield", actionProps);
        taskDesc.addResultAction(actionDefinition);
        ArrayList<String> keysToLocalize = new ArrayList<String>();
        keysToLocalize.add("textFieldValueToSet");
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_SET_SUBJECT_PREFIX, MSG, "Template.SetSubjectPrefix", "Template.SetSubjectPrefix.desc", taskDesc, keysToLocalize);
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerStartProcessWhenPrioritySetToHighestTemplate(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_hdstartprocesswhenpriohighest");
        TriggerDefinition newTicketTrigger = new TriggerDefinition("trigger.helpdesk.statuschange");
        newTicketTrigger.setProperty("PROPERTY_WHEN_TO_TRIGGER", "WHEN_TO_TRIGGER_ON_FIELD_CHANGE");
        newTicketTrigger.setProperty("FilterType", Tickets.FIELD_PRIORITY_ID.getKey());
        taskDesc.addTrigger(newTicketTrigger);
        HashMap<String, String> actionProps = new HashMap<String, String>();
        actionProps.put(PROPERTY_TICKET_IDS, "{Ticket ID}");
        ResultActionDefinition actionDefinition = new ResultActionDefinition("taskplanner.helpdesk.startprocess", actionProps);
        taskDesc.addResultAction(actionDefinition);
        ArrayList<String> keysToLocalize = new ArrayList<String>();
        keysToLocalize.add("textFieldValueToSet");
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_START_PROCESS_WHEN_PRIO_SET_TO_HIGHEST, MSG, "Template.StartProcessWhenPrioSetToHighest", "Template.StartProcessWhenPrioSetToHighest.desc", taskDesc, keysToLocalize);
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerTimePassedTemplate(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_hdtimepassed");
        TriggerDefinition timeTrigger = new TriggerDefinition("trigger.time");
        timeTrigger.setProperty("repeat.select", RepeatInterval.DAILY.name());
        ZonedDateTime dest = ZonedDateTime.now().withHour(8).withMinute(0);
        timeTrigger.setProperty("start.time", "" + dest.toEpochSecond() * 1000L);
        timeTrigger.setProperty("start.day", "" + dest.toEpochSecond() * 1000L);
        taskDesc.addTrigger(timeTrigger);
        HashMap seriesProps = new HashMap();
        SeriesDefinition series = new SeriesDefinition("series.helpdesk.target-time-passed", seriesProps);
        taskDesc.setSeries(series);
        HashMap<String, String> jobProps = new HashMap<String, String>();
        jobProps.put(PROPERTY_TICKET_IDS, "{Ticket ID}");
        jobProps.put(Tickets.FIELD_CLASSIFICATION_ID.getKey(), "0");
        JobDefinition jobDefinition = new JobDefinition("taskplanner.helpdesk.change-classification", jobProps);
        taskDesc.addJob(jobDefinition);
        ArrayList<String> keysToLocalize = new ArrayList<String>();
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_SET_CLASSIFICATION_WHEN_TARGET_TIME_PASSED, MSG, "Template.TargetTimePassed", "Template.TargetTimePassed.desc", taskDesc, keysToLocalize);
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerHDNotificationTemplates(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_hdnotification");
        TriggerDefinition timeTrigger = new TriggerDefinition("trigger.time");
        timeTrigger.setProperty("repeat.select", RepeatInterval.DAILY.name());
        ZonedDateTime dest = ZonedDateTime.now().withHour(8).withMinute(0);
        timeTrigger.setProperty("start.time", "" + dest.toEpochSecond() * 1000L);
        timeTrigger.setProperty("start.day", "" + dest.toEpochSecond() * 1000L);
        taskDesc.addTrigger(timeTrigger);
        HashMap<String, String> actionProps = new HashMap<String, String>();
        actionProps.put("notificationTitle", "NotificationTemplate.title");
        actionProps.put("notificationMessage", "NotificationTemplate.message");
        ResultActionDefinition actionDefinition = new ResultActionDefinition("result.notification", actionProps);
        taskDesc.addResultAction(actionDefinition);
        ArrayList<String> keysToLocalize = new ArrayList<String>();
        keysToLocalize.add("notificationTitle");
        keysToLocalize.add("notificationMessage");
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_HD_NOTIFICATION, MSG, "Template.HDNotification", "Template.HDNotification.desc", taskDesc, keysToLocalize);
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerAddAttachmentToTicket(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_addattachment");
        TriggerDefinition newTicketTrigger = new TriggerDefinition("taskplanner.helpdesk");
        newTicketTrigger.setProperty("FilterType", "FilterTypeNone");
        taskDesc.addTrigger(newTicketTrigger);
        HashMap<String, String> jobProps = new HashMap<String, String>();
        jobProps.put(PROPERTY_TICKET_IDS, "{Ticket ID}");
        jobProps.put("FilterType", "FilterTypeNone");
        JobDefinition jobDefinition = new JobDefinition("taskplanner.helpdesk.addattachmenttoticket", jobProps);
        taskDesc.addJob(jobDefinition);
        ArrayList<String> keysToLocalize = new ArrayList<String>();
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_ADD_ATTACHMENT_TO_TICKET, MSG, "Template.AddAttachmentToTicket", "Template.AddAttachmentToTicket.desc", taskDesc, keysToLocalize);
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerAddAutoTextTemplate(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_addautotext");
        TriggerDefinition newTicketTrigger = new TriggerDefinition("taskplanner.helpdesk");
        newTicketTrigger.setProperty("FilterType", "FilterTypeNone");
        taskDesc.addTrigger(newTicketTrigger);
        HashMap<String, String> jobProps = new HashMap<String, String>();
        jobProps.put(PROPERTY_TICKET_IDS, "{Ticket ID}");
        jobProps.put("FilterType", "FilterTypeNone");
        jobProps.put("AutoTextPrefix", "AddAutoTextPrefixLabel.default");
        JobDefinition jobDefinition = new JobDefinition("taskplanner.helpdesk.addtexttorequest", jobProps);
        taskDesc.addJob(jobDefinition);
        ArrayList<String> keysToLocalize = new ArrayList<String>();
        keysToLocalize.add("AutoTextPrefix");
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_ADDTEXT_TO_REQUEST, MSG, "Template.AddTextToRequest", "Template.AddTextToRequest.desc", taskDesc, keysToLocalize);
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    private void registerSendMessageWithAttachment(ServerPluginManager spm) {
        TaskDefinition taskDesc = new TaskDefinition("_sendmailwithcontent");
        TriggerDefinition finishTrigger = new TriggerDefinition("trigger.helpdesk.statuschange");
        finishTrigger.setProperty("statusFilter", "300");
        finishTrigger.setProperty("FilterType", "FilterTypeNone");
        finishTrigger.setProperty("onlymyresources", "false");
        taskDesc.addTrigger(finishTrigger);
        HashMap<String, String> jobPropsMailContent = new HashMap<String, String>();
        jobPropsMailContent.put("reports", "drive:/Abrechnungen/Rechnung/MailInhalt.rpt");
        jobPropsMailContent.put("prompts", "[{\"key\":\"Auftragsnummer\",\"displayName\":\"Auftragsnummer\",\"value\":\"{Ticket ID}\",\"type\":6}]");
        jobPropsMailContent.put("export_fmt", "email");
        jobPropsMailContent.put("formula", "{@Empfaenger}");
        jobPropsMailContent.put("report.title", "Wie es euch beliebt");
        JobDefinition jobDefinitionMailContent = new JobDefinition("report", jobPropsMailContent);
        taskDesc.addJob(jobDefinitionMailContent);
        HashMap<String, String> jobPropsMailAttachment = new HashMap<String, String>();
        jobPropsMailAttachment.put("reports", "drive:/Abrechnungen/Rechnung/Rechnung.rpt");
        jobPropsMailAttachment.put("prompts", "[{\"key\":\"AufNr\",\"displayName\":\"AufNr\",\"value\":\"{Ticket ID}\",\"type\":6}]");
        jobPropsMailAttachment.put("export_fmt", "pdf");
        jobPropsMailAttachment.put("report.title", "Abrechnung");
        JobDefinition jobDefinitionMailAttachment = new JobDefinition("report", jobPropsMailAttachment);
        taskDesc.addJob(jobDefinitionMailAttachment);
        HashMap<String, String> actionPropsMail = new HashMap<String, String>();
        actionPropsMail.put("prop_message", "[jobresult]");
        actionPropsMail.put("prop_subject", "Ticket {Ticket ID}");
        actionPropsMail.put("prop_receiver", "[report.formula]");
        actionPropsMail.put("filenameformat", "[filename]");
        actionPropsMail.put("prop_attach_files", "true");
        ResultActionDefinition actionDefinitionMail = new ResultActionDefinition("result.email", actionPropsMail);
        taskDesc.addResultAction(actionDefinitionMail);
        HashMap<String, String> actionPropsAttach = new HashMap<String, String>();
        actionPropsAttach.put(PROPERTY_TICKET_IDS, "{Ticket ID}");
        ResultActionDefinition actionDefinitionAttach = new ResultActionDefinition("result.addattachment", actionPropsAttach);
        taskDesc.addResultAction(actionDefinitionAttach);
        ArrayList keysToLocalize = new ArrayList();
        HDTaskTemplateDefinition taskTemplateDesc = new HDTaskTemplateDefinition(KEY_SEND_MAIL_WITH_CONTENT, MSG, "Template.TicketMailWithContent", "Template.TicketMailWithContent.desc", taskDesc, keysToLocalize){

            @Override
            public boolean isAvailable() {
                JobFactory j = ServerPluginManager.getInstance().get(JobFactory.class).stream().filter(f -> "report".equals(f.getExtensionName())).findFirst().orElse(null);
                return super.isAvailable() && j != null && j.isAvailable();
            }
        };
        spm.register(TaskTemplateDefinition.class, (Object)taskTemplateDesc);
    }

    public void init(ServerPluginManager spm) {
    }

    public void reset() {
    }

    public void restart() {
    }

    public void connectionCreated() {
        this.triggerTicketDataChangeListener.init();
        this.performPostInitTemplateChanges();
    }

    private void performPostInitTemplateChanges() {
        UserGroupManager groupManager = HelpDeskUserGroupManager.getInstance();
        List templates = ServerPluginManager.getInstance().get(TaskTemplateDefinition.class);
        for (TaskTemplateDefinition t : templates) {
            int prioId;
            List prios;
            List triggers;
            if (t.getKey().equals(KEY_HD_NOTIFICATION)) {
                List resultActions = t.getTaskDefinition().getResultActions();
                if (resultActions.size() != 1) continue;
                ResultActionDefinition actionDefinition = (ResultActionDefinition)resultActions.get(0);
                UserGroupInfo all = groupManager.getGroup(UsersAndGroups.GROUP_ALLUSERS);
                HashMap<Type, HashSet<GUID>> receivers = new HashMap<Type, HashSet<GUID>>();
                receivers.put(Type.group, new HashSet<GUID>(Arrays.asList(all.getID())));
                String json = new Json().toJson(receivers);
                actionDefinition.getProperties().put("notificationReceiver", json);
                break;
            }
            if (t.getKey().equals(KEY_SET_SUBJECT_PREFIX)) {
                triggers = t.getTaskDefinition().getTriggers();
                for (TriggerDefinition tDef : triggers) {
                    prios = PriorityManager.getInstance().getAll(true);
                    prios.sort(Comparator.comparingInt(FieldVO::getId));
                    prioId = ((PriorityVO)prios.get(prios.size() - 1)).getId();
                    tDef.getProperties().put(Tickets.FIELD_PRIORITY_ID.getKey(), "" + prioId);
                    tDef.getProperties().put(Tickets.FIELD_PRIORITY_ID.getKey() + ".display", ((PriorityVO)prios.get(prios.size() - 1)).getDisplayValue());
                }
                continue;
            }
            if (!t.getKey().equals(KEY_START_PROCESS_WHEN_PRIO_SET_TO_HIGHEST)) continue;
            triggers = t.getTaskDefinition().getTriggers();
            for (TriggerDefinition tDef : triggers) {
                prios = PriorityManager.getInstance().getAll(true);
                prios.sort(Comparator.comparingInt(FieldVO::getId));
                prioId = ((PriorityVO)prios.get(prios.size() - 1)).getId();
                tDef.getProperties().put(Tickets.FIELD_PRIORITY_ID.getKey(), "" + prioId);
                tDef.getProperties().put(Tickets.FIELD_PRIORITY_ID.getKey() + ".display", ((PriorityVO)prios.get(prios.size() - 1)).getDisplayValue());
            }
        }
    }
}

