/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action.startprocess;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerUtils;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.action.ResultAction;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.error.TaskPlannerCodes;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class StartProcessAction
extends ResultAction {
    private final List<Integer> ticketIds;
    private final String processID;
    private GUID taskID;

    public StartProcessAction(Map<String, String> properties, @Nullable GUID taskID) {
        this.taskID = taskID;
        this.ticketIds = HDPlaceholderUtils.getTicketIds(properties.get("Ticket ID"));
        this.processID = properties.get("processToStart");
    }

    protected void handle(List<JobResultContainer> results) throws TaskExecutionException {
        this.setProgress(0);
        ArrayList<Exception> toThrow = new ArrayList<Exception>();
        for (Integer ticketId : this.ticketIds) {
            try {
                WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)this.taskID);
                try {
                    TicketProcessManager ticketProcessManager = this.getTicketProcessManager();
                    TicketProcess process = ticketProcessManager.getProcess(GUID.valueOf((String)this.processID));
                    ActionVO startProcess = this.getStartProcessAction();
                    ExtensionArguments args = ExtensionArguments.create();
                    args.put(TicketProcessManager.EXT_ARG_PROCESS_TO_START, (Object)process.toActiveProcessWithoutModifications());
                    MutableReaStepData reaStepData = new MutableReaStepData();
                    reaStepData.put((ReaStepField)ReaStepVO.FIELD_PROCESSING_TIME, (Object)ProcessingTime.ofEffort((int)0));
                    this.getTicketManipulator().applyAction(Integer.valueOf(ticketId).intValue(), reaStepData, ReaStepTextVO.empty(), startProcess, args);
                }
                finally {
                    if (addReaStepData == null) continue;
                    addReaStepData.close();
                }
            }
            catch (Exception e) {
                toThrow.add((Exception)new TaskExecutionException((Throwable)e, (ErrorCode)TaskPlannerCodes.GenericExecutionError));
            }
        }
        if (toThrow.size() > 0) {
            throw HDTaskPlannerUtils.combinedException(toThrow);
        }
        this.setProgress(100);
    }

    protected ActionVO getStartProcessAction() {
        return (ActionVO)ActionManager.getInstance().get(-19);
    }

    protected TicketManipulator getTicketManipulator() {
        return TicketManager.getManipulator();
    }

    protected TicketProcessManager getTicketProcessManager() {
        return (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
    }
}

