/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.action;

import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.action.AddAttachmentToTicketAction;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.action.ResultActionDefinition;
import com.inet.taskplanner.server.api.action.ResultActionFactory;
import com.inet.taskplanner.server.api.action.ResultActionInfo;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.result.ResultFlavor;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AddAttachmentToTicketActionFactory
extends ResultActionFactory<AddAttachmentToTicketAction> {
    public static final String EXTENSION_NAME = "result.addattachment";

    public AddAttachmentToTicketActionFactory() {
        super(EXTENSION_NAME);
    }

    public List<ResultFlavor> getSupportedFlavors(ResultActionDefinition definition) {
        return Arrays.asList(ResultFlavor.FILE);
    }

    public ResultActionInfo getInformation(@Nullable GUID taskID) {
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAsAttachmentCategory", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddAsAttachmentCategoryDesc", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/addattachment_32.png");
        String helpKey = "taskplanner.action.add-as-attachment-to-ticket";
        ArrayList<TextField> fields = new ArrayList<TextField>();
        TextField textField = new TextField("Ticket ID", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketIDLabel", new Object[0]));
        HDPlaceholders.setPlaceholderDynamicallyForTextFieldInAction(taskID, textField);
        fields.add(textField);
        return new ResultActionInfo(this.getExtensionName(), name, description, iconURL, helpKey, fields);
    }

    protected void validate(@Nonnull ResultActionDefinition definition, @Nullable GUID taskID) throws ValidationException {
    }

    public SummaryInfo getSummary(@Nonnull ResultActionDefinition definition) {
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String ticketId = definition.getProperty("Ticket ID");
        summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("AddResultingFilesAsAttachmentsTo", new Object[0]), "Ticket #" + ticketId));
        return new SummaryInfo(summary);
    }

    protected AddAttachmentToTicketAction createInstanceFrom(ResultActionDefinition definition, GUID taskID) {
        String ticketId = definition.getProperty("Ticket ID");
        if (ticketId != null && ticketId.contains("Ticket ID")) {
            throw new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketIDPlaceholder", new Object[0]));
        }
        return new AddAttachmentToTicketAction(HDPlaceholderUtils.getTicketIds(ticketId), taskID);
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }
}

