/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server;

import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.TicketTextFunctions;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketPermissionChecker;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupManager;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.takeout.TakeoutDataRenderer;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TicketFilterChecker {
    private TicketFilterCondition first;
    private String andOrNoneProp;
    private TicketFilterCondition second;

    public TicketFilterChecker(Map<String, String> properties) {
        this.first = new TicketFilterCondition(true, properties);
        this.andOrNoneProp = properties.getOrDefault("SecondFilterAndOrNone", "SecondFilterNone");
        if (!this.andOrNoneProp.equals("SecondFilterNone")) {
            this.second = new TicketFilterCondition(false, properties);
        }
    }

    public boolean check(ServerValuesConnector svc, TicketVO ticket, UserAccount user) {
        boolean firstCheck = this.first.check(svc, ticket, user);
        if ("FilterTypeNone".equals(this.first.filterType)) {
            return true;
        }
        if (this.second != null && !"SecondFilterNone".equals(this.andOrNoneProp)) {
            boolean secondCheck = this.second.check(svc, ticket, user, true);
            if (this.andOrNoneProp.equals("SecondFilterAnd")) {
                return firstCheck && secondCheck;
            }
            return firstCheck || secondCheck;
        }
        return firstCheck;
    }

    public static ZonedDateTime calculatePeriodAgo(ZonedDateTime now, String datePeriod) {
        if (datePeriod == null || datePeriod.isBlank()) {
            throw new IllegalArgumentException("invalid date period");
        }
        switch (datePeriod) {
            case "1": {
                return now.minusWeeks(1L);
            }
            case "2": {
                return now.minusWeeks(2L);
            }
            case "3": {
                return now.minusWeeks(3L);
            }
            case "4": {
                return now.minusWeeks(4L);
            }
            case "5": {
                return now.minusWeeks(5L);
            }
            case "6": {
                return now.minusWeeks(6L);
            }
            case "7": {
                return now.minusWeeks(7L);
            }
            case "8": {
                return now.minusWeeks(8L);
            }
            case "3months": {
                return now.minusMonths(3L);
            }
            case "6months": {
                return now.minusMonths(6L);
            }
            case "1year": {
                return now.minusYears(1L);
            }
            case "3years": {
                return now.minusYears(3L);
            }
        }
        throw new IllegalArgumentException("invalid date period");
    }

    private static class TicketFilterCondition {
        private String filterType;
        private GUID resId;
        private boolean includeSubResources;
        private boolean onlymyresources;
        private boolean noresource;
        private Integer locationId;
        private String categoryId;
        private boolean includeSubCategories;
        private String inquiryText;
        private String ownerFieldKey;
        private String ownerValue;
        private String ownerDateValue;
        private String processFilterType;
        private String specificProcessId;
        private String specificActivityId;
        private String dynamicValue;
        private String dynamicValue2;
        private String dynamicOperator;
        private String dynamicOperator2;
        private String lastModifiedWeeks;
        private String createdWeeks;
        private String readStatusValue;
        private Map<String, String> properties;
        static TicketProcessManager tpmInstance;

        private TicketFilterCondition(boolean first, Map<String, String> properties) {
            this.properties = properties;
            String propPrefix = first ? "" : "Second.";
            String resIdString = properties.getOrDefault(propPrefix + "Resource", properties.getOrDefault(propPrefix + "Resource.noCustomEntry", "-1"));
            resIdString = resIdString == null ? "-1" : resIdString;
            String locationIdString = properties.getOrDefault(propPrefix + "CustomerLocation", "-1");
            locationIdString = locationIdString == null ? "-1" : locationIdString;
            this.inquiryText = properties.getOrDefault(propPrefix + "InquiryText", "");
            this.categoryId = properties.get(propPrefix + "Category");
            this.locationId = Integer.valueOf(locationIdString);
            this.filterType = properties.getOrDefault(propPrefix + "FilterType", "");
            if (this.filterType == null) {
                HDLogger.error((Object)"filter type is null which is not supported => will not trigger");
                HDLogger.debug((Object)("for task with the following props: " + new Json().toJson(properties)));
                this.filterType = "";
            }
            List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
            Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
            for (TicketFieldDefinition d : fieldDefs) {
                if (d.getFieldKey() == null || !d.getFieldKey().equals(this.filterType)) continue;
                String dynamicValue = properties.getOrDefault("fflg." + propPrefix + d.getFieldKey(), "");
                if (first) {
                    this.dynamicValue = dynamicValue;
                    this.dynamicOperator = properties.getOrDefault("fflg." + propPrefix + d.getFieldKey() + ".prebox", "numberprebox.equal");
                    continue;
                }
                this.dynamicValue2 = dynamicValue;
                this.dynamicOperator2 = properties.getOrDefault("fflg." + propPrefix + d.getFieldKey() + ".prebox", "numberprebox.equal");
            }
            if (this.filterType.equals("FilterTypeResource")) {
                if (resIdString.equals("OnlyMyResourcesDataEntryId")) {
                    this.onlymyresources = true;
                } else if (resIdString.equals("NoResourceDataEntryId")) {
                    this.noresource = true;
                } else {
                    this.resId = HDUsersAndGroups.getResourceGroupUUID((int)Integer.valueOf(resIdString));
                }
            }
            this.includeSubCategories = "true".equals(properties.get(propPrefix + "IncludeSubcategories"));
            this.includeSubResources = "true".equals(properties.get(propPrefix + "IncludeSubresources"));
            this.ownerFieldKey = properties.getOrDefault(propPrefix + "OwnerField", "");
            this.ownerValue = properties.getOrDefault(propPrefix + "OwnerFieldValue", "");
            this.ownerDateValue = properties.getOrDefault(propPrefix + "OwnerFieldDateValue", "");
            this.processFilterType = properties.getOrDefault(propPrefix + "FilterTypeProcessFilter", "");
            this.specificProcessId = properties.getOrDefault(propPrefix + "PropProcess", "");
            this.specificActivityId = properties.getOrDefault(propPrefix + "." + this.specificProcessId + ".PropActivity", "");
            this.lastModifiedWeeks = properties.getOrDefault(propPrefix + "LastModifiedDateValue", "");
            this.createdWeeks = properties.getOrDefault(propPrefix + "CreatedDateValue", "");
            this.readStatusValue = properties.getOrDefault(propPrefix + "ReadStatusValue", "");
        }

        private boolean check(ServerValuesConnector svc, TicketVO ticket, UserAccount user) {
            return this.check(svc, ticket, user, false);
        }

        private boolean check(ServerValuesConnector svc, TicketVO ticket, UserAccount user, boolean isSecondFilter) {
            if (ticket == null) {
                return false;
            }
            if (this.onlymyresources) {
                Set resourceIds = HelpDeskUserGroupManager.getInstance().getGroupsForUserIncludingDeactivated(user.getID()).stream().filter(g -> g.getType() == HDUsersAndGroups.RESOURCE).map(UserGroupInfo::getID).collect(Collectors.toSet());
                GUID resId = (GUID)ticket.getValue((TicketField)Tickets.FIELD_RESOURCE_GUID);
                if (resId == null) {
                    return false;
                }
                HelpDeskUserGroupManager ugm = (HelpDeskUserGroupManager)HelpDeskUserGroupManager.getInstance();
                UserGroupInfo resInfo = ugm.getGroup(resId);
                if (resInfo == null) {
                    return false;
                }
                if (!resourceIds.contains(resInfo.getID())) {
                    return false;
                }
                if ("FilterTypeResource".equals(this.filterType)) {
                    return true;
                }
            } else if (this.noresource) {
                GUID resId = (GUID)ticket.getValue((TicketField)Tickets.FIELD_RESOURCE_GUID);
                return resId == null;
            }
            if (this.filterType == null) {
                HDLogger.error((Object)"filter type is null which is not supported => will not trigger");
                HDLogger.debug((Object)("when checking for ticket " + ticket.getID() + " - is the problem the second filter? " + (isSecondFilter ? "yes" : "no")));
                return false;
            }
            switch (this.filterType) {
                case "FilterTypeCategory": {
                    CategoryVO categoryVO;
                    Integer ticketCategoryKey = ticket.getCategoryID();
                    String ticketCategory = "";
                    if (ticketCategoryKey != null && (categoryVO = (CategoryVO)CategoryManager.getInstance().get(ticketCategoryKey.intValue())) != null) {
                        ticketCategory = categoryVO.getPath();
                    }
                    Integer catId = Integer.valueOf(this.categoryId);
                    CategoryVO categoryVO2 = (CategoryVO)CategoryManager.getInstance().get(catId.intValue());
                    if (categoryVO2 == null) {
                        return false;
                    }
                    if (!this.includeSubCategories && !categoryVO2.getPath().equals(ticketCategory)) {
                        return false;
                    }
                    if (categoryVO2.getPath().equals(ticketCategory)) {
                        return true;
                    }
                    Object categoryPath = categoryVO2.getPath();
                    if (!((String)categoryPath).endsWith("\\")) {
                        categoryPath = (String)categoryPath + "\\";
                    }
                    if (ticketCategory.startsWith((String)categoryPath)) break;
                    return false;
                }
                case "FilterTypeInquiryText": {
                    try {
                        String text;
                        ReaStepTextVO inquiryTextVO = TicketManager.getReader().getReaStepText(ticket.getInitialReaStepID());
                        if (inquiryTextVO == null) {
                            return this.inquiryText.isBlank();
                        }
                        String string = text = inquiryTextVO.hasHtmlContent() ? TicketTextFunctions.convertToPlainText((String)inquiryTextVO.getText()) : inquiryTextVO.getText();
                        if (!text.toLowerCase().contains(this.inquiryText.toLowerCase())) {
                            return false;
                        }
                        break;
                    }
                    catch (AccessDeniedException e) {
                        HDLogger.warn((Object)("Access denied when reading inquiry text for ticket " + ticket.getID() + ": " + e.getMessage()));
                        return false;
                    }
                }
                case "FilterTypeResource": {
                    if (this.resId == null) {
                        return false;
                    }
                    if (this.resId.equals((Object)ticket.getResourceID())) break;
                    if (this.includeSubResources) {
                        GUID currentGUID = ticket.getResourceID();
                        if (currentGUID == null) {
                            return false;
                        }
                        UserGroupInfo r = HDUsersAndGroups.getResource((int)HDUsersAndGroups.getResourceId((GUID)currentGUID));
                        while (r.getParentID() != null) {
                            if (this.resId.equals((Object)r.getParentID())) {
                                return true;
                            }
                            r = HDUsersAndGroups.getResource((int)HDUsersAndGroups.getResourceId((GUID)r.getParentID()));
                        }
                    }
                    return false;
                }
                case "FilterTypeCustomerLocation": {
                    GUID owner = ticket.getOwnerID();
                    if (owner == null || this.locationId == -1) {
                        return false;
                    }
                    UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getUserAccount(owner);
                    Integer loc = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
                    if (loc.equals(this.locationId)) break;
                    return false;
                }
                case "FilterTypeOwnerField": {
                    List fieldDefinitionsRaw = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
                    FieldDefinition field = fieldDefinitionsRaw.stream().sorted(Comparator.comparingInt(FieldDefinition::getPriority)).filter(f -> f instanceof UserFieldDefinition && f.getFieldKey() != null && f.getLabel() != null && !f.getLabel().isBlank() && f.getFieldKey().equals(this.ownerFieldKey)).findFirst().orElse(null);
                    GUID ownerID = ticket.getOwnerID();
                    if (ownerID == null || field == null) {
                        return false;
                    }
                    UserAccount ownerAccount = UserManager.getInstance().getUserAccount(ownerID);
                    FieldValue fieldValue = ((UserFieldDefinition)field).getFieldValue(ownerAccount);
                    if (fieldValue == null || fieldValue.getValue() == null) {
                        return false;
                    }
                    if ("fieldtype_date".equals(field.getDisplayType()) || "fieldtype_date_time".equals(field.getDisplayType())) {
                        try {
                            return TicketFilterCondition.isWithinNextDatePeriod(Long.valueOf(fieldValue.getValue()), this.ownerDateValue);
                        }
                        catch (IllegalArgumentException e) {
                            HDLogger.error((Object)("invalid date period: " + this.ownerDateValue));
                            return false;
                        }
                    }
                    String v = TicketFilterCondition.getStringRendererForFieldValue(field.getDisplayType(), fieldValue);
                    return v != null && v.toLowerCase().contains(this.ownerValue.toLowerCase());
                }
                case "FilterTypeProcessFilter": {
                    if (!ServerPluginManager.getInstance().isPluginLoaded("ticketprocess")) {
                        return false;
                    }
                    TicketProcess processOfTicket = TicketProcessManager.getProcessOfTicket((TicketVO)ticket);
                    switch (this.processFilterType) {
                        case "ProcessFilter.anyprocess": {
                            return processOfTicket != null;
                        }
                        case "ProcessFilter.none": {
                            return processOfTicket == null;
                        }
                        case "ProcessFilter.specific": {
                            if ("".equals(this.specificActivityId)) {
                                return processOfTicket != null && processOfTicket.getId().equals((Object)GUID.valueOf((String)this.specificProcessId));
                            }
                            Activity activityOfTicket = TicketProcessManager.getActivityOfTicket((TicketVO)ticket);
                            return processOfTicket != null && processOfTicket.getId().equals((Object)GUID.valueOf((String)this.specificProcessId)) && activityOfTicket != null && activityOfTicket.getId().equals((Object)GUID.valueOf((String)this.specificActivityId));
                        }
                    }
                    HDLogger.error((Object)("unexpected process filter type: " + this.processFilterType));
                    return false;
                }
                case "FilterTypeLastModified": {
                    Long lastChanged = (Long)ticket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_LAST_CHANGED);
                    if (lastChanged == null || this.lastModifiedWeeks == null || this.lastModifiedWeeks.isBlank()) {
                        return false;
                    }
                    String mode = this.properties.getOrDefault((isSecondFilter ? "Second." : "") + "LastModifiedDateMode", "within");
                    if ("within".equals(mode)) {
                        try {
                            return TicketFilterCondition.isWithinLastDatePeriod(lastChanged, this.lastModifiedWeeks);
                        }
                        catch (IllegalArgumentException e) {
                            HDLogger.error((Object)("invalid date period: " + this.lastModifiedWeeks));
                            return false;
                        }
                    }
                    if ("before".equals(mode)) {
                        ZonedDateTime now = ZonedDateTime.now();
                        ZonedDateTime periodAgo = TicketFilterChecker.calculatePeriodAgo(now, this.lastModifiedWeeks);
                        ZonedDateTime targetTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(lastChanged), ZoneId.systemDefault());
                        return targetTime.isBefore(periodAgo);
                    }
                    return false;
                }
                case "FilterTypeCreated": {
                    Long created = (Long)ticket.getAttribute((TicketAttribute)Tickets.ATTRIBUTE_INQUIRY_DATE);
                    if (created == null || this.createdWeeks == null || this.createdWeeks.isBlank()) {
                        return false;
                    }
                    String mode = this.properties.getOrDefault((isSecondFilter ? "Second." : "") + "CreatedDateMode", "within");
                    if ("within".equals(mode)) {
                        try {
                            return TicketFilterCondition.isWithinLastDatePeriod(created, this.createdWeeks);
                        }
                        catch (IllegalArgumentException e) {
                            HDLogger.error((Object)("invalid date period: " + this.createdWeeks));
                            return false;
                        }
                    }
                    if ("before".equals(mode)) {
                        ZonedDateTime now = ZonedDateTime.now();
                        ZonedDateTime periodAgo = TicketFilterChecker.calculatePeriodAgo(now, this.createdWeeks);
                        ZonedDateTime targetTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(created), ZoneId.systemDefault());
                        return targetTime.isBefore(periodAgo);
                    }
                    return false;
                }
                case "FilterTypeReadStatus": {
                    boolean isUnread;
                    TicketPermissionChecker checker;
                    TicketPermissionContext ticketPermissionInfo;
                    boolean currentUserIsOwner;
                    GUID ownerId = ticket.getOwnerID();
                    boolean bl = currentUserIsOwner = ownerId != null && user != null && ownerId.equals((Object)user.getID());
                    if (currentUserIsOwner && (ticketPermissionInfo = (checker = TicketManager.getTicketPermissionChecker()).getTicketPermissionInfo(ticket.getID())) != null && ticketPermissionInfo.hasSupporterAccessToTicket()) {
                        currentUserIsOwner = false;
                    }
                    boolean bl2 = isUnread = currentUserIsOwner ? ticket.isUnreadForEnduser() : ticket.isUnreadForSupporter();
                    if ("unread".equals(this.readStatusValue)) {
                        return isUnread;
                    }
                    if ("read".equals(this.readStatusValue)) {
                        return !isUnread;
                    }
                    return false;
                }
                case "FilterTypeNone": {
                    return true;
                }
                default: {
                    List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                    Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
                    boolean foundField = false;
                    for (TicketFieldDefinition d : fieldDefs) {
                        if (!d.getFieldKey().equals(this.filterType)) continue;
                        foundField = true;
                        TicketField ticketField = Tickets.getFieldByKey((String)d.getFieldKey());
                        Object value = ticket.getValue(ticketField);
                        String ticketValue = "";
                        if (value != null) {
                            if (value instanceof Boolean) {
                                ticketValue = value.toString();
                            } else {
                                ticketValue = ticketField.valueToString(value);
                                if (ticketValue == null) {
                                    ticketValue = "";
                                }
                            }
                        }
                        String toCheck = isSecondFilter ? this.dynamicValue2 : this.dynamicValue;
                        String dynamicOp = isSecondFilter ? this.dynamicOperator2 : this.dynamicOperator;
                        String displayType = d.getEditDefinition().getDisplayType();
                        if (displayType.equals("textarea") || displayType.equals("textinput")) {
                            return toCheck != null && ticketValue.toLowerCase().contains(toCheck.toLowerCase());
                        }
                        if (displayType.equals("integer")) {
                            if (toCheck != null && (toCheck.equals("") || toCheck.equals("null"))) {
                                toCheck = null;
                            }
                            Integer intValue = (Integer)value;
                            switch (dynamicOp) {
                                case "numberprebox.equal": {
                                    return intValue != null && toCheck != null && Integer.compare(intValue, Integer.valueOf(toCheck)) == 0 || intValue == null && toCheck == null;
                                }
                                case "numberprebox.greater": {
                                    return intValue != null && toCheck != null && intValue > Integer.valueOf(toCheck);
                                }
                                case "numberprebox.lessthan": {
                                    return intValue != null && toCheck != null && intValue < Integer.valueOf(toCheck);
                                }
                                case "numberprebox.notequal": {
                                    return intValue == null && toCheck != null || intValue != null && toCheck == null || intValue != null && toCheck != null && Integer.compare(intValue, Integer.valueOf(toCheck)) != 0;
                                }
                            }
                            return false;
                        }
                        if (displayType.equals("double") || displayType.equals("currency")) {
                            if (toCheck != null && (toCheck.equals("") || toCheck.equals("null"))) {
                                toCheck = null;
                            }
                            Double dValue = value == null || value.equals("") || value.equals("null") ? null : Double.valueOf(String.valueOf(value));
                            switch (dynamicOp) {
                                case "numberprebox.equal": {
                                    return dValue != null && toCheck != null && Double.compare(dValue, Double.valueOf(toCheck)) == 0 || dValue == null && toCheck == null;
                                }
                                case "numberprebox.greater": {
                                    return dValue != null && toCheck != null && dValue > Double.valueOf(toCheck);
                                }
                                case "numberprebox.lessthan": {
                                    return dValue != null && toCheck != null && dValue < Double.valueOf(toCheck);
                                }
                                case "numberprebox.notequal": {
                                    return dValue == null && toCheck != null || dValue != null && toCheck == null || dValue != null && toCheck != null && Double.compare(dValue, Double.valueOf(toCheck)) != 0;
                                }
                            }
                            return false;
                        }
                        if (displayType.equals("datevalue") || displayType.equals("dateonlyvalue")) {
                            try {
                                return value != null && toCheck != null && TicketFilterCondition.isWithinNextDatePeriod(Long.valueOf(String.valueOf(value)), toCheck);
                            }
                            catch (IllegalArgumentException e) {
                                HDLogger.error((Object)("invalid date period: " + toCheck));
                                return false;
                            }
                        }
                        if (displayType.equals("timeonlyvalue")) {
                            return toCheck != null && FieldTypeTime.fromMillisSince1970((long)Long.valueOf(toCheck)).equals(ticketValue);
                        }
                        if (displayType.equals("select") || displayType.equals("selecteditable") || displayType.equals("selectmulti") || displayType.equals("itilselect")) {
                            return toCheck != null && toCheck.equals(String.valueOf(value)) || toCheck == null && (value == null || value.toString().isEmpty());
                        }
                        if (displayType.equals("ticketowner")) {
                            return value != null && toCheck != null && toCheck.equals(String.valueOf(value));
                        }
                        return toCheck != null && toCheck.equalsIgnoreCase(ticketValue);
                    }
                    if (foundField) break;
                    return false;
                }
            }
            return true;
        }

        private static boolean isWithinNextDatePeriod(long timestampMillis, String datePeriod) {
            ZonedDateTime periodFromNow;
            ZonedDateTime now = ZonedDateTime.now();
            ZonedDateTime targetTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestampMillis), ZoneId.systemDefault());
            return targetTime.isBefore(periodFromNow = TicketFilterCondition.calculatePeriodFromNow(now, datePeriod)) && targetTime.isAfter(now) || targetTime.isEqual(now);
        }

        private static boolean isWithinLastDatePeriod(long timestampMillis, String datePeriod) {
            ZonedDateTime periodAgo;
            ZonedDateTime now = ZonedDateTime.now();
            ZonedDateTime targetTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestampMillis), ZoneId.systemDefault());
            return !(!targetTime.isAfter(periodAgo = TicketFilterChecker.calculatePeriodAgo(now, datePeriod)) && !targetTime.isEqual(periodAgo) || !targetTime.isBefore(now) && !targetTime.isEqual(now));
        }

        private static ZonedDateTime calculatePeriodFromNow(ZonedDateTime now, String datePeriod) {
            if (datePeriod == null || datePeriod.isBlank()) {
                throw new IllegalArgumentException("invalid date period");
            }
            switch (datePeriod) {
                case "1": {
                    return now.plusWeeks(1L);
                }
                case "2": {
                    return now.plusWeeks(2L);
                }
                case "3": {
                    return now.plusWeeks(3L);
                }
                case "4": {
                    return now.plusWeeks(4L);
                }
                case "5": {
                    return now.plusWeeks(5L);
                }
                case "6": {
                    return now.plusWeeks(6L);
                }
                case "7": {
                    return now.plusWeeks(7L);
                }
                case "8": {
                    return now.plusWeeks(8L);
                }
                case "3months": {
                    return now.plusMonths(3L);
                }
                case "6months": {
                    return now.plusMonths(6L);
                }
                case "1year": {
                    return now.plusYears(1L);
                }
                case "3years": {
                    return now.plusYears(3L);
                }
            }
            throw new IllegalArgumentException("invalid date period");
        }

        private static TicketProcessManager getTPMInstance() {
            if (tpmInstance != null) {
                return tpmInstance;
            }
            return (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
        }

        private static String getStringRendererForFieldValue(String type, FieldValue value) {
            TakeoutDataRenderer renderer = null;
            try {
                renderer = (TakeoutDataRenderer)ServerPluginManager.getInstance().getSingleInstanceByName(TakeoutDataRenderer.class, type, true);
            }
            catch (IllegalStateException e) {
                UsersAndGroups.LOGGER.error((Throwable)e);
                return null;
            }
            return renderer.render(value);
        }

        private void addRecursiveChildren(ArrayList<Entry> data, Map<Integer, String> to, String parentPrefix) {
            data.forEach(e -> {
                to.put(e.getId(), parentPrefix + e.getDisplayName());
                this.addRecursiveChildren(e.getChildren(), to, parentPrefix + e.getDisplayName() + "\\");
            });
        }
    }
}

