/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.field.SelectOptionResult;
import com.inet.field.fieldtypes.FieldTypeTime;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SelectEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.series.ticketcreated.TicketCreatedSeries;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.Activity;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.id.GUID;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.DataEntry;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public class FilterFieldValues {
    private static final AtomicLong cacheVersion = new AtomicLong(0L);
    private long cachedVersion = -1L;
    private ArrayList<Field> filterFieldsWithNone = new ArrayList();
    private ArrayList<Field> filterFieldsWithoutNone = new ArrayList();
    private List<DataEntry> categoryKeys = new ArrayList<DataEntry>();
    private List<DataEntry> itilKeys = new ArrayList<DataEntry>();
    private List<DataEntry> classificationKeys = new ArrayList<DataEntry>();
    private List<DataEntry> priorityKeys = new ArrayList<DataEntry>();
    private List<DataEntry> resourceKeys = new ArrayList<DataEntry>();
    private List<DataEntry> resourceKeysNoCustom = new ArrayList<DataEntry>();
    private List<DataEntry> customerLocationKeys = new ArrayList<DataEntry>();
    private List<DataEntry> actionKeys = new ArrayList<DataEntry>();
    private List<LocalizedKey> ownerFieldKeys = new ArrayList<LocalizedKey>();
    private FilterableFieldListGenerator fieldListGenerator;
    static TicketProcessManager tpmInstance;

    public FilterFieldValues(FilterableFieldListGenerator fieldListGenerator) {
        this.fieldListGenerator = fieldListGenerator;
        this.regenerateCache();
    }

    private void regenerateCache() {
        FilterableFieldListGenerator generator = this.fieldListGenerator;
        this.categoryKeys = generator.getCategoryKeys();
        this.itilKeys = generator.getItilKeys();
        this.classificationKeys = generator.getClassificationKeys();
        this.priorityKeys = generator.getPriorityKeys();
        this.resourceKeys = generator.getResourceKeys(true, true);
        this.resourceKeysNoCustom = generator.getResourceKeys(false, false);
        this.customerLocationKeys = generator.getCustomerLocationKeys();
        this.ownerFieldKeys = generator.getOwnerFieldKeys();
        this.actionKeys = generator.getActionKeys();
        this.filterFieldsWithNone = this.getFilterFieldChooserInternal(true);
        this.filterFieldsWithoutNone = this.getFilterFieldChooserInternal(false);
        this.cachedVersion = cacheVersion.get();
    }

    public ArrayList<Field> getFilterFieldChooser() {
        return this.getFilterFieldChooser(true);
    }

    public ArrayList<Field> getFilterFieldChooser(boolean includeNoneResource) {
        if (this.cachedVersion != cacheVersion.get()) {
            this.regenerateCache();
        }
        if (includeNoneResource && !this.filterFieldsWithNone.isEmpty()) {
            return this.filterFieldsWithNone;
        }
        if (!includeNoneResource && !this.filterFieldsWithoutNone.isEmpty()) {
            return this.filterFieldsWithoutNone;
        }
        return this.getFilterFieldChooserInternal(includeNoneResource);
    }

    private ArrayList<Field> getFilterFieldChooserInternal(boolean includeNoneResource) {
        ArrayList<Field> fields = new ArrayList<Field>();
        FilterableFieldListGenerator generator = this.fieldListGenerator;
        List<Field> filterableFields = generator.generateFilterableFieldList(includeNoneResource);
        fields.addAll(filterableFields);
        return fields;
    }

    public static void invalidateCache() {
        cacheVersion.incrementAndGet();
    }

    public static Set<String> getDefaultFilterList() {
        HashSet<String> list = new HashSet<String>(Arrays.asList("FilterTypeResource", "FilterTypeCategory", "FilterTypeInquiryText", "FilterTypeReadStatus", "FilterTypeOwnerField", "FilterTypeCustomerLocation", "FilterTypeProcessFilter", "FilterTypeLastModified", "FilterTypeCreated"));
        return list;
    }

    public SummaryInfo getSummary(AbstractDefinition definition, String language, String prefixLabel, String label, String desc) {
        return this.getSummary(definition, language, prefixLabel, label, "", desc);
    }

    public SummaryInfo getSummary(AbstractDefinition definition, String language, String prefixLabel, String label, String labelParam, String desc) {
        String andLabel = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("SecondFilter.AndLabel", new Object[0]);
        String orLabel = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("SecondFilter.OrLabel", new Object[0]);
        if (this.fieldListGenerator.getFilterTypeValuesMap().size() == 0) {
            this.getFilterFieldChooser();
        }
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String typeKey = definition.getProperty("FilterType");
        if ("FilterTypeNone".equals(typeKey) || typeKey == null) {
            summary.add(new SummaryEntry("", prefixLabel + "..."));
            return new SummaryInfo(summary);
        }
        if (!"".equals(label)) {
            label = !"".equals(labelParam) ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg(label, new Object[]{labelParam}) : HelpDeskTaskPlannerServerPlugin.MSG.getMsg(label, new Object[0]);
        }
        String toAdd = this.getStringToAdd(definition, language, desc, typeKey, "");
        String property = definition.getProperty("SecondFilterAndOrNone");
        Object secondSuffix = "";
        if (property != null) {
            if (property.equals("SecondFilterAnd")) {
                secondSuffix = " " + andLabel + " ";
            } else if (property.equals("SecondFilterOr")) {
                secondSuffix = " " + orLabel + " ";
            }
        }
        if (!((String)secondSuffix).isBlank()) {
            String secondTypeKey = definition.getProperty("Second.FilterType");
            if (secondTypeKey == null) {
                secondTypeKey = "FilterTypeNone";
            }
            secondSuffix = (String)secondSuffix + this.getStringToAdd(definition, language, desc, secondTypeKey, "Second.");
        }
        summary.add(new SummaryEntry(label, prefixLabel + ", " + toAdd + (String)secondSuffix));
        return new SummaryInfo(summary);
    }

    private String getStringToAdd(AbstractDefinition definition, String language, String desc, String typeKey, String propPrefix) {
        String filterValueString;
        String _typeKey = typeKey;
        Object typeString = this.fieldListGenerator.getFilterTypeValuesMap().getOrDefault(language, new ArrayList()).stream().filter(k -> k.getKey().equals(_typeKey)).findFirst().map(LocalizedKey::getDisplayName).orElse("");
        Object subString = "";
        block11 : switch (typeKey) {
            case "FilterTypeCategory": {
                String catId = definition.getProperty(propPrefix + TicketCreatedSeries.PROPERTY_CATEGORY);
                filterValueString = this.categoryKeys.stream().filter(k -> k.getValue().equals(catId)).findFirst().map(DataEntry::getLabel).orElse("");
                break;
            }
            case "FilterTypeInquiryText": {
                desc = (String)desc + ".contains";
                filterValueString = definition.getProperty(propPrefix + "InquiryText");
                if (filterValueString != null) break;
                filterValueString = "";
                break;
            }
            case "FilterTypeResource": {
                List<DataEntry> keys = this.resourceKeys;
                String resIfCustomEntry = definition.getProperty(propPrefix + "Resource.noNoneEntry");
                if (resIfCustomEntry == null) {
                    resIfCustomEntry = definition.getProperty(propPrefix + "Resource");
                }
                if (resIfCustomEntry == null) {
                    resIfCustomEntry = definition.getProperty(propPrefix + "Resource.noCustomEntry");
                    keys = this.resourceKeysNoCustom;
                }
                String resource = resIfCustomEntry;
                filterValueString = keys.stream().filter(k -> k.getValue().equals(resource)).findFirst().map(DataEntry::getLabel).orElse("");
                break;
            }
            case "FilterTypeCustomerLocation": {
                String customerLocation = definition.getProperty(propPrefix + TicketCreatedSeries.PROPERTY_CUSTOMER_LOCATION);
                filterValueString = this.customerLocationKeys.stream().filter(k -> k.getValue().equals(customerLocation)).findFirst().map(DataEntry::getLabel).orElse("");
                break;
            }
            case "FilterTypeOwnerField": {
                String ownerField = definition.getProperty(propPrefix + "OwnerField");
                String chosenFieldKey = this.ownerFieldKeys.stream().filter(k -> k.getKey().equals(ownerField)).findFirst().map(LocalizedKey::getDisplayName).orElse(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]));
                typeString = (String)typeString + " (" + chosenFieldKey + ")";
                boolean isDateField = false;
                List<FieldDefinition> userFields = this.fieldListGenerator.getEligibleUserFieldDefinitions();
                for (FieldDefinition userField : userFields) {
                    if (!ownerField.equals(userField.getFieldKey()) || !"fieldtype_date".equals(userField.getDisplayType()) && !"fieldtype_date_time".equals(userField.getDisplayType())) continue;
                    isDateField = true;
                }
                desc = (String)desc + (isDateField ? ".within" : ".contains");
                if (isDateField) {
                    filterValueString = definition.getProperty(propPrefix + "OwnerFieldDateValue");
                    filterValueString = this.getDatePeriodLabel(filterValueString);
                } else {
                    filterValueString = definition.getProperty(propPrefix + "OwnerFieldValue");
                }
                if (filterValueString != null) break;
                filterValueString = "";
                break;
            }
            case "FilterTypeProcessFilter": {
                String filterValueString2;
                if (!ServerPluginManager.getInstance().isPluginLoaded("ticketprocess")) {
                    return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.noplugin", new Object[0]);
                }
                desc = (String)desc + ".process";
                String typeOfProcessFilter = definition.getProperty(propPrefix + "FilterTypeProcessFilter");
                if ("ProcessFilter.anyprocess".equals(typeOfProcessFilter)) {
                    filterValueString2 = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.anyprocess.summary", new Object[0]);
                } else if ("ProcessFilter.none".equals(typeOfProcessFilter)) {
                    filterValueString2 = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.none.summary", new Object[0]);
                } else if ("ProcessFilter.specific".equals(typeOfProcessFilter)) {
                    Activity activity;
                    filterValueString2 = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.specific.summary", new Object[0]);
                    String specificProcess = definition.getProperty(propPrefix + "PropProcess");
                    TicketProcess process = FilterFieldValues.getTPMInstance().getProcess(GUID.valueOf((String)specificProcess));
                    subString = " (" + (process == null ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("StartProcess.DeletedProcess", new Object[0]) : process.getName()) + ")";
                    String specificActivity = definition.getProperty(propPrefix + "." + specificProcess + ".PropActivity");
                    if (specificActivity != null && !specificActivity.isBlank() && (activity = process.getActivity(GUID.valueOf((String)specificActivity))) != null) {
                        subString = (String)subString + HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.specificactivity.summary", new Object[]{activity.getName()});
                    }
                } else {
                    throw new IllegalArgumentException("unknown filter value " + typeOfProcessFilter);
                }
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg((String)desc, new Object[]{filterValueString2, subString});
            }
            case "FilterTypeLastModified": {
                filterValueString = this.getDateFilterSummary(definition, propPrefix, "LastModified");
                break;
            }
            case "FilterTypeCreated": {
                filterValueString = this.getDateFilterSummary(definition, propPrefix, "Created");
                break;
            }
            case "FilterTypeReadStatus": {
                String v = definition.getProperty(propPrefix + "ReadStatusValue");
                if ("unread".equals(v)) {
                    filterValueString = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ReadStatus.unread", new Object[0]);
                    break;
                }
                if ("read".equals(v)) {
                    filterValueString = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ReadStatus.read", new Object[0]);
                    break;
                }
                filterValueString = "";
                break;
            }
            default: {
                List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
                Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
                filterValueString = "";
                for (TicketFieldDefinition d : fieldDefs) {
                    if (!typeKey.equals(d.getFieldKey())) continue;
                    filterValueString = definition.getProperty("fflg." + propPrefix + d.getFieldKey());
                    String displayType = d.getEditDefinition().getDisplayType();
                    if (displayType.equals("timeonlyvalue")) {
                        if (filterValueString != null && !filterValueString.equals("")) {
                            filterValueString = FieldTypeTime.fromMillisSince1970((long)Long.valueOf(filterValueString));
                            break block11;
                        }
                        filterValueString = "";
                        break block11;
                    }
                    if (displayType.equals("dateonlyvalue") || displayType.equals("datevalue")) {
                        if (filterValueString != null) {
                            filterValueString = this.getDatePeriodLabel(filterValueString);
                            desc = (String)desc + ".within";
                            break block11;
                        }
                        filterValueString = "";
                        break block11;
                    }
                    if (displayType.equals("textinput") || displayType.equals("textarea")) {
                        desc = (String)desc + ".contains";
                        break block11;
                    }
                    if (displayType.equals("currency") || displayType.equals("integer") || displayType.equals("double")) {
                        String op = definition.getProperty("fflg." + propPrefix + d.getFieldKey() + ".prebox");
                        if (op == null) break block11;
                        desc = (String)desc + "." + op;
                        break block11;
                    }
                    if (displayType.equals("ticketowner")) {
                        String ownerGUID = filterValueString;
                        if (ownerGUID == null || ownerGUID.isBlank()) {
                            filterValueString = "";
                            break block11;
                        }
                        UserAccount userAccount = UserManager.getInstance().getUserAccount(GUID.valueOf((String)ownerGUID));
                        if (userAccount == null) {
                            filterValueString = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]);
                            break block11;
                        }
                        filterValueString = userAccount.getDisplayName();
                        break block11;
                    }
                    FieldEditDefinition edit = d.getEditDefinition();
                    if (!(edit instanceof SelectEditDefinition)) break block11;
                    SelectOptionResult selectOptions = ((SelectEditDefinition)edit).getSelectOptions(new ArrayList(), "", 10000, 0);
                    List options = selectOptions.getOptions();
                    String v = filterValueString;
                    filterValueString = options.stream().filter(o -> Objects.equals(v, o.getValue())).findFirst().map(o -> o.getLabel()).orElse("");
                    break block11;
                }
            }
        }
        String includeSub = definition.getProperty(propPrefix + "IncludeSubcategories");
        String includeSubRes = definition.getProperty(propPrefix + "IncludeSubresources");
        if ("FilterTypeCategory".equals(typeKey) && includeSub != null && Boolean.valueOf(includeSub).booleanValue() && !"0".equals(definition.getProperty(propPrefix + "Category"))) {
            subString = " " + HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketCreatedSeriesSummaryInfoLabelOrSub", new Object[0]);
        } else if ("FilterTypeResource".equals(typeKey) && includeSubRes != null && Boolean.valueOf(includeSubRes).booleanValue() && !"0".equals(definition.getProperty(propPrefix + "Resource"))) {
            subString = " " + HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketCreatedSeriesSummaryInfoLabelOrSubRes", new Object[0]);
        }
        String toAdd = HelpDeskTaskPlannerServerPlugin.MSG.getMsg((String)desc, new Object[]{typeString, filterValueString, subString});
        return toAdd;
    }

    private static TicketProcessManager getTPMInstance() {
        if (tpmInstance != null) {
            return tpmInstance;
        }
        return (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
    }

    public void validate(@Nonnull AbstractDefinition definition, GUID guid) throws ValidationException {
        String typeKey = definition.getProperty("FilterType");
        this.validateNotEmpty(definition, typeKey, "");
        String andOrNone = definition.getProperty("SecondFilterAndOrNone");
        String secondTypeKey = definition.getProperty("Second.FilterType");
        if (!"SecondFilterNone".equals(andOrNone)) {
            if ("FilterTypeNone".equals(secondTypeKey)) {
                throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("value.mustHaveCondition", new Object[0])});
            }
            this.validateNotEmpty(definition, secondTypeKey, "Second.");
        }
    }

    private void validateNotEmpty(AbstractDefinition definition, String typeKey, String prefixProp) throws ValidationException {
        String value = "";
        if ("FilterTypeInquiryText".equals(typeKey)) {
            value = definition.getProperty(prefixProp + "InquiryText");
        } else if ("FilterTypeLastModified".equals(typeKey)) {
            value = definition.getProperty(prefixProp + "LastModifiedDateValue");
        } else if ("FilterTypeCreated".equals(typeKey)) {
            value = definition.getProperty(prefixProp + "CreatedDateValue");
        } else if ("FilterTypeReadStatus".equals(typeKey)) {
            value = definition.getProperty(prefixProp + "ReadStatusValue");
        } else if (Tickets.FIELD_IDENTIFIER.getKey().equals(typeKey)) {
            value = definition.getProperty(prefixProp + "fflg." + Tickets.FIELD_IDENTIFIER.getKey());
        } else if ("FilterTypeOwnerField".equals(typeKey)) {
            value = definition.getProperty(prefixProp + "OwnerFieldValue");
            List<FieldDefinition> userFields = this.fieldListGenerator.getEligibleUserFieldDefinitions();
            String whichOwnerField = definition.getProperty(prefixProp + "OwnerField");
            for (FieldDefinition userField : userFields) {
                if (!whichOwnerField.equals(userField.getFieldKey()) || !"fieldtype_date".equals(userField.getDisplayType()) && !"fieldtype_date_time".equals(userField.getDisplayType())) continue;
                value = definition.getProperty(prefixProp + "OwnerFieldDateValue");
            }
        } else {
            List fieldDefs = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
            Collections.sort(fieldDefs, Comparator.comparingInt(TicketFieldDefinition::getPriority));
            for (TicketFieldDefinition d : fieldDefs) {
                String op;
                if (!d.getFieldKey().equals(typeKey)) continue;
                value = definition.getProperty("fflg." + prefixProp + d.getFieldKey());
                String displayType = d.getEditDefinition().getDisplayType();
                if (displayType.equals("textinput") || displayType.equals("textarea") ? value == null || value.isBlank() : !(!displayType.equals("double") && !displayType.equals("integer") || !"numberprebox.greater".equals(op = definition.getProperty("fflg." + prefixProp + d.getFieldKey() + ".prebox")) && !"numberprebox.lessthan".equals(op) || value != null && !value.isBlank())) {
                    throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("value.mustnotbeblank", new Object[0])});
                }
                return;
            }
            return;
        }
        if (value == null || value.isBlank()) {
            throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("value.mustnotbeblank", new Object[0])});
        }
    }

    private String getDateFilterSummary(AbstractDefinition definition, String propPrefix, String baseName) {
        String mode = definition.getProperty(propPrefix + baseName + "DateMode");
        String datePeriod = definition.getProperty(propPrefix + (baseName.equals("LastModified") ? "LastModifiedDateValue" : "CreatedDateValue"));
        String periodLabel = this.getDatePeriodLabel(datePeriod);
        if ("before".equals(mode)) {
            return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("dateFilter.summary.before", new Object[]{periodLabel});
        }
        return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("dateFilter.summary.within", new Object[]{periodLabel});
    }

    private String getDatePeriodLabel(String datePeriod) {
        if (datePeriod == null || datePeriod.isBlank()) {
            return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{1});
        }
        switch (datePeriod) {
            case "1": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{1});
            }
            case "2": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{2});
            }
            case "3": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{3});
            }
            case "4": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{4});
            }
            case "5": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{5});
            }
            case "6": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{6});
            }
            case "7": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{7});
            }
            case "8": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{8});
            }
            case "3months": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("months", new Object[]{3});
            }
            case "6months": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("months", new Object[]{6});
            }
            case "1year": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("years", new Object[]{1});
            }
            case "3years": {
                return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("years", new Object[]{3});
            }
        }
        try {
            int weeks = Integer.parseInt(datePeriod);
            return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{weeks});
        }
        catch (NumberFormatException e) {
            return HelpDeskTaskPlannerServerPlugin.MSG.getMsg("weeks", new Object[]{1});
        }
    }
}

