/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.toomanytickets;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterFieldValues;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.toomanytickets.TooManyTicketsTrigger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TooManyTicketsTriggerFactory
extends TriggerFactory<Trigger> {
    public static final String EXTENSION_NAME = "taskplanner.helpdesk.toomanytickets";
    public static final String PROPERTY_HOW_MANY = "toomanytickets.howmany";
    private FilterFieldValues fieldValues;

    public TooManyTicketsTriggerFactory() {
        super(EXTENSION_NAME);
    }

    public TriggerInfo getInformation(@Nullable GUID guid) {
        String name = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTicketsCategory", new Object[0]);
        String description = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTicketsCategoryDesc", new Object[0]);
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/high_workload_32.png");
        String helpKey = "taskplanner.trigger.high-workload";
        ArrayList<Object> fields = new ArrayList<Object>();
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        values.add(new LocalizedKey("5", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_5", new Object[0])));
        values.add(new LocalizedKey("10", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_10", new Object[0])));
        values.add(new LocalizedKey("15", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_15", new Object[0])));
        values.add(new LocalizedKey("20", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_20", new Object[0])));
        values.add(new LocalizedKey("25", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_25", new Object[0])));
        values.add(new LocalizedKey("50", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_50", new Object[0])));
        values.add(new LocalizedKey("100", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_100", new Object[0])));
        values.add(new LocalizedKey("200", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_200", new Object[0])));
        values.add(new LocalizedKey("300", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_300", new Object[0])));
        values.add(new LocalizedKey("500", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_500", new Object[0])));
        values.add(new LocalizedKey("1000", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_1000", new Object[0])));
        SelectField howMany = new SelectField(PROPERTY_HOW_MANY, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets.TriggerIf", new Object[0]), values);
        howMany.setValue("10");
        fields.add(howMany);
        this.fieldValues = new FilterFieldValues(this.getFieldListGenerator());
        ArrayList<Field> filterableFields = this.fieldValues.getFilterFieldChooser(false);
        fields.addAll(filterableFields);
        return new TriggerInfo(this.getExtensionName(), name, description, iconURL, helpKey, fields);
    }

    protected FilterableFieldListGenerator getFieldListGenerator() {
        return FilterableFieldListGenerator.getInstance();
    }

    public void validate(@Nonnull TriggerDefinition definition, GUID guid) throws ValidationException {
        this.fieldValues.validate((AbstractDefinition)definition, guid);
    }

    public SummaryInfo getSummary(@Nonnull TriggerDefinition definition) {
        String key = "TooManyTickets.summary.desc";
        String ticketCreatedSeriesSummaryInfoLabel = "TicketCreatedSeriesSummaryInfoLabel";
        String howMany = definition.getProperty(PROPERTY_HOW_MANY);
        return this.fieldValues.getSummary((AbstractDefinition)definition, this.currentLanguage(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg(key, new Object[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_" + howMany, new Object[0])}), "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TooManyTickets_" + howMany, new Object[0]), ticketCreatedSeriesSummaryInfoLabel);
    }

    private String currentLanguage() {
        return ClientLocale.getThreadLocale().toLanguageTag();
    }

    public List<ZonedDateTime> getNextExecutionTimes(TriggerDefinition definition) {
        return super.getNextExecutionTimes(definition);
    }

    protected Trigger createInstanceFrom(@Nonnull TriggerDefinition definition, @Nullable GUID taskID) {
        return new TooManyTicketsTrigger(taskID, definition.getUid(), definition.getProperties());
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    public Map<String, String> updateValues(@Nonnull TriggerDefinition definition, GUID taskID) {
        FilterableFieldListGenerator.updateResourceDisplayValueIfNecessary((AbstractDefinition)definition);
        return super.updateValues((AbstractDefinition)definition, taskID);
    }
}

