/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.ticketwarning;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.timeline.TicketWarningListener;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.helpdesk.plugins.taskplanner.server.TicketFilterChecker;
import com.inet.helpdesk.shared.model.Status;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Map;

public class TicketWarningTrigger
implements Trigger,
TicketWarningListener {
    private final String typeFilter;
    private final String thresholdFilter;
    private final TicketFilterChecker filterChecker;
    private Trigger.TriggerAction triggerAction;
    private GUID taskID;

    public TicketWarningTrigger(TriggerDefinition definition, GUID taskID) {
        String whenToTrigger;
        Map props = definition.getProperties();
        this.typeFilter = whenToTrigger = (String)props.get("PROPERTY_WHICH_THRESHOLD");
        this.thresholdFilter = "Autoescalation".equals(whenToTrigger) ? (String)props.get("PROPERTY_WARNING_ACTION_WHEN_ESCA") : (String)props.get("PROPERTY_WARNING_ACTION_WHEN");
        this.filterChecker = this.getFilterChecker(definition);
    }

    protected TicketFilterChecker getFilterChecker(TriggerDefinition definition) {
        return new TicketFilterChecker(definition.getProperties());
    }

    public void activate(GUID guid, Trigger.TriggerAction triggerAction) {
        this.triggerAction = triggerAction;
        this.taskID = guid;
        this.registerListener();
    }

    protected void registerListener() {
        HDTaskPlannerDataListener.addTicketWarningListener(this);
    }

    public void deactivate() {
        this.triggerAction = null;
        this.unregisterListener();
    }

    protected void unregisterListener() {
        HDTaskPlannerDataListener.removeTicketWarningListener(this);
    }

    public void warningChanged(TicketVO ticketVO, TicketWarningListener.WarningType warningType, TicketWarningListener.WarningLevel warningLevel) {
        if (this.triggerAction == null) {
            return;
        }
        TaskExecution execution = this.getTaskExecution();
        GUID currentUser = execution != null && execution.getOwnerId() != null ? execution.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
        try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
            if (!Status.isOpenStatus((int)ticketVO.getStatusID())) {
                HDLogger.debug((Object)("TicketWarningTrigger: ignoring closed ticket in tp : " + ticketVO.getID()));
                return;
            }
            try {
                TicketManager.getReader().getTicket(ticketVO.getID());
            }
            catch (AccessDeniedException exc) {
                HDLogger.debug((Object)("TicketWarningTrigger: ignoring ticket we don't have access to in tp : " + ticketVO.getID()));
                if (scope != null) {
                    scope.close();
                }
                return;
            }
            HDLogger.debug((Object)("TicketWarningTrigger: got warning change in tp for ticket " + ticketVO.getID() + ": " + String.valueOf(warningType) + ", " + String.valueOf(warningLevel)));
            if (warningType != null && warningType.name().equals(this.typeFilter) && (warningLevel != null && warningLevel.name().equals(this.thresholdFilter) || "any".equals(this.thresholdFilter))) {
                UserAccount user = UserManager.getInstance().getCurrentUserAccount();
                if (user == null) {
                    HDLogger.warn((Object)"TicketWarningTrigger: no current user - no ticket list");
                    return;
                }
                if (this.filterChecker.check(this.getServerValuesConnector(), ticketVO, user)) {
                    Map<String, String> props = this.fillPlaceholders(ticketVO);
                    if (warningLevel == TicketWarningListener.WarningLevel.attention) {
                        props.put("ticketwarning.color", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ticketwarning.color." + warningType.name() + "." + warningLevel.name(), new Object[0]));
                    } else {
                        props.put("ticketwarning.color", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ticketwarning.color." + warningLevel.name(), new Object[0]));
                    }
                    props.put("ticketwarning.type", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ticketwarning.type." + warningType.name(), new Object[0]));
                    String ticketIDProp = props.get("Ticket ID");
                    if (ticketIDProp != null) {
                        props.put("Ticket ID", ticketIDProp.trim());
                    }
                    this.triggerAction.execute(props);
                }
            }
        }
    }

    protected TaskExecution getTaskExecution() {
        return TaskPlanner.getInstance().getTaskExecution(this.taskID);
    }

    protected Map<String, String> fillPlaceholders(TicketVO ticketVO) {
        return HDPlaceholderUtils.fillPlaceholderValuesFor(ticketVO);
    }

    protected ServerValuesConnector getServerValuesConnector() {
        return (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
    }
}

