/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.newticket;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.FilterFieldValues;
import com.inet.helpdesk.plugins.taskplanner.server.FilterableFieldListGenerator;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.newticket.NewTicketTrigger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.common.AbstractDefinition;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NewTicketTriggerFactory
extends TriggerFactory<Trigger> {
    public static final String EXTENSION_NAME = "taskplanner.helpdesk";
    public static final String DISPATCHED_FILTER = "dispatchedFilterKey";
    public static final String DISPATCHED_FILTER_ANY = "dispatchedFilter.any";
    public static final String DISPATCHED_FILTER_ONLY_INQUIRIES = "dispatchedFilter.onlyinquiries";
    public static final String DISPATCHED_FILTER_ONLY_DISPATCHED = "dispatchedFilter.onlydispatch";
    private FilterFieldValues fieldValues;

    public NewTicketTriggerFactory() {
        super(EXTENSION_NAME);
    }

    public TriggerInfo getInformation(@Nullable GUID guid) {
        this.fieldValues = new FilterFieldValues(this.getFieldListGenerator());
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/newticket_32.png");
        ArrayList<Field> fields = this.fieldValues.getFilterFieldChooser();
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        values.add(new LocalizedKey(DISPATCHED_FILTER_ANY, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(DISPATCHED_FILTER_ANY, new Object[0])));
        values.add(new LocalizedKey(DISPATCHED_FILTER_ONLY_INQUIRIES, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(DISPATCHED_FILTER_ONLY_INQUIRIES, new Object[0])));
        values.add(new LocalizedKey(DISPATCHED_FILTER_ONLY_DISPATCHED, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(DISPATCHED_FILTER_ONLY_DISPATCHED, new Object[0])));
        SelectField dispatchedFilterSelectField = new SelectField(DISPATCHED_FILTER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("NewTicketTrigger.dispatchedFilter", new Object[0]), values);
        dispatchedFilterSelectField.setValue(DISPATCHED_FILTER_ANY);
        fields.add(0, (Field)dispatchedFilterSelectField);
        return new TriggerInfo(EXTENSION_NAME, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("NewTicketTrigger.name", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("NewTicketTrigger.desc", new Object[0]), iconURL, "taskplanner.trigger.ticket-created", fields, HDPlaceholders.getHDPlaceholderKeys());
    }

    public FilterableFieldListGenerator getFieldListGenerator() {
        return FilterableFieldListGenerator.getInstance();
    }

    public void validate(@Nonnull TriggerDefinition definition, GUID guid) throws ValidationException {
        this.fieldValues.validate((AbstractDefinition)definition, guid);
    }

    public SummaryInfo getSummary(@Nonnull TriggerDefinition definition) {
        Object key = "NewTicketTrigger.foreachticket";
        String dispatchedFilter = definition.getProperties().getOrDefault(DISPATCHED_FILTER, DISPATCHED_FILTER_ANY);
        if (dispatchedFilter != null && dispatchedFilter.equals(DISPATCHED_FILTER_ONLY_DISPATCHED)) {
            key = (String)key + ".onlydispatch";
        } else if (dispatchedFilter != null && dispatchedFilter.equals(DISPATCHED_FILTER_ONLY_INQUIRIES)) {
            key = (String)key + ".onlyinquiries";
        }
        String ticketCreatedSeriesSummaryInfoLabel = "TicketCreatedSeriesSummaryInfoLabel";
        return this.fieldValues.getSummary((AbstractDefinition)definition, this.currentLanguage(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg((String)key, new Object[0]), "NewTicketTrigger.summary.label", ticketCreatedSeriesSummaryInfoLabel);
    }

    private String currentLanguage() {
        return ClientLocale.getThreadLocale().toLanguageTag();
    }

    public List<ZonedDateTime> getNextExecutionTimes(TriggerDefinition definition) {
        return super.getNextExecutionTimes(definition);
    }

    protected Trigger createInstanceFrom(@Nonnull TriggerDefinition definition, @Nullable GUID taskID) {
        return new NewTicketTrigger(definition, taskID);
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    public Map<String, String> updateValues(@Nonnull TriggerDefinition definition, GUID taskID) {
        FilterableFieldListGenerator.updateResourceDisplayValueIfNecessary((AbstractDefinition)definition);
        return super.updateValues((AbstractDefinition)definition, taskID);
    }
}

