/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.formsubmitted;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.plugins.forms.server.api.FormsManager;
import com.inet.helpdesk.plugins.forms.server.api.model.FormField;
import com.inet.helpdesk.plugins.forms.server.api.model.HDForm;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.formsubmitted.FormsTrigger;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.LabelField;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormsTriggerFactory
extends TriggerFactory<Trigger> {
    public static final String EXTENSION_NAME = "trigger.helpdesk.formsubmitted";
    public static final String PROPERTY_WHEN_TO_TRIGGER = "whenToTrigger";
    public static final String WHEN_TO_TRIGGER_ANY = "when.any";
    public static final String WHEN_TO_TRIGGER_SPECIFIC = "when.specific";
    public static final String PROPERTY_FORM_ID = "formId";

    public FormsTriggerFactory() {
        super(EXTENSION_NAME);
    }

    public TriggerInfo getInformation(@Nullable GUID guid) {
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/form_submitted_32.png");
        ArrayList<Object> fields = new ArrayList<Object>();
        ArrayList<LocalizedKey> whenOptions = new ArrayList<LocalizedKey>();
        whenOptions.add(new LocalizedKey(WHEN_TO_TRIGGER_ANY, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.when.any", new Object[0])));
        whenOptions.add(new LocalizedKey(WHEN_TO_TRIGGER_SPECIFIC, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.when.specific", new Object[0])));
        SelectField whenSelect = new SelectField(PROPERTY_WHEN_TO_TRIGGER, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.whenToTrigger", new Object[0]), whenOptions);
        whenSelect.setValue(WHEN_TO_TRIGGER_ANY);
        fields.add(whenSelect);
        ArrayList<LocalizedKey> formOptions = this.getFormOptions();
        ArrayList<FieldCondition> conds = new ArrayList<FieldCondition>();
        conds.add(FieldCondition.visible((Field)whenSelect, (FieldCondition.OP)FieldCondition.OP.equals, (String)WHEN_TO_TRIGGER_SPECIFIC));
        if (formOptions.isEmpty()) {
            LabelField noFormsLabel = new LabelField("FormsTrigger.noFormsAvailable.label", "", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.noFormsAvailable", new Object[0]));
            noFormsLabel.setConditions(conds);
            fields.add(noFormsLabel);
        } else {
            SelectField formSelect = new SelectField(PROPERTY_FORM_ID, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.form", new Object[0]), formOptions);
            if (formSelect.getValues().size() > 0) {
                formSelect.setValue(((LocalizedKey)formSelect.getValues().get(0)).getKey());
            }
            formSelect.setConditions(conds);
            fields.add(formSelect);
        }
        ArrayList placeholderKeys = new ArrayList();
        if (guid != null) {
            try {
                TaskDefinition taskDefinition = TaskPlanner.getInstance().getTaskDefinition(guid);
                if (taskDefinition != null) {
                    taskDefinition.getTriggers().stream().filter(t -> EXTENSION_NAME.equals(t.getExtensionName())).forEach(t -> {
                        String formIdStr;
                        String when = (String)t.getProperties().get(PROPERTY_WHEN_TO_TRIGGER);
                        if (WHEN_TO_TRIGGER_SPECIFIC.equals(when) && (formIdStr = (String)t.getProperties().get(PROPERTY_FORM_ID)) != null && !formIdStr.isBlank()) {
                            try {
                                HDForm form = FormsManager.getInstance().getForm(GUID.valueOf((String)formIdStr));
                                if (form != null) {
                                    placeholderKeys.add("form.id");
                                    placeholderKeys.add("form.name");
                                    placeholderKeys.add("form.title");
                                    form.getSections().stream().flatMap(s -> s.getFields().stream()).map(FormField::getKey).distinct().sorted(String.CASE_INSENSITIVE_ORDER).forEach(k -> placeholderKeys.add("form.field." + k));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new TriggerInfo(EXTENSION_NAME, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.name", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.desc", new Object[0]), iconURL, "taskplanner.trigger.form-submitted", fields, placeholderKeys);
    }

    private ArrayList<LocalizedKey> getFormOptions() {
        ArrayList<LocalizedKey> result = new ArrayList<LocalizedKey>();
        try {
            List forms = FormsManager.getInstance().getAllForms();
            forms.stream().filter(f -> f.getSubmitType() == 3).sorted((a, b) -> a.getName().compareToIgnoreCase(b.getName())).forEach(f -> result.add(new LocalizedKey(f.getId().toString(), f.getName())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void validate(@Nonnull TriggerDefinition definition, GUID guid) throws ValidationException {
        Map props = definition.getProperties();
        String when = (String)props.get(PROPERTY_WHEN_TO_TRIGGER);
        if (WHEN_TO_TRIGGER_SPECIFIC.equals(when)) {
            if (this.getFormOptions().isEmpty()) {
                throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.error.noFormsAvailable", new Object[0])});
            }
            String formId = (String)props.get(PROPERTY_FORM_ID);
            if (formId == null || formId.isBlank()) {
                throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.error.formMissing", new Object[0])});
            }
            try {
                GUID id = GUID.valueOf((String)formId);
                HDForm form = FormsManager.getInstance().getForm(id);
                if (form == null) {
                    throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.error.formMissing", new Object[0])});
                }
                if (form.getSubmitType() != 3) {
                    throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.error.invalidFormType", new Object[0])});
                }
            }
            catch (IllegalArgumentException ex) {
                throw new ValidationException(new String[]{HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.error.formMissing", new Object[0])});
            }
        }
    }

    public SummaryInfo getSummary(@Nonnull TriggerDefinition definition) {
        String when = definition.getProperties().getOrDefault(PROPERTY_WHEN_TO_TRIGGER, WHEN_TO_TRIGGER_ANY);
        ArrayList<SummaryEntry> entries = new ArrayList<SummaryEntry>();
        if (WHEN_TO_TRIGGER_ANY.equals(when)) {
            entries.add(new SummaryEntry(null, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.summary.any", new Object[0])));
        } else {
            String formId;
            String formName = formId = (String)definition.getProperties().get(PROPERTY_FORM_ID);
            try {
                HDForm form = FormsManager.getInstance().getForm(GUID.valueOf((String)formId));
                formName = form != null ? form.getName() : HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.summary.deleted", new Object[0]);
            }
            catch (Exception ignore) {
                formName = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.summary.deleted", new Object[0]);
            }
            entries.add(new SummaryEntry(null, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("FormsTrigger.summary.specific", new Object[]{formName})));
        }
        return new SummaryInfo(entries);
    }

    public List<ZonedDateTime> getNextExecutionTimes(TriggerDefinition definition) {
        return super.getNextExecutionTimes(definition);
    }

    protected Trigger createInstanceFrom(@Nonnull TriggerDefinition definition, @Nullable GUID taskID) {
        return new FormsTrigger(definition, taskID);
    }

    public boolean isAvailable() {
        UserAccount current = UserManager.getInstance().getCurrentUserAccount();
        return current != null && HDUsersAndGroups.isSupporter((UserAccount)current);
    }
}

