/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.series.ticketcreated;

import com.inet.annotations.InternalApi;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerDataListener;
import com.inet.helpdesk.plugins.taskplanner.server.TicketFilterChecker;
import com.inet.helpdesk.plugins.taskplanner.server.TicketIterator;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.TaskExecution;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.series.Series;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@InternalApi
public class TicketCreatedSeries
implements Series {
    public static final String PROPERTY_FILTER_TYPE = "FilterType";
    public static final String PROPERTY_FILTER_TYPE_NONE = "FilterTypeNone";
    public static final String PROPERTY_FILTER_TYPE_CATEGORY = "FilterTypeCategory";
    public static final String PROPERTY_FILTER_TYPE_RESOURCE = "FilterTypeResource";
    public static final String PROPERTY_FILTER_TYPE_CUSTOMER_LOCATION = "FilterTypeCustomerLocation";
    public static final String PROPERTY_FILTER_TYPE_PROCESS_FILTER = "FilterTypeProcessFilter";
    public static final String PROPERTY_PROCESS_FILTER_NONE = "ProcessFilter.none";
    public static final String PROPERTY_PROCESS_FILTER_ANY = "ProcessFilter.anyprocess";
    public static final String PROPERTY_PROCESS_FILTER_SPECIFIC = "ProcessFilter.specific";
    public static final String PROPERTY_PROCESS = "PropProcess";
    public static String PROPERTY_CATEGORY = "Category";
    public static String PROPERTY_CUSTOMER_LOCATION = "CustomerLocation";
    public static final String PLACEHOLDER_TICKET_IDS = "{Ticket ID}";
    private GUID guid;
    private TicketFilterChecker filterChecker;
    private long timeWhenIteratorFinished = 0L;
    private Map<Integer, Boolean> knownTicketIds = new HashMap<Integer, Boolean>();

    public TicketCreatedSeries(GUID guid, SeriesDefinition definition) {
        this.guid = guid;
        this.filterChecker = new TicketFilterChecker(definition.getProperties());
    }

    public void cleanUp(boolean previewOnly) throws Exception {
        if (!previewOnly) {
            this.callCleanUp(this.guid, this.timeWhenIteratorFinished);
        }
    }

    protected void callCleanUp(GUID guid, long timeWhenIteratorFinished) {
        this.getTaskPlannerDataListener().cleanUp(guid, timeWhenIteratorFinished);
        this.clearCachedKnownTickets();
    }

    public Iterator<Map<String, String>> iterator() {
        TaskExecution execution = TaskPlanner.getInstance().getTaskExecution(this.guid);
        GUID currentUser = execution != null && execution.getOwnerId() != null ? execution.getOwnerId() : UserManager.getInstance().getCurrentUserAccountID();
        try (UserAccountScope scope = UserAccountScope.create((GUID)currentUser);){
            TicketIterator ticketIterator = new TicketIterator(new TicketIterator.TicketListProvider(){

                @Override
                public void registerIteratorFinished(long when) {
                    TicketCreatedSeries.this.timeWhenIteratorFinished = when;
                }

                @Override
                public HDTaskPlannerDataListener.TicketEvent getNextTicketAfter(long lastMarker) {
                    return TicketCreatedSeries.this.getNextTicketAfter(lastMarker);
                }
            }, this.getTicketsProviderMonitor());
            return ticketIterator;
        }
    }

    private HDTaskPlannerDataListener.TicketEvent getNextTicketAfter(long lastTicketId) {
        return this.getTaskPlannerDataListener().getNextCreatedTicketAfter(this.guid, lastTicketId, ticketId -> {
            boolean result = this.isInFilter((Integer)ticketId);
            this.knownTicketIds.put((Integer)ticketId, result);
            return result;
        });
    }

    protected HDTaskPlannerDataListener getTaskPlannerDataListener() {
        return HDTaskPlannerDataListener.getRegisteredInstance();
    }

    protected Object getTicketsProviderMonitor() {
        return this.getTaskPlannerDataListener();
    }

    protected void clearCachedKnownTickets() {
        this.knownTicketIds.clear();
    }

    private boolean isInFilter(Integer ticketId) {
        UserAccount user = UserManager.getInstance().getCurrentUserAccount();
        if (user == null) {
            HDLogger.warn((Object)"TriggerTicketDataChangeListener: no current user - no ticket list");
            return false;
        }
        Boolean known = this.knownTicketIds.get(ticketId);
        if (known != null) {
            return known;
        }
        try {
            TicketVO ticket = TicketManager.getReader().getTicket(ticketId.intValue());
            return this.filterChecker.check(this.getServerValuesConnector(), ticket, user);
        }
        catch (AccessDeniedException e) {
            return false;
        }
    }

    protected ServerValuesConnector getServerValuesConnector() {
        return (ServerValuesConnector)ServerPluginManager.getInstance().getSingleInstance(ServerValuesConnector.class);
    }
}

