/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.job.hdformula;

import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.report.Engine;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.Trigger;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import com.inet.taskplanner.server.api.job.ResultContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class HDFormulaJob
extends Job {
    public static final String PROPERTY_FORMULA = "hdformula";
    private final String formula;
    private String wasResult;

    public HDFormulaJob(JobDefinition definition) {
        super(definition.getCondition());
        this.formula = definition.getProperty(PROPERTY_FORMULA);
    }

    private void executeReport(@Nonnull Map<String, String> metaProperties) throws ReportException, IOException {
        Engine eng = RDC.createEmptyEngine((String)"java");
        Fields fields = eng.getFields();
        FormulaField formula = fields.addFormulaField("trigger", this.formula, 3);
        if (FormulaField.checkFormula((String)this.formula, (boolean)false, (Engine)eng) == -1) {
            throw new ReportException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("HDFormula.invalidFormula", new Object[0]), 0);
        }
        Trigger trigger = eng.getTrigger();
        trigger.setFormula(formula);
        eng.execute();
        eng.getPageCount();
        String result = String.valueOf(trigger.getResult());
        this.wasResult = result;
        metaProperties.put(PROPERTY_FORMULA, result);
    }

    protected JobResultContainer run() throws TaskExecutionException {
        HashMap<String, String> metaProperties = new HashMap<String, String>();
        try {
            this.executeReport(metaProperties);
        }
        catch (ReportException | IOException e) {
            throw new TaskExecutionException(e);
        }
        return new ResultContainer(new ArrayList(), metaProperties);
    }

    protected boolean evaluateCondition(ConditionDefinition conditionDefinition) {
        String conditionValue = conditionDefinition.getProperty("VALUE_CONDITION");
        return conditionValue != null && conditionValue.equals(this.wasResult);
    }
}

