/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.job.changeclassification;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.WithAdditionalReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholderUtils;
import com.inet.helpdesk.plugins.taskplanner.server.HDTaskPlannerUtils;
import com.inet.helpdesk.plugins.taskplanner.server.series.ticketswithstatus.TicketsWithStatusSeries;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.taskplanner.server.api.error.TaskExecutionException;
import com.inet.taskplanner.server.api.job.ConditionDefinition;
import com.inet.taskplanner.server.api.job.Job;
import com.inet.taskplanner.server.api.job.JobDefinition;
import com.inet.taskplanner.server.api.job.JobResultContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ChangeClassificationJob
extends Job {
    private final List<Integer> ticketIds;
    private final Integer classification;
    private GUID taskID;

    public ChangeClassificationJob(JobDefinition definition, @Nullable GUID taskID) {
        super(definition.getCondition());
        this.taskID = taskID;
        Map properties = definition.getProperties();
        this.classification = Integer.valueOf(properties.getOrDefault(Tickets.FIELD_CLASSIFICATION_ID.getKey(), "-1"));
        String ticketIdString = properties.getOrDefault("Ticket ID", "-1");
        if (ticketIdString != null && ticketIdString.contains("Ticket ID")) {
            throw new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicketIDPlaceholder", new Object[0]));
        }
        this.ticketIds = ticketIdString == null ? new ArrayList() : HDPlaceholderUtils.getTicketIds(ticketIdString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JobResultContainer run() throws TaskExecutionException {
        HashSet<Integer> changedIds = (HashSet<Integer>)TicketsWithStatusSeries.TICKET_IDS_CHANGED_BY_THIS_TASK.get();
        if (changedIds == null) {
            changedIds = new HashSet<Integer>();
        }
        ArrayList<Exception> toThrow = new ArrayList<Exception>();
        for (Integer ticketId : this.ticketIds) {
            try {
                TicketVO ticket;
                changedIds.add(ticketId);
                TicketsWithStatusSeries.TICKET_IDS_CHANGED_BY_THIS_TASK.set(changedIds);
                try {
                    ticket = TicketManager.getReader().getTicket(ticketId.intValue());
                }
                catch (AccessDeniedException e) {
                    toThrow.add((Exception)new TaskExecutionException((Throwable)e));
                    continue;
                }
                if (ticket == null) {
                    toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalStateException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ErrorNoTicket", new Object[]{ticketId}))));
                    continue;
                }
                if (ticket.getStatusID() >= 300) {
                    toThrow.add((Exception)new TaskExecutionException((Throwable)new IllegalArgumentException(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("TicketNotOpenError", new Object[]{ticketId}))));
                    continue;
                }
                if (ticket.isSlaveInBundle()) continue;
                Object object = HelpDeskTaskPlannerServerPlugin.TICKET_DATA_CONNECTOR_LOCK;
                synchronized (object) {
                    try (WithAdditionalReaStepData addReaStepData = WithAdditionalReaStepData.create((ReaStepField)ReaStepVO.FIELD_TASKPLANNER_TASKID, (Object)this.taskID);){
                        TicketManipulator tm = TicketManager.getManipulator();
                        MutableTicketData ticketData = new MutableTicketData();
                        ticketData.put((TicketField)Tickets.FIELD_CLASSIFICATION_ID, (Object)this.classification);
                        tm.updateTicketData(ticketId.intValue(), ticketData);
                    }
                }
            }
            catch (Exception e) {
                toThrow.add(e);
            }
        }
        if (toThrow.size() > 0) {
            throw HDTaskPlannerUtils.combinedException(toThrow);
        }
        return null;
    }

    protected boolean evaluateCondition(ConditionDefinition conditionDefinition) {
        return false;
    }
}

