/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server;

import com.inet.config.ConfigValue;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.ticketmanager.fielddefinitions.AbstractTicketFieldDefinitionForTicketOwner;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.plugins.taskplanner.server.placeholder.PlaceholderProvider;
import com.inet.http.servlet.ClientLocale;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.DynamicExtension;
import com.inet.plugin.DynamicExtensionManager;
import com.inet.taskplanner.server.api.TaskDefinition;
import com.inet.taskplanner.server.api.TaskPlanner;
import com.inet.taskplanner.server.api.field.TextField;
import com.inet.taskplanner.server.api.series.SeriesDefinition;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.FieldDefinition;
import com.inet.usersandgroups.api.ui.fields.user.UserFieldDefinition;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Font;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public interface HDPlaceholders {
    public static final ConfigValue<String> DEFAULT_TICKET_FONT_NAME_VALUE = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_FONT_NAME);
    public static final ConfigValue<Integer> DEFAULT_TICKET_FONT_SIZE_VALUE = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE);
    public static final DynamicExtension<UserField> userFields = new DynamicExtension(UserField.class);
    public static final String PROPERTY_PLACEHOLDER_TICKET_IDS = "Ticket ID";
    public static final String PROPERTY_PLACEHOLDER_OWNER_EMAIL = "owner.email";
    public static final String PROPERTY_PLACEHOLDER_OWNER_GUID = "owner.id";
    public static final String PROPERTY_PLACEHOLDER_OWNER_DISPLAY_NAME = "owner.name";
    public static final String PROPERTY_PLACEHOLDER_OWNER_CUSTOM_1 = "owner.custom1";
    public static final String PROPERTY_PLACEHOLDER_OWNER_CUSTOM_2 = "owner.custom2";
    public static final String PROPERTY_PLACEHOLDER_OWNER_CUSTOM_3 = "owner.custom3";
    public static final String PROPERTY_PLACEHOLDER_OWNER_CUSTOM_4 = "owner.custom4";
    public static final String PROPERTY_PLACEHOLDER_OWNER_CUSTOM_5 = "owner.custom5";
    public static final String PROPERTY_PLACEHOLDER_OWNER_CUSTOM_6 = "owner.custom6";
    public static final String PROPERTY_PLACEHOLDER_OWNER_LINK = "owner.link";
    public static final String PROPERTY_PLACEHOLDER_OWNER_LOCATION = "owner.location";
    public static final String PROPERTY_PLACEHOLDER_OWNER_USER_CLASS = "owner.userclass";
    public static final String PROPERTY_PLACEHOLDER_OWNER_TELEPHONE = "owner.telephone";
    public static final String PROPERTY_PLACEHOLDER_OWNER_ROOM = "owner.room";
    public static final String PROPERTY_PLACEHOLDER_OWNER_DEPARTMENT = "owner.department";
    public static final String PROPERTY_PLACEHOLDER_OWNER_LANGUAGE = "owner.language";
    public static final String PROPERTY_PLACEHOLDER_OWNER_COMPUTER_NAME = "owner.computername";
    public static final String PROPERTY_PLACEHOLDER_OWNER_CLIENT_DETAILS = "owner.clientdetails";
    public static final String PROPERTY_PLACEHOLDER_OWNER_COST_CENTRE = "owner.costcenter";
    public static final String PROPERTY_PLACEHOLDER_OWNER_NOTE = "owner.note";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_EMAIL = "creator.email";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_GUID = "creator.id";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_DISPLAY_NAME = "creator.name";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_1 = "creator.custom1";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_2 = "creator.custom2";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_3 = "creator.custom3";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_4 = "creator.custom4";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_5 = "creator.custom5";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_6 = "creator.custom6";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_LINK = "creator.link";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_LOCATION = "creator.location";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_USER_CLASS = "creator.userclass";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_TELEPHONE = "creator.telephone";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_ROOM = "creator.room";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_DEPARTMENT = "creator.department";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_LANGUAGE = "creator.language";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_COMPUTER_NAME = "creator.computername";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_CLIENT_DETAILS = "creator.clientdetails";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_COST_CENTRE = "creator.costcenter";
    public static final String PROPERTY_PLACEHOLDER_CREATOR_NOTE = "creator.note";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_EMAIL = "lasteditor.email";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_GUID = "lasteditor.id";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_DISPLAY_NAME = "lasteditor.name";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_1 = "lasteditor.custom1";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_2 = "lasteditor.custom2";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_3 = "lasteditor.custom3";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_4 = "lasteditor.custom4";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_5 = "lasteditor.custom5";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_6 = "lasteditor.custom6";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_LINK = "lasteditor.link";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_LOCATION = "lasteditor.location";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_USER_CLASS = "lasteditor.userclass";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_TELEPHONE = "lasteditor.telephone";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_ROOM = "lasteditor.room";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_DEPARTMENT = "lasteditor.department";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_LANGUAGE = "lasteditor.language";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_COMPUTER_NAME = "lasteditor.computername";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_CLIENT_DETAILS = "lasteditor.clientdetails";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_COST_CENTRE = "lasteditor.costcenter";
    public static final String PROPERTY_PLACEHOLDER_LAST_EDITOR_NOTE = "lasteditor.note";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_DISPLAY_NAME = "dispatcher.name";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_EMAIL = "dispatcher.email";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_GUID = "dispatcher.id";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_1 = "dispatcher.custom1";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_2 = "dispatcher.custom2";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_3 = "dispatcher.custom3";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_4 = "dispatcher.custom4";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_5 = "dispatcher.custom5";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_6 = "dispatcher.custom6";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_LINK = "dispatcher.link";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_LOCATION = "dispatcher.location";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_USER_CLASS = "dispatcher.userclass";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_TELEPHONE = "dispatcher.telephone";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_ROOM = "dispatcher.room";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_DEPARTMENT = "dispatcher.department";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_LANGUAGE = "dispatcher.language";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_COMPUTER_NAME = "dispatcher.computername";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_CLIENT_DETAILS = "dispatcher.clientdetails";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_COST_CENTRE = "dispatcher.costcenter";
    public static final String PROPERTY_PLACEHOLDER_DISPATCHER_NOTE = "dispatcher.note";
    public static final String PROPERTY_PLACEHOLDER_TICKET_CATEGORY = "ticket.category";
    public static final String PROPERTY_PLACEHOLDER_TICKET_GUID = "ticket.guid";
    public static final String PROPERTY_PLACEHOLDER_TICKET_PRIORITY = "ticket.priority";
    public static final String PROPERTY_PLACEHOLDER_TICKET_RESOURCE_EMAIL = "ticket.resource.email";
    public static final String PROPERTY_PLACEHOLDER_TICKET_SUBJECT = "ticket.subject";
    public static final String PROPERTY_PLACEHOLDER_TICKET_INQUIRY_TEXT_PLAIN_TEXT = "ticket.inquirytext";
    public static final String PROPERTY_PLACEHOLDER_TICKET_INQUIRY_TEXT_HTML = "ticket.inquirytext.html";
    public static final String PROPERTY_PLACEHOLDER_TICKET_REA_STEP_HISTORY = "ticket.reastephistory";
    public static final String PROPERTY_PLACEHOLDER_TICKET_CLASSIFICATION = "ticket.classification";
    public static final String PROPERTY_PLACEHOLDER_TICKET_LINK = "ticket.link";
    public static final String PROPERTY_PLACEHOLDER_TICKETIDLONG = "ticket.ticketidlong";
    public static final String PROPERTY_PLACEHOLDER_ACTION_NAME = "action.name";
    public static final String PROPERTY_PLACEHOLDER_ACTION_ID = "action.id";
    public static final String PROPERTY_PLACEHOLDER_ACTION_WHEN = "action.when";
    public static final String PROPERTY_PLACEHOLDER_ACTION_WHEN_TIMESTAMP = "action.when.timestamp";
    public static final String PROPERTY_PLACEHOLDER_ACTION_USER = "action.user";
    public static final String PROPERTY_PLACEHOLDER_ACTION_USER_GUID = "action.user.id";
    public static final String PROPERTY_PLACEHOLDER_ACTION_DESCRIPTION = "action.stepdescription";
    public static final String PROPERTY_PLACEHOLDER_ACTION_BODY_TEXT_PLAIN = "action.steptext";
    public static final String PROPERTY_PLACEHOLDER_ACTION_BODY_TEXT_HTML = "action.steptext.html";
    public static final String PROPERTY_PLACEHOLDER_ACTION_EMAIL_SENDER = "action.emailsender";
    public static final Set<String> IDS_THAT_ARE_ACTUALLY_DISPLAY_NAMES = new HashSet<String>(Arrays.asList("ticket.categoryid", "ticket.classificationid", "ticket.itilid", "ticket.lastchangedbyid", "ticket.ownerid", "ticket.priorityid", "ticket.statusid", "ticket.resourceid", "ticket.lasteditorid"));

    public static List<String> getHDPlaceholderKeys() {
        ArrayList<String> placeholderKeys = new ArrayList<String>();
        List fieldDefinitionsRaw = DynamicExtensionManager.getInstance().get(FieldDefinition.class);
        Set visibleUserFieldKeys = fieldDefinitionsRaw.stream().sorted(Comparator.comparingInt(FieldDefinition::getPriority)).filter(f -> f instanceof UserFieldDefinition && f.getFieldKey() != null && f.getLabel() != null && !f.getLabel().isBlank() && ((UserFieldDefinition)f).isAvailable(UserManager.getInstance().getCurrentUserAccount())).map(f -> f.getFieldKey()).collect(Collectors.toSet());
        placeholderKeys.add(PROPERTY_PLACEHOLDER_TICKET_IDS);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_TICKET_GUID);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_TICKET_LINK);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_TICKETIDLONG);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_TICKET_INQUIRY_TEXT_PLAIN_TEXT);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_TICKET_INQUIRY_TEXT_HTML);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_TICKET_REA_STEP_HISTORY);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_GUID);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_TICKET_RESOURCE_EMAIL);
        if (visibleUserFieldKeys.contains("firstname") || visibleUserFieldKeys.contains("lastname") || visibleUserFieldKeys.contains("email")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_DISPLAY_NAME);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_DISPLAY_NAME);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_DISPLAY_NAME);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_DISPLAY_NAME);
        }
        if (visibleUserFieldKeys.contains("email")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_EMAIL);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_EMAIL);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_EMAIL);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_EMAIL);
        }
        if (visibleUserFieldKeys.contains("custom1")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_CUSTOM_1);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_1);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_1);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_1);
        }
        if (visibleUserFieldKeys.contains("custom2")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_CUSTOM_2);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_2);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_2);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_2);
        }
        if (visibleUserFieldKeys.contains("custom3")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_CUSTOM_3);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_3);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_3);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_3);
        }
        if (visibleUserFieldKeys.contains("custom4")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_CUSTOM_4);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_4);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_4);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_4);
        }
        if (visibleUserFieldKeys.contains("custom5")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_CUSTOM_5);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_5);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_5);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_5);
        }
        if (visibleUserFieldKeys.contains("custom6")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_CUSTOM_6);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_CUSTOM_6);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_CUSTOM_6);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_CUSTOM_6);
        }
        if (visibleUserFieldKeys.contains("location")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_LOCATION);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_LOCATION);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_LOCATION);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_LOCATION);
        }
        if (visibleUserFieldKeys.contains("telephone")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_TELEPHONE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_TELEPHONE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_TELEPHONE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_TELEPHONE);
        }
        if (visibleUserFieldKeys.contains("room")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_ROOM);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_ROOM);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_ROOM);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_ROOM);
        }
        if (visibleUserFieldKeys.contains("department")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_DEPARTMENT);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_DEPARTMENT);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_DEPARTMENT);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_DEPARTMENT);
        }
        if (visibleUserFieldKeys.contains("language")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_LANGUAGE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_LANGUAGE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_LANGUAGE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_LANGUAGE);
        }
        if (visibleUserFieldKeys.contains("computername")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_COMPUTER_NAME);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_COMPUTER_NAME);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_COMPUTER_NAME);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_COMPUTER_NAME);
        }
        if (visibleUserFieldKeys.contains("clientdetails")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_CLIENT_DETAILS);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_CLIENT_DETAILS);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_CLIENT_DETAILS);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_CLIENT_DETAILS);
        }
        if (visibleUserFieldKeys.contains("costcentre")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_COST_CENTRE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_COST_CENTRE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_COST_CENTRE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_COST_CENTRE);
        }
        if (visibleUserFieldKeys.contains("note")) {
            placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_NOTE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_NOTE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_NOTE);
            placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_NOTE);
        }
        placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_LINK);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_OWNER_USER_CLASS);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_GUID);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_LINK);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_CREATOR_USER_CLASS);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_GUID);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_LINK);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_DISPATCHER_USER_CLASS);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_GUID);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_LINK);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_LAST_EDITOR_USER_CLASS);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_ACTION_NAME);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_ACTION_ID);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_ACTION_WHEN);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_ACTION_WHEN_TIMESTAMP);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_ACTION_DESCRIPTION);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_ACTION_USER);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_ACTION_USER_GUID);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_ACTION_EMAIL_SENDER);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_ACTION_BODY_TEXT_HTML);
        placeholderKeys.add(PROPERTY_PLACEHOLDER_ACTION_BODY_TEXT_PLAIN);
        List placeholderProviders = DynamicExtensionManager.getInstance().get(PlaceholderProvider.class);
        placeholderProviders.forEach(p -> p.getAdditionalPlaceholderKeys().forEach(placeholderKeys::add));
        List ticketFieldDefinitions = DynamicExtensionManager.getInstance().get(TicketFieldDefinition.class);
        ticketFieldDefinitions.forEach(d -> {
            if (!(d instanceof AbstractTicketFieldDefinitionForTicketOwner)) {
                String ticketPlaceholderKey = "ticket." + d.getKey();
                if (IDS_THAT_ARE_ACTUALLY_DISPLAY_NAMES.contains(ticketPlaceholderKey)) {
                    ticketPlaceholderKey = "ticket." + d.getKey().substring(0, d.getKey().length() - 2) + ".displayname";
                }
                placeholderKeys.add(ticketPlaceholderKey);
            }
        });
        List userFieldDefinitions = userFields.get();
        userFieldDefinitions.stream().filter(f -> f.isCustomField() && f.getValueType() == String.class && visibleUserFieldKeys.contains(f.getKey())).forEach(d -> {
            String dispatcherKey = "dispatcher.custom." + d.getKey();
            placeholderKeys.add(dispatcherKey);
            String ownerKey = "owner.custom." + d.getKey();
            placeholderKeys.add(ownerKey);
            String lastEditorKey = "lasteditor.custom." + d.getKey();
            placeholderKeys.add(lastEditorKey);
            String creatorKey = "creator.custom." + d.getKey();
            placeholderKeys.add(creatorKey);
        });
        return placeholderKeys;
    }

    public static void setPlaceholderDynamicallyForTextFieldInAction(GUID taskID, TextField textField) {
        TaskDefinition taskDefinition = taskID == null ? null : TaskPlanner.getInstance().getTaskDefinition(taskID);
        boolean hasPlaceholderSquiggly = false;
        boolean hasPlaceholderSquare = false;
        if (taskDefinition != null) {
            ArrayList<String> squigglyTriggers = new ArrayList<String>(){
                {
                    this.add("taskplanner.helpdesk");
                    this.add("trigger.helpdesk.statuschange");
                    this.add("trigger.helpdesk.processstarted");
                }
            };
            ArrayList<String> squigglySeries = new ArrayList<String>(){
                {
                    this.add("series.helpdesk.process-started");
                    this.add("series.helpdesk.target-time-passed");
                    this.add("series.helpdesk.ticketcreated");
                    this.add("series.helpdesk.tickets-with-status");
                }
            };
            SeriesDefinition series = taskDefinition.getSeries();
            if (taskDefinition.getTriggers().stream().anyMatch(t -> squigglyTriggers.contains(t.getExtensionName()))) {
                hasPlaceholderSquiggly = true;
            } else if (series != null && squigglySeries.contains(taskDefinition.getSeries().getExtensionName())) {
                hasPlaceholderSquiggly = true;
            }
            if (taskDefinition.getJobs().stream().anyMatch(j -> "quickticket.taskplanner.createfromquickticketjob".equals(j.getExtensionName()))) {
                hasPlaceholderSquare = true;
            }
        }
        if (hasPlaceholderSquiggly || !hasPlaceholderSquare) {
            textField.setValue("{Ticket ID}");
        } else {
            textField.setValue("[Ticket ID]");
        }
    }

    public static Map<String, String> fillActionPlaceholderValuesFor(ActionVO action, ReaStepVO reaStepData, ReaStepTextVO reaStepText) {
        String plainText;
        Object htmlText;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PROPERTY_PLACEHOLDER_ACTION_NAME, action.getDisplayValue());
        props.put(PROPERTY_PLACEHOLDER_ACTION_ID, action.getUniqueID());
        long reaStepDate = reaStepData != null ? reaStepData.getEndDate() : System.currentTimeMillis();
        String whenString = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.SHORT).withLocale(ClientLocale.getThreadLocale()).format(ZonedDateTime.ofInstant(new Date(reaStepDate).toInstant(), ZoneId.systemDefault()));
        props.put(PROPERTY_PLACEHOLDER_ACTION_WHEN, whenString);
        String displayName = reaStepData != null ? (String)reaStepData.getValue((ReaStepField)ReaStepVO.FIELD_USER_DISPLAY_NAME) : "";
        props.put(PROPERTY_PLACEHOLDER_ACTION_WHEN_TIMESTAMP, "" + reaStepDate);
        props.put(PROPERTY_PLACEHOLDER_ACTION_USER, displayName);
        String description = reaStepData != null ? reaStepData.getDescription() : "";
        props.put(PROPERTY_PLACEHOLDER_ACTION_DESCRIPTION, description);
        if (reaStepText.hasHtmlContent()) {
            htmlText = reaStepText.getText();
            plainText = HtmlConverter.html2text((String)htmlText);
        } else {
            plainText = reaStepText.getText();
            htmlText = HtmlConverter.text2html((String)plainText, (Font)HDPlaceholders.getDefaultFont());
        }
        if (htmlText != null && !((String)htmlText).toLowerCase().startsWith("<html>")) {
            htmlText = "<html>" + (String)htmlText + "</html>";
        }
        props.put(PROPERTY_PLACEHOLDER_ACTION_BODY_TEXT_PLAIN, plainText);
        props.put(PROPERTY_PLACEHOLDER_ACTION_BODY_TEXT_HTML, (String)htmlText);
        String sender = reaStepData != null ? (String)reaStepData.getValue((ReaStepField)ReaStepVO.FIELD_EMAIL_IN) : "";
        GUID userId = reaStepData != null ? reaStepData.getUserID() : null;
        props.put(PROPERTY_PLACEHOLDER_ACTION_USER_GUID, userId != null ? userId.toString() : "");
        props.put(PROPERTY_PLACEHOLDER_ACTION_EMAIL_SENDER, sender != null ? sender : "");
        List placeholderProviders = DynamicExtensionManager.getInstance().get(PlaceholderProvider.class);
        placeholderProviders.forEach(p -> p.getPlaceholderValuesFor(action, reaStepData, reaStepText).entrySet().forEach(e -> props.put((String)e.getKey(), (String)e.getValue())));
        return props;
    }

    public static Font getDefaultFont() {
        String fontName = (String)DEFAULT_TICKET_FONT_NAME_VALUE.get();
        int fontSize = (Integer)DEFAULT_TICKET_FONT_SIZE_VALUE.get();
        if (StringFunctions.isEmpty((String)fontName)) {
            fontName = HDConfigKeys.DEFAULT_TICKET_FONT_NAME.getDefault();
        }
        if (fontSize <= 0) {
            fontSize = Integer.parseInt(HDConfigKeys.DEFAULT_TICKET_FONT_SIZE.getDefault());
        }
        return new Font(fontName, 0, fontSize);
    }
}

