/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.taskplanner.server.trigger.processstarted;

import com.inet.config.structure.model.LocalizedKey;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtension;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.extension.TicketSubOperations;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.plugins.taskplanner.HelpDeskTaskPlannerServerPlugin;
import com.inet.helpdesk.plugins.taskplanner.server.HDPlaceholders;
import com.inet.helpdesk.plugins.taskplanner.server.trigger.processstarted.ProcessStartedTrigger;
import com.inet.helpdesk.plugins.ticketprocess.server.api.TicketProcessManager;
import com.inet.helpdesk.plugins.ticketprocess.server.api.model.TicketProcess;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.taskplanner.server.api.common.SummaryEntry;
import com.inet.taskplanner.server.api.common.SummaryInfo;
import com.inet.taskplanner.server.api.error.ValidationException;
import com.inet.taskplanner.server.api.field.Field;
import com.inet.taskplanner.server.api.field.FieldCondition;
import com.inet.taskplanner.server.api.field.SelectField;
import com.inet.taskplanner.server.api.trigger.Trigger;
import com.inet.taskplanner.server.api.trigger.TriggerDefinition;
import com.inet.taskplanner.server.api.trigger.TriggerFactory;
import com.inet.taskplanner.server.api.trigger.TriggerInfo;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.text.Collator;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProcessStartedTriggerFactory
extends TriggerFactory<Trigger>
implements TicketActionExtensionFactory {
    public static final String EXTENSION_NAME = "trigger.helpdesk.processstarted";
    static final String ON_PROCESS_END = "ProcessStartedTrigger.OnProcessEnd";
    static final String ON_PROCESS_START = "ProcessStartedTrigger.OnProcessStart";
    private List<ProcessStartedTrigger> listeners = new ArrayList<ProcessStartedTrigger>();
    public static final String PROPERTY_ACTIVITY_FILTER = "activityFilter";
    static TicketProcessManager tpmInstance;

    private static TicketProcessManager getTPMInstance() {
        if (tpmInstance != null) {
            return tpmInstance;
        }
        return (TicketProcessManager)ServerPluginManager.getInstance().getSingleInstance(TicketProcessManager.class);
    }

    public ProcessStartedTriggerFactory() {
        super(EXTENSION_NAME);
    }

    public TriggerInfo getInformation(@Nullable GUID guid) {
        URL iconURL = ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/plugins/taskplanner/structure/ticketprocesstrigger_32.png");
        ArrayList<SelectField> fields = new ArrayList<SelectField>();
        ArrayList<LocalizedKey> values = new ArrayList<LocalizedKey>();
        values.add(new LocalizedKey("", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter.any", new Object[0])));
        TicketProcessManager ticketProcessManager = ProcessStartedTriggerFactory.getTPMInstance();
        List processes = ticketProcessManager.getProcesses();
        SelectField processField = new SelectField("processFilter", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessFilter", new Object[0]), values);
        processes.stream().sorted(new Comparator<TicketProcess>(){

            @Override
            public int compare(TicketProcess o1, TicketProcess o2) {
                Collator collator = Collator.getInstance();
                collator.setStrength(1);
                collator.setDecomposition(1);
                return collator.compare(o1.getName(), o2.getName());
            }
        }).forEach(p -> {
            values.add(new LocalizedKey(p.getId().toString(), p.getName()));
            List<FieldCondition> visibleCondition = Arrays.asList(FieldCondition.visible((Field)processField, (FieldCondition.OP)FieldCondition.OP.equals, (String)p.getId().toString()));
            ArrayList<LocalizedKey> activityValues = this.getActivitiesAsLocalizedKeys((TicketProcess)p, "ProcessStartedTrigger.Reaching");
            activityValues.add(0, new LocalizedKey(ON_PROCESS_END, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(ON_PROCESS_END, new Object[0])));
            activityValues.add(0, new LocalizedKey(ON_PROCESS_START, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(ON_PROCESS_START, new Object[0])));
            SelectField selectField = new SelectField("activityFilter." + p.getId().toString(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ActivityFilter", new Object[0]), activityValues);
            selectField.setValue(ON_PROCESS_START);
            selectField.setConditions(visibleCondition);
            fields.add(selectField);
        });
        ArrayList<LocalizedKey> anyValues = new ArrayList<LocalizedKey>();
        anyValues.add(new LocalizedKey(ON_PROCESS_START, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(ON_PROCESS_START, new Object[0])));
        anyValues.add(new LocalizedKey(ON_PROCESS_END, HelpDeskTaskPlannerServerPlugin.MSG.getMsg(ON_PROCESS_END, new Object[0])));
        SelectField selectField = new SelectField("activityFilter.", HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ActivityFilter", new Object[0]), anyValues);
        selectField.setValue(ON_PROCESS_START);
        selectField.setConditions(Arrays.asList(FieldCondition.visible((Field)processField, (FieldCondition.OP)FieldCondition.OP.equals, (String)"")));
        fields.add(selectField);
        processField.setValue("");
        fields.add(0, processField);
        return new TriggerInfo(EXTENSION_NAME, HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.name", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.desc", new Object[0]), iconURL, "taskplanner.trigger.process-started", fields, HDPlaceholders.getHDPlaceholderKeys());
    }

    private ArrayList<LocalizedKey> getActivitiesAsLocalizedKeys(TicketProcess p, String msgWrapper) {
        if (p == null) {
            return new ArrayList<LocalizedKey>();
        }
        HashMap activities = new HashMap();
        activities.put(p.getName(), new ArrayList(p.getActivities()));
        p.getParallelTickets().forEach(parallel -> activities.put(parallel.getName(), new ArrayList(parallel.getActivities())));
        boolean hasParallel = !p.getParallelTickets().isEmpty();
        return activities.entrySet().stream().sorted((o1, o2) -> ((String)o1.getKey()).equals(p.getName()) ? -1 : (((String)o2.getKey()).equals(p.getName()) ? 1 : ((String)o1.getKey()).compareTo((String)o2.getKey()))).flatMap(e -> ((List)e.getValue()).stream().map(a -> {
            String ticketName = (String)e.getKey();
            String activityName = a.getName();
            String label = hasParallel ? HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.ReachedActivity.Parallel", new Object[]{activityName, ticketName}) : HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.ReachedActivity", new Object[]{activityName});
            return new LocalizedKey(a.getId().toString(), HelpDeskTaskPlannerServerPlugin.MSG.getMsg(msgWrapper, new Object[]{label}));
        })).collect(Collectors.toCollection(ArrayList::new));
    }

    public void validate(@Nonnull TriggerDefinition definition, GUID guid) throws ValidationException {
    }

    public SummaryInfo getSummary(@Nonnull TriggerDefinition definition) {
        String s;
        ArrayList<SummaryEntry> summary = new ArrayList<SummaryEntry>();
        String id = definition.getProperties().getOrDefault("processFilter", "");
        String activity = definition.getProperties().getOrDefault("activityFilter." + id, ON_PROCESS_START);
        TicketProcessManager ticketProcessManager = ProcessStartedTriggerFactory.getTPMInstance();
        TicketProcess process = id.isBlank() ? null : ticketProcessManager.getProcess(GUID.valueOf((String)id));
        ArrayList<LocalizedKey> activitiesAsLocalizedKeys = this.getActivitiesAsLocalizedKeys(process, "ProcessStartedTrigger.summary.activity.desc");
        String activityName = activitiesAsLocalizedKeys.stream().filter(l -> l.getKey().equals(activity)).map(LocalizedKey::getDisplayName).findFirst().orElse(null);
        String string = s = process == null ? null : process.getName();
        if (s == null || s.trim().isEmpty()) {
            if (ON_PROCESS_START.equals(activity)) {
                summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.label", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.desc", new Object[0])));
            } else {
                summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.label", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.ended.desc", new Object[0])));
            }
        } else if (ON_PROCESS_START.equals(activity)) {
            summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.label", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.desc.filtered", new Object[]{s})));
        } else if (ON_PROCESS_END.equals(activity)) {
            summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.label", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.ended.desc.filtered", new Object[]{s})));
        } else if (activityName != null) {
            summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.label", new Object[0]), activityName));
        } else {
            String deletedValueLabel = HelpDeskTaskPlannerServerPlugin.MSG.getMsg("CategoryNoLonger", new Object[0]);
            summary.add(new SummaryEntry(HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.label", new Object[0]), HelpDeskTaskPlannerServerPlugin.MSG.getMsg("ProcessStartedTrigger.summary.activity.desc", new Object[]{deletedValueLabel})));
        }
        return new SummaryInfo(summary);
    }

    public List<ZonedDateTime> getNextExecutionTimes(TriggerDefinition definition) {
        return super.getNextExecutionTimes(definition);
    }

    protected Trigger createInstanceFrom(@Nonnull TriggerDefinition definition, @Nullable GUID taskID) {
        String processID = definition.getProperties().getOrDefault("processFilter", "");
        return new ProcessStartedTrigger(processID, definition.getProperties().getOrDefault("activityFilter." + processID, ""));
    }

    public TicketActionExtension createIfApplicable(OperationChangedTicket ticket, ActionVO action, ExtensionArguments arguments, MutableReaStepData reaStepFields) {
        final List collect = this.listeners.stream().map(trigger -> trigger.checkForProcessChange(ticket, action, arguments)).filter(Objects::nonNull).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return null;
        }
        if (collect.size() == 1) {
            return (TicketActionExtension)collect.get(0);
        }
        return new TicketActionExtension(){

            public void extendTicketAction(ActionVO action, OperationChangedTicket ticket, OperationNewReaStep reaStep, TicketSubOperations operations) {
                collect.forEach(c -> c.extendTicketAction(action, ticket, reaStep, operations));
            }
        };
    }

    public static ProcessStartedTriggerFactory getRegisteredInstance() {
        List ticketDataChangeListeners = ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class);
        ticketDataChangeListeners.removeIf(f -> !(f instanceof ProcessStartedTriggerFactory));
        if (ticketDataChangeListeners.size() > 0) {
            return (ProcessStartedTriggerFactory)((Object)ticketDataChangeListeners.get(0));
        }
        return null;
    }

    public static void addListener(ProcessStartedTrigger listener) {
        ProcessStartedTriggerFactory l = ProcessStartedTriggerFactory.getRegisteredInstance();
        if (l != null) {
            l.addSubListener(listener);
        }
    }

    public static void removeListener(ProcessStartedTrigger listener) {
        ProcessStartedTriggerFactory l = ProcessStartedTriggerFactory.getRegisteredInstance();
        if (l != null) {
            l.removeSubListener(listener);
        }
    }

    public void addSubListener(ProcessStartedTrigger t) {
        this.listeners.add(t);
    }

    public void removeSubListener(ProcessStartedTrigger t) {
        this.listeners.remove(t);
    }

    public boolean isAvailable() {
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return currentUserAccount != null && HDUsersAndGroups.isSupporter((UserAccount)currentUserAccount);
    }

    public int getExecutionPriority() {
        return Integer.MAX_VALUE;
    }
}

